package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ComponentsBuilder extends io.fabric8.openshift.api.model.operatorhub.v1.ComponentsFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1.ComponentsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operatorhub.v1.Components,io.fabric8.openshift.api.model.operatorhub.v1.ComponentsBuilder> {

    io.fabric8.openshift.api.model.operatorhub.v1.ComponentsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ComponentsBuilder() {
        this(true);
    }

    public ComponentsBuilder(java.lang.Boolean validationEnabled) {
        this(new Components(), validationEnabled);
    }

    public ComponentsBuilder(io.fabric8.openshift.api.model.operatorhub.v1.ComponentsFluent<?> fluent) {
        this(fluent, true);
    }

    public ComponentsBuilder(io.fabric8.openshift.api.model.operatorhub.v1.ComponentsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Components(), validationEnabled);
    }

    public ComponentsBuilder(io.fabric8.openshift.api.model.operatorhub.v1.ComponentsFluent<?> fluent,io.fabric8.openshift.api.model.operatorhub.v1.Components instance) {
        this(fluent, instance, true);
    }

    public ComponentsBuilder(io.fabric8.openshift.api.model.operatorhub.v1.ComponentsFluent<?> fluent,io.fabric8.openshift.api.model.operatorhub.v1.Components instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLabelSelector(instance.getLabelSelector()); 
        fluent.withRefs(instance.getRefs()); 
        this.validationEnabled = validationEnabled; 
    }

    public ComponentsBuilder(io.fabric8.openshift.api.model.operatorhub.v1.Components instance) {
        this(instance,true);
    }

    public ComponentsBuilder(io.fabric8.openshift.api.model.operatorhub.v1.Components instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLabelSelector(instance.getLabelSelector()); 
        this.withRefs(instance.getRefs()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operatorhub.v1.Components build() {
        Components buildable = new Components(fluent.getLabelSelector(),fluent.getRefs());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ComponentsBuilder that = (ComponentsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
