package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SpecDescriptorBuilder extends SpecDescriptorFluentImpl<SpecDescriptorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<SpecDescriptor,SpecDescriptorBuilder> {

    SpecDescriptorFluent<?> fluent;
    Boolean validationEnabled;

    public SpecDescriptorBuilder() {
        this(true);
    }

    public SpecDescriptorBuilder(Boolean validationEnabled) {
        this(new SpecDescriptor(), validationEnabled);
    }

    public SpecDescriptorBuilder(SpecDescriptorFluent<?> fluent) {
        this(fluent, true);
    }

    public SpecDescriptorBuilder(SpecDescriptorFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SpecDescriptor(), validationEnabled);
    }

    public SpecDescriptorBuilder(SpecDescriptorFluent<?> fluent,SpecDescriptor instance) {
        this(fluent, instance, true);
    }

    public SpecDescriptorBuilder(SpecDescriptorFluent<?> fluent,SpecDescriptor instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDescription(instance.getDescription()); 
        fluent.withDisplayName(instance.getDisplayName()); 
        fluent.withPath(instance.getPath()); 
        fluent.withValue(instance.getValue()); 
        fluent.withXDescriptors(instance.getXDescriptors()); 
        this.validationEnabled = validationEnabled; 
    }

    public SpecDescriptorBuilder(SpecDescriptor instance) {
        this(instance,true);
    }

    public SpecDescriptorBuilder(SpecDescriptor instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDescription(instance.getDescription()); 
        this.withDisplayName(instance.getDisplayName()); 
        this.withPath(instance.getPath()); 
        this.withValue(instance.getValue()); 
        this.withXDescriptors(instance.getXDescriptors()); 
        this.validationEnabled = validationEnabled; 
    }

    public SpecDescriptor build() {
        SpecDescriptor buildable = new SpecDescriptor(fluent.getDescription(),fluent.getDisplayName(),fluent.getPath(),fluent.getValue(),fluent.getXDescriptors());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SpecDescriptorBuilder that = (SpecDescriptorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
