package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NamedInstallStrategyBuilder extends NamedInstallStrategyFluentImpl<NamedInstallStrategyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<NamedInstallStrategy,NamedInstallStrategyBuilder> {

    NamedInstallStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public NamedInstallStrategyBuilder() {
        this(true);
    }

    public NamedInstallStrategyBuilder(Boolean validationEnabled) {
        this(new NamedInstallStrategy(), validationEnabled);
    }

    public NamedInstallStrategyBuilder(NamedInstallStrategyFluent<?> fluent) {
        this(fluent, true);
    }

    public NamedInstallStrategyBuilder(NamedInstallStrategyFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NamedInstallStrategy(), validationEnabled);
    }

    public NamedInstallStrategyBuilder(NamedInstallStrategyFluent<?> fluent,NamedInstallStrategy instance) {
        this(fluent, instance, true);
    }

    public NamedInstallStrategyBuilder(NamedInstallStrategyFluent<?> fluent,NamedInstallStrategy instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStrategy(instance.getStrategy()); 
        this.validationEnabled = validationEnabled; 
    }

    public NamedInstallStrategyBuilder(NamedInstallStrategy instance) {
        this(instance,true);
    }

    public NamedInstallStrategyBuilder(NamedInstallStrategy instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withSpec(instance.getSpec()); 
        this.withStrategy(instance.getStrategy()); 
        this.validationEnabled = validationEnabled; 
    }

    public NamedInstallStrategy build() {
        NamedInstallStrategy buildable = new NamedInstallStrategy(fluent.getSpec(),fluent.getStrategy());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NamedInstallStrategyBuilder that = (NamedInstallStrategyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
