package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IconBuilder extends IconFluentImpl<IconBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Icon,IconBuilder> {

    IconFluent<?> fluent;
    Boolean validationEnabled;

    public IconBuilder() {
        this(true);
    }

    public IconBuilder(Boolean validationEnabled) {
        this(new Icon(), validationEnabled);
    }

    public IconBuilder(IconFluent<?> fluent) {
        this(fluent, true);
    }

    public IconBuilder(IconFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Icon(), validationEnabled);
    }

    public IconBuilder(IconFluent<?> fluent,Icon instance) {
        this(fluent, instance, true);
    }

    public IconBuilder(IconFluent<?> fluent,Icon instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBase64data(instance.getBase64data()); 
        fluent.withMediatype(instance.getMediatype()); 
        this.validationEnabled = validationEnabled; 
    }

    public IconBuilder(Icon instance) {
        this(instance,true);
    }

    public IconBuilder(Icon instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBase64data(instance.getBase64data()); 
        this.withMediatype(instance.getMediatype()); 
        this.validationEnabled = validationEnabled; 
    }

    public Icon build() {
        Icon buildable = new Icon(fluent.getBase64data(),fluent.getMediatype());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IconBuilder that = (IconBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
