package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DependentStatusBuilder extends DependentStatusFluentImpl<DependentStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<DependentStatus,DependentStatusBuilder> {

    DependentStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DependentStatusBuilder() {
        this(true);
    }

    public DependentStatusBuilder(Boolean validationEnabled) {
        this(new DependentStatus(), validationEnabled);
    }

    public DependentStatusBuilder(DependentStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public DependentStatusBuilder(DependentStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DependentStatus(), validationEnabled);
    }

    public DependentStatusBuilder(DependentStatusFluent<?> fluent,DependentStatus instance) {
        this(fluent, instance, true);
    }

    public DependentStatusBuilder(DependentStatusFluent<?> fluent,DependentStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGroup(instance.getGroup()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withUuid(instance.getUuid()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public DependentStatusBuilder(DependentStatus instance) {
        this(instance,true);
    }

    public DependentStatusBuilder(DependentStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withGroup(instance.getGroup()); 
        this.withKind(instance.getKind()); 
        this.withMessage(instance.getMessage()); 
        this.withStatus(instance.getStatus()); 
        this.withUuid(instance.getUuid()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public DependentStatus build() {
        DependentStatus buildable = new DependentStatus(fluent.getGroup(),fluent.getKind(),fluent.getMessage(),fluent.getStatus(),fluent.getUuid(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DependentStatusBuilder that = (DependentStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
