package io.fabric8.openshift.api.model.operatorhub.manifests;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PackageManifestFluent<A extends PackageManifestFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToChannels(int index,PackageChannel item);
    public A setToChannels(int index,PackageChannel item);
    public A addToChannels(PackageChannel... items);
    public A addAllToChannels(Collection<PackageChannel> items);
    public A removeFromChannels(PackageChannel... items);
    public A removeAllFromChannels(Collection<PackageChannel> items);
    public A removeMatchingFromChannels(Predicate<PackageChannelBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildChannels instead.
 * @return The buildable object.
 */
@Deprecated public List<PackageChannel> getChannels();
    public List<PackageChannel> buildChannels();
    public PackageChannel buildChannel(int index);
    public PackageChannel buildFirstChannel();
    public PackageChannel buildLastChannel();
    public PackageChannel buildMatchingChannel(Predicate<PackageChannelBuilder> predicate);
    public Boolean hasMatchingChannel(Predicate<PackageChannelBuilder> predicate);
    public A withChannels(List<PackageChannel> channels);
    public A withChannels(PackageChannel... channels);
    public Boolean hasChannels();
    public A addNewChannel(String currentCSV,String name);
    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> addNewChannel();
    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> addNewChannelLike(PackageChannel item);
    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> setNewChannelLike(int index,PackageChannel item);
    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> editChannel(int index);
    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> editFirstChannel();
    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> editLastChannel();
    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> editMatchingChannel(Predicate<PackageChannelBuilder> predicate);
    public String getDefaultChannel();
    public A withDefaultChannel(String defaultChannel);
    public Boolean hasDefaultChannel();
    public A withNewDefaultChannel(StringBuilder arg1);
    public A withNewDefaultChannel(int[] arg1,int arg2,int arg3);
    public A withNewDefaultChannel(char[] arg1);
    public A withNewDefaultChannel(StringBuffer arg1);
    public A withNewDefaultChannel(byte[] arg1,int arg2);
    public A withNewDefaultChannel(byte[] arg1);
    public A withNewDefaultChannel(char[] arg1,int arg2,int arg3);
    public A withNewDefaultChannel(byte[] arg1,int arg2,int arg3);
    public A withNewDefaultChannel(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDefaultChannel(String arg1);
    public String getPackageName();
    public A withPackageName(String packageName);
    public Boolean hasPackageName();
    public A withNewPackageName(StringBuilder arg1);
    public A withNewPackageName(int[] arg1,int arg2,int arg3);
    public A withNewPackageName(char[] arg1);
    public A withNewPackageName(StringBuffer arg1);
    public A withNewPackageName(byte[] arg1,int arg2);
    public A withNewPackageName(byte[] arg1);
    public A withNewPackageName(char[] arg1,int arg2,int arg3);
    public A withNewPackageName(byte[] arg1,int arg2,int arg3);
    public A withNewPackageName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPackageName(String arg1);
    public interface ChannelsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PackageChannelFluent<io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<N>> {

            public N and();
            public N endChannel();    }


}
