package io.fabric8.openshift.api.model.operatorhub.manifests;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PackageChannelBuilder extends PackageChannelFluentImpl<PackageChannelBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PackageChannel,PackageChannelBuilder> {

    PackageChannelFluent<?> fluent;
    Boolean validationEnabled;

    public PackageChannelBuilder() {
        this(true);
    }

    public PackageChannelBuilder(Boolean validationEnabled) {
        this(new PackageChannel(), validationEnabled);
    }

    public PackageChannelBuilder(PackageChannelFluent<?> fluent) {
        this(fluent, true);
    }

    public PackageChannelBuilder(PackageChannelFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PackageChannel(), validationEnabled);
    }

    public PackageChannelBuilder(PackageChannelFluent<?> fluent,PackageChannel instance) {
        this(fluent, instance, true);
    }

    public PackageChannelBuilder(PackageChannelFluent<?> fluent,PackageChannel instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCurrentCSV(instance.getCurrentCSV()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public PackageChannelBuilder(PackageChannel instance) {
        this(instance,true);
    }

    public PackageChannelBuilder(PackageChannel instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCurrentCSV(instance.getCurrentCSV()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public PackageChannel build() {
        PackageChannel buildable = new PackageChannel(fluent.getCurrentCSV(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PackageChannelBuilder that = (PackageChannelBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
