package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriptionListBuilder extends SubscriptionListFluentImpl<SubscriptionListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<SubscriptionList,SubscriptionListBuilder> {

    SubscriptionListFluent<?> fluent;
    Boolean validationEnabled;

    public SubscriptionListBuilder() {
        this(true);
    }

    public SubscriptionListBuilder(Boolean validationEnabled) {
        this(new SubscriptionList(), validationEnabled);
    }

    public SubscriptionListBuilder(SubscriptionListFluent<?> fluent) {
        this(fluent, true);
    }

    public SubscriptionListBuilder(SubscriptionListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SubscriptionList(), validationEnabled);
    }

    public SubscriptionListBuilder(SubscriptionListFluent<?> fluent,SubscriptionList instance) {
        this(fluent, instance, true);
    }

    public SubscriptionListBuilder(SubscriptionListFluent<?> fluent,SubscriptionList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public SubscriptionListBuilder(SubscriptionList instance) {
        this(instance,true);
    }

    public SubscriptionListBuilder(SubscriptionList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public SubscriptionList build() {
        SubscriptionList buildable = new SubscriptionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SubscriptionListBuilder that = (SubscriptionListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
