package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class StrategyDeploymentSpecFluentImpl<A extends StrategyDeploymentSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StrategyDeploymentSpecFluent<A> {

    private java.util.Map<String,String> label;
    private String name;
    private DeploymentSpec spec;

    public StrategyDeploymentSpecFluentImpl() {
    }

    public StrategyDeploymentSpecFluentImpl(StrategyDeploymentSpec instance) {
        this.withLabel(instance.getLabel()); 
        this.withName(instance.getName()); 
        this.withSpec(instance.getSpec()); 
    }

    public A addToLabel(String key,String value) {
        if(this.label == null && key != null && value != null) { this.label = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.label.put(key, value);} return (A)this;
    }

    public A addToLabel(java.util.Map<String,String> map) {
        if(this.label == null && map != null) { this.label = new LinkedHashMap<String,String>(); }
        if(map != null) { this.label.putAll(map);} return (A)this;
    }

    public A removeFromLabel(String key) {
        if(this.label == null) { return (A) this; }
        if(key != null && this.label != null) {this.label.remove(key);} return (A)this;
    }

    public A removeFromLabel(java.util.Map<String,String> map) {
        if(this.label == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.label != null){this.label.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getLabel() {
        return this.label;
    }

    public <K extends Object,V extends Object>A withLabel(java.util.Map<String,String> label) {
        if (label == null) { this.label =  null;} else {this.label = new LinkedHashMap<String,String>(label);} return (A) this;
    }

    public Boolean hasLabel() {
        return this.label != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public DeploymentSpec getSpec() {
        return this.spec;
    }

    public A withSpec(DeploymentSpec spec) {
        this.spec=spec; return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StrategyDeploymentSpecFluentImpl that = (StrategyDeploymentSpecFluentImpl) o;
        if (label != null ? !label.equals(that.label) :that.label != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(label,  name,  spec,  super.hashCode());
    }

}
