package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.GroupVersionKind;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.StringBuffer;

public class ClusterServiceVersionSpecFluentImpl<A extends ClusterServiceVersionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterServiceVersionSpecFluent<A> {

    private java.util.Map<String,String> annotations;
    private APIServiceDefinitionsBuilder apiservicedefinitions;
    private CustomResourceDefinitionsBuilder customresourcedefinitions;
    private String description;
    private String displayName;
    private List<IconBuilder> icon =  new ArrayList<IconBuilder>();
    private NamedInstallStrategyBuilder install;
    private List<InstallModeBuilder> installModes =  new ArrayList<InstallModeBuilder>();
    private List<String> keywords = new ArrayList<String>();
    private java.util.Map<String,String> labels;
    private List<AppLinkBuilder> links =  new ArrayList<AppLinkBuilder>();
    private List<MaintainerBuilder> maintainers =  new ArrayList<MaintainerBuilder>();
    private String maturity;
    private String minKubeVersion;
    private List<GroupVersionKind> nativeAPIs = new ArrayList<GroupVersionKind>();
    private AppLinkBuilder provider;
    private String replaces;
    private LabelSelectorBuilder selector;
    private String version;
    private List<WebhookDescriptionBuilder> webhookdefinitions =  new ArrayList<WebhookDescriptionBuilder>();

    public ClusterServiceVersionSpecFluentImpl() {
    }

    public ClusterServiceVersionSpecFluentImpl(ClusterServiceVersionSpec instance) {
        this.withAnnotations(instance.getAnnotations()); 
        this.withApiservicedefinitions(instance.getApiservicedefinitions()); 
        this.withCustomresourcedefinitions(instance.getCustomresourcedefinitions()); 
        this.withDescription(instance.getDescription()); 
        this.withDisplayName(instance.getDisplayName()); 
        this.withIcon(instance.getIcon()); 
        this.withInstall(instance.getInstall()); 
        this.withInstallModes(instance.getInstallModes()); 
        this.withKeywords(instance.getKeywords()); 
        this.withLabels(instance.getLabels()); 
        this.withLinks(instance.getLinks()); 
        this.withMaintainers(instance.getMaintainers()); 
        this.withMaturity(instance.getMaturity()); 
        this.withMinKubeVersion(instance.getMinKubeVersion()); 
        this.withNativeAPIs(instance.getNativeAPIs()); 
        this.withProvider(instance.getProvider()); 
        this.withReplaces(instance.getReplaces()); 
        this.withSelector(instance.getSelector()); 
        this.withVersion(instance.getVersion()); 
        this.withWebhookdefinitions(instance.getWebhookdefinitions()); 
    }

    public A addToAnnotations(String key,String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<String,String> map) {
        if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<String,String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getAnnotations() {
        return this.annotations;
    }

    public <K extends Object,V extends Object>A withAnnotations(java.util.Map<String,String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    
/**
 * This method has been deprecated, please use method buildApiservicedefinitions instead.
 * @return The buildable object.
 */
@Deprecated public APIServiceDefinitions getApiservicedefinitions() {
        return this.apiservicedefinitions!=null?this.apiservicedefinitions.build():null;
    }

    public APIServiceDefinitions buildApiservicedefinitions() {
        return this.apiservicedefinitions!=null?this.apiservicedefinitions.build():null;
    }

    public A withApiservicedefinitions(APIServiceDefinitions apiservicedefinitions) {
        _visitables.get("apiservicedefinitions").remove(this.apiservicedefinitions);
        if (apiservicedefinitions!=null){ this.apiservicedefinitions= new APIServiceDefinitionsBuilder(apiservicedefinitions); _visitables.get("apiservicedefinitions").add(this.apiservicedefinitions);} return (A) this;
    }

    public Boolean hasApiservicedefinitions() {
        return this.apiservicedefinitions != null;
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<A> withNewApiservicedefinitions() {
        return new ApiservicedefinitionsNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<A> withNewApiservicedefinitionsLike(APIServiceDefinitions item) {
        return new ApiservicedefinitionsNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<A> editApiservicedefinitions() {
        return withNewApiservicedefinitionsLike(getApiservicedefinitions());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<A> editOrNewApiservicedefinitions() {
        return withNewApiservicedefinitionsLike(getApiservicedefinitions() != null ? getApiservicedefinitions(): new APIServiceDefinitionsBuilder().build());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<A> editOrNewApiservicedefinitionsLike(APIServiceDefinitions item) {
        return withNewApiservicedefinitionsLike(getApiservicedefinitions() != null ? getApiservicedefinitions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCustomresourcedefinitions instead.
 * @return The buildable object.
 */
@Deprecated public CustomResourceDefinitions getCustomresourcedefinitions() {
        return this.customresourcedefinitions!=null?this.customresourcedefinitions.build():null;
    }

    public CustomResourceDefinitions buildCustomresourcedefinitions() {
        return this.customresourcedefinitions!=null?this.customresourcedefinitions.build():null;
    }

    public A withCustomresourcedefinitions(CustomResourceDefinitions customresourcedefinitions) {
        _visitables.get("customresourcedefinitions").remove(this.customresourcedefinitions);
        if (customresourcedefinitions!=null){ this.customresourcedefinitions= new CustomResourceDefinitionsBuilder(customresourcedefinitions); _visitables.get("customresourcedefinitions").add(this.customresourcedefinitions);} return (A) this;
    }

    public Boolean hasCustomresourcedefinitions() {
        return this.customresourcedefinitions != null;
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<A> withNewCustomresourcedefinitions() {
        return new CustomresourcedefinitionsNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<A> withNewCustomresourcedefinitionsLike(CustomResourceDefinitions item) {
        return new CustomresourcedefinitionsNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<A> editCustomresourcedefinitions() {
        return withNewCustomresourcedefinitionsLike(getCustomresourcedefinitions());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<A> editOrNewCustomresourcedefinitions() {
        return withNewCustomresourcedefinitionsLike(getCustomresourcedefinitions() != null ? getCustomresourcedefinitions(): new CustomResourceDefinitionsBuilder().build());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<A> editOrNewCustomresourcedefinitionsLike(CustomResourceDefinitions item) {
        return withNewCustomresourcedefinitionsLike(getCustomresourcedefinitions() != null ? getCustomresourcedefinitions(): item);
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description=description; return (A) this;
    }

    public Boolean hasDescription() {
        return this.description != null;
    }

    public A withNewDescription(StringBuilder arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(int[] arg1,int arg2,int arg3) {
        return (A)withDescription(new String(arg1, arg2, arg3));
    }

    public A withNewDescription(char[] arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(byte[] arg1,int arg2) {
        return (A)withDescription(new String(arg1, arg2));
    }

    public A withNewDescription(byte[] arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(char[] arg1,int arg2,int arg3) {
        return (A)withDescription(new String(arg1, arg2, arg3));
    }

    public A withNewDescription(byte[] arg1,int arg2,int arg3) {
        return (A)withDescription(new String(arg1, arg2, arg3));
    }

    public A withNewDescription(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDescription(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDescription(String arg1) {
        return (A)withDescription(new String(arg1));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName=displayName; return (A) this;
    }

    public Boolean hasDisplayName() {
        return this.displayName != null;
    }

    public A withNewDisplayName(StringBuilder arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(int[] arg1,int arg2,int arg3) {
        return (A)withDisplayName(new String(arg1, arg2, arg3));
    }

    public A withNewDisplayName(char[] arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(StringBuffer arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(byte[] arg1,int arg2) {
        return (A)withDisplayName(new String(arg1, arg2));
    }

    public A withNewDisplayName(byte[] arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(char[] arg1,int arg2,int arg3) {
        return (A)withDisplayName(new String(arg1, arg2, arg3));
    }

    public A withNewDisplayName(byte[] arg1,int arg2,int arg3) {
        return (A)withDisplayName(new String(arg1, arg2, arg3));
    }

    public A withNewDisplayName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDisplayName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDisplayName(String arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A addToIcon(int index,Icon item) {
        if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
        IconBuilder builder = new IconBuilder(item);_visitables.get("icon").add(index >= 0 ? index : _visitables.get("icon").size(), builder);this.icon.add(index >= 0 ? index : icon.size(), builder); return (A)this;
    }

    public A setToIcon(int index,Icon item) {
        if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
        IconBuilder builder = new IconBuilder(item);
        if (index < 0 || index >= _visitables.get("icon").size()) { _visitables.get("icon").add(builder); } else { _visitables.get("icon").set(index, builder);}
        if (index < 0 || index >= icon.size()) { icon.add(builder); } else { icon.set(index, builder);}
         return (A)this;
    }

    public A addToIcon(Icon... items) {
        if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
        for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").add(builder);this.icon.add(builder);} return (A)this;
    }

    public A addAllToIcon(Collection<Icon> items) {
        if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
        for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").add(builder);this.icon.add(builder);} return (A)this;
    }

    public A removeFromIcon(Icon... items) {
        for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").remove(builder);if (this.icon != null) {this.icon.remove(builder);}} return (A)this;
    }

    public A removeAllFromIcon(Collection<Icon> items) {
        for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").remove(builder);if (this.icon != null) {this.icon.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIcon(Predicate<IconBuilder> predicate) {
        if (icon == null) return (A) this;
        final Iterator<IconBuilder> each = icon.iterator();
        final List visitables = _visitables.get("icon");
        while (each.hasNext()) {
          IconBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIcon instead.
 * @return The buildable object.
 */
@Deprecated public List<Icon> getIcon() {
        return build(icon);
    }

    public List<Icon> buildIcon() {
        return build(icon);
    }

    public Icon buildIcon(int index) {
        return this.icon.get(index).build();
    }

    public Icon buildFirstIcon() {
        return this.icon.get(0).build();
    }

    public Icon buildLastIcon() {
        return this.icon.get(icon.size() - 1).build();
    }

    public Icon buildMatchingIcon(Predicate<IconBuilder> predicate) {
        for (IconBuilder item: icon) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingIcon(Predicate<IconBuilder> predicate) {
        for (IconBuilder item: icon) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIcon(List<Icon> icon) {
        if (this.icon != null) { _visitables.get("icon").removeAll(this.icon);}
        if (icon != null) {this.icon = new ArrayList<IconBuilder>(); for (Icon item : icon){this.addToIcon(item);}} else { this.icon = null;} return (A) this;
    }

    public A withIcon(Icon... icon) {
        if (this.icon != null) {this.icon.clear();}
        if (icon != null) {for (Icon item :icon){ this.addToIcon(item);}} return (A) this;
    }

    public Boolean hasIcon() {
        return icon != null && !icon.isEmpty();
    }

    public A addNewIcon(String base64data,String mediatype) {
        return (A)addToIcon(new Icon(base64data, mediatype));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.IconNested<A> addNewIcon() {
        return new IconNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.IconNested<A> addNewIconLike(Icon item) {
        return new IconNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.IconNested<A> setNewIconLike(int index,Icon item) {
        return new IconNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.IconNested<A> editIcon(int index) {
        if (icon.size() <= index) throw new RuntimeException("Can't edit icon. Index exceeds size.");
        return setNewIconLike(index, buildIcon(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.IconNested<A> editFirstIcon() {
        if (icon.size() == 0) throw new RuntimeException("Can't edit first icon. The list is empty.");
        return setNewIconLike(0, buildIcon(0));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.IconNested<A> editLastIcon() {
        int index = icon.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last icon. The list is empty.");
        return setNewIconLike(index, buildIcon(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.IconNested<A> editMatchingIcon(Predicate<IconBuilder> predicate) {
        int index = -1;
        for (int i=0;i<icon.size();i++) { 
        if (predicate.test(icon.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching icon. No match found.");
        return setNewIconLike(index, buildIcon(index));
    }

    
/**
 * This method has been deprecated, please use method buildInstall instead.
 * @return The buildable object.
 */
@Deprecated public NamedInstallStrategy getInstall() {
        return this.install!=null?this.install.build():null;
    }

    public NamedInstallStrategy buildInstall() {
        return this.install!=null?this.install.build():null;
    }

    public A withInstall(NamedInstallStrategy install) {
        _visitables.get("install").remove(this.install);
        if (install!=null){ this.install= new NamedInstallStrategyBuilder(install); _visitables.get("install").add(this.install);} return (A) this;
    }

    public Boolean hasInstall() {
        return this.install != null;
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallNested<A> withNewInstall() {
        return new InstallNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallNested<A> withNewInstallLike(NamedInstallStrategy item) {
        return new InstallNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallNested<A> editInstall() {
        return withNewInstallLike(getInstall());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallNested<A> editOrNewInstall() {
        return withNewInstallLike(getInstall() != null ? getInstall(): new NamedInstallStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallNested<A> editOrNewInstallLike(NamedInstallStrategy item) {
        return withNewInstallLike(getInstall() != null ? getInstall(): item);
    }

    public A addToInstallModes(int index,InstallMode item) {
        if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
        InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").add(index >= 0 ? index : _visitables.get("installModes").size(), builder);this.installModes.add(index >= 0 ? index : installModes.size(), builder); return (A)this;
    }

    public A setToInstallModes(int index,InstallMode item) {
        if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
        InstallModeBuilder builder = new InstallModeBuilder(item);
        if (index < 0 || index >= _visitables.get("installModes").size()) { _visitables.get("installModes").add(builder); } else { _visitables.get("installModes").set(index, builder);}
        if (index < 0 || index >= installModes.size()) { installModes.add(builder); } else { installModes.set(index, builder);}
         return (A)this;
    }

    public A addToInstallModes(InstallMode... items) {
        if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
        for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").add(builder);this.installModes.add(builder);} return (A)this;
    }

    public A addAllToInstallModes(Collection<InstallMode> items) {
        if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
        for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").add(builder);this.installModes.add(builder);} return (A)this;
    }

    public A removeFromInstallModes(InstallMode... items) {
        for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").remove(builder);if (this.installModes != null) {this.installModes.remove(builder);}} return (A)this;
    }

    public A removeAllFromInstallModes(Collection<InstallMode> items) {
        for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").remove(builder);if (this.installModes != null) {this.installModes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromInstallModes(Predicate<InstallModeBuilder> predicate) {
        if (installModes == null) return (A) this;
        final Iterator<InstallModeBuilder> each = installModes.iterator();
        final List visitables = _visitables.get("installModes");
        while (each.hasNext()) {
          InstallModeBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildInstallModes instead.
 * @return The buildable object.
 */
@Deprecated public List<InstallMode> getInstallModes() {
        return build(installModes);
    }

    public List<InstallMode> buildInstallModes() {
        return build(installModes);
    }

    public InstallMode buildInstallMode(int index) {
        return this.installModes.get(index).build();
    }

    public InstallMode buildFirstInstallMode() {
        return this.installModes.get(0).build();
    }

    public InstallMode buildLastInstallMode() {
        return this.installModes.get(installModes.size() - 1).build();
    }

    public InstallMode buildMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
        for (InstallModeBuilder item: installModes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
        for (InstallModeBuilder item: installModes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withInstallModes(List<InstallMode> installModes) {
        if (this.installModes != null) { _visitables.get("installModes").removeAll(this.installModes);}
        if (installModes != null) {this.installModes = new ArrayList<InstallModeBuilder>(); for (InstallMode item : installModes){this.addToInstallModes(item);}} else { this.installModes = null;} return (A) this;
    }

    public A withInstallModes(InstallMode... installModes) {
        if (this.installModes != null) {this.installModes.clear();}
        if (installModes != null) {for (InstallMode item :installModes){ this.addToInstallModes(item);}} return (A) this;
    }

    public Boolean hasInstallModes() {
        return installModes != null && !installModes.isEmpty();
    }

    public A addNewInstallMode(Boolean supported,String type) {
        return (A)addToInstallModes(new InstallMode(supported, type));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallModesNested<A> addNewInstallMode() {
        return new InstallModesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallModesNested<A> addNewInstallModeLike(InstallMode item) {
        return new InstallModesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallModesNested<A> setNewInstallModeLike(int index,InstallMode item) {
        return new InstallModesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallModesNested<A> editInstallMode(int index) {
        if (installModes.size() <= index) throw new RuntimeException("Can't edit installModes. Index exceeds size.");
        return setNewInstallModeLike(index, buildInstallMode(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallModesNested<A> editFirstInstallMode() {
        if (installModes.size() == 0) throw new RuntimeException("Can't edit first installModes. The list is empty.");
        return setNewInstallModeLike(0, buildInstallMode(0));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallModesNested<A> editLastInstallMode() {
        int index = installModes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last installModes. The list is empty.");
        return setNewInstallModeLike(index, buildInstallMode(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallModesNested<A> editMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
        int index = -1;
        for (int i=0;i<installModes.size();i++) { 
        if (predicate.test(installModes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching installModes. No match found.");
        return setNewInstallModeLike(index, buildInstallMode(index));
    }

    public A addToKeywords(int index,String item) {
        if (this.keywords == null) {this.keywords = new ArrayList<String>();}
        this.keywords.add(index, item);
        return (A)this;
    }

    public A setToKeywords(int index,String item) {
        if (this.keywords == null) {this.keywords = new ArrayList<String>();}
        this.keywords.set(index, item); return (A)this;
    }

    public A addToKeywords(String... items) {
        if (this.keywords == null) {this.keywords = new ArrayList<String>();}
        for (String item : items) {this.keywords.add(item);} return (A)this;
    }

    public A addAllToKeywords(Collection<String> items) {
        if (this.keywords == null) {this.keywords = new ArrayList<String>();}
        for (String item : items) {this.keywords.add(item);} return (A)this;
    }

    public A removeFromKeywords(String... items) {
        for (String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
    }

    public A removeAllFromKeywords(Collection<String> items) {
        for (String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public String getKeyword(int index) {
        return this.keywords.get(index);
    }

    public String getFirstKeyword() {
        return this.keywords.get(0);
    }

    public String getLastKeyword() {
        return this.keywords.get(keywords.size() - 1);
    }

    public String getMatchingKeyword(Predicate<String> predicate) {
        for (String item: keywords) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingKeyword(Predicate<String> predicate) {
        for (String item: keywords) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withKeywords(List<String> keywords) {
        if (this.keywords != null) { _visitables.get("keywords").removeAll(this.keywords);}
        if (keywords != null) {this.keywords = new ArrayList<String>(); for (String item : keywords){this.addToKeywords(item);}} else { this.keywords = null;} return (A) this;
    }

    public A withKeywords(String... keywords) {
        if (this.keywords != null) {this.keywords.clear();}
        if (keywords != null) {for (String item :keywords){ this.addToKeywords(item);}} return (A) this;
    }

    public Boolean hasKeywords() {
        return keywords != null && !keywords.isEmpty();
    }

    public A addNewKeyword(StringBuilder arg1) {
        return (A)addToKeywords(new String(arg1));
    }

    public A addNewKeyword(int[] arg1,int arg2,int arg3) {
        return (A)addToKeywords(new String(arg1, arg2, arg3));
    }

    public A addNewKeyword(char[] arg1) {
        return (A)addToKeywords(new String(arg1));
    }

    public A addNewKeyword(StringBuffer arg1) {
        return (A)addToKeywords(new String(arg1));
    }

    public A addNewKeyword(byte[] arg1,int arg2) {
        return (A)addToKeywords(new String(arg1, arg2));
    }

    public A addNewKeyword(byte[] arg1) {
        return (A)addToKeywords(new String(arg1));
    }

    public A addNewKeyword(char[] arg1,int arg2,int arg3) {
        return (A)addToKeywords(new String(arg1, arg2, arg3));
    }

    public A addNewKeyword(byte[] arg1,int arg2,int arg3) {
        return (A)addToKeywords(new String(arg1, arg2, arg3));
    }

    public A addNewKeyword(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToKeywords(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewKeyword(String arg1) {
        return (A)addToKeywords(new String(arg1));
    }

    public A addToLabels(String key,String value) {
        if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(java.util.Map<String,String> map) {
        if(this.labels == null && map != null) { this.labels = new LinkedHashMap<String,String>(); }
        if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key) {
        if(this.labels == null) { return (A) this; }
        if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(java.util.Map<String,String> map) {
        if(this.labels == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getLabels() {
        return this.labels;
    }

    public <K extends Object,V extends Object>A withLabels(java.util.Map<String,String> labels) {
        if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap<String,String>(labels);} return (A) this;
    }

    public Boolean hasLabels() {
        return this.labels != null;
    }

    public A addToLinks(int index,AppLink item) {
        if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
        AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").add(index >= 0 ? index : _visitables.get("links").size(), builder);this.links.add(index >= 0 ? index : links.size(), builder); return (A)this;
    }

    public A setToLinks(int index,AppLink item) {
        if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
        AppLinkBuilder builder = new AppLinkBuilder(item);
        if (index < 0 || index >= _visitables.get("links").size()) { _visitables.get("links").add(builder); } else { _visitables.get("links").set(index, builder);}
        if (index < 0 || index >= links.size()) { links.add(builder); } else { links.set(index, builder);}
         return (A)this;
    }

    public A addToLinks(AppLink... items) {
        if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
        for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").add(builder);this.links.add(builder);} return (A)this;
    }

    public A addAllToLinks(Collection<AppLink> items) {
        if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
        for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").add(builder);this.links.add(builder);} return (A)this;
    }

    public A removeFromLinks(AppLink... items) {
        for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").remove(builder);if (this.links != null) {this.links.remove(builder);}} return (A)this;
    }

    public A removeAllFromLinks(Collection<AppLink> items) {
        for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").remove(builder);if (this.links != null) {this.links.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromLinks(Predicate<AppLinkBuilder> predicate) {
        if (links == null) return (A) this;
        final Iterator<AppLinkBuilder> each = links.iterator();
        final List visitables = _visitables.get("links");
        while (each.hasNext()) {
          AppLinkBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildLinks instead.
 * @return The buildable object.
 */
@Deprecated public List<AppLink> getLinks() {
        return build(links);
    }

    public List<AppLink> buildLinks() {
        return build(links);
    }

    public AppLink buildLink(int index) {
        return this.links.get(index).build();
    }

    public AppLink buildFirstLink() {
        return this.links.get(0).build();
    }

    public AppLink buildLastLink() {
        return this.links.get(links.size() - 1).build();
    }

    public AppLink buildMatchingLink(Predicate<AppLinkBuilder> predicate) {
        for (AppLinkBuilder item: links) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingLink(Predicate<AppLinkBuilder> predicate) {
        for (AppLinkBuilder item: links) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withLinks(List<AppLink> links) {
        if (this.links != null) { _visitables.get("links").removeAll(this.links);}
        if (links != null) {this.links = new ArrayList<AppLinkBuilder>(); for (AppLink item : links){this.addToLinks(item);}} else { this.links = null;} return (A) this;
    }

    public A withLinks(AppLink... links) {
        if (this.links != null) {this.links.clear();}
        if (links != null) {for (AppLink item :links){ this.addToLinks(item);}} return (A) this;
    }

    public Boolean hasLinks() {
        return links != null && !links.isEmpty();
    }

    public A addNewLink(String name,String url) {
        return (A)addToLinks(new AppLink(name, url));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.LinksNested<A> addNewLink() {
        return new LinksNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.LinksNested<A> addNewLinkLike(AppLink item) {
        return new LinksNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.LinksNested<A> setNewLinkLike(int index,AppLink item) {
        return new LinksNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.LinksNested<A> editLink(int index) {
        if (links.size() <= index) throw new RuntimeException("Can't edit links. Index exceeds size.");
        return setNewLinkLike(index, buildLink(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.LinksNested<A> editFirstLink() {
        if (links.size() == 0) throw new RuntimeException("Can't edit first links. The list is empty.");
        return setNewLinkLike(0, buildLink(0));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.LinksNested<A> editLastLink() {
        int index = links.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last links. The list is empty.");
        return setNewLinkLike(index, buildLink(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.LinksNested<A> editMatchingLink(Predicate<AppLinkBuilder> predicate) {
        int index = -1;
        for (int i=0;i<links.size();i++) { 
        if (predicate.test(links.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching links. No match found.");
        return setNewLinkLike(index, buildLink(index));
    }

    public A addToMaintainers(int index,Maintainer item) {
        if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
        MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(index >= 0 ? index : _visitables.get("maintainers").size(), builder);this.maintainers.add(index >= 0 ? index : maintainers.size(), builder); return (A)this;
    }

    public A setToMaintainers(int index,Maintainer item) {
        if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
        MaintainerBuilder builder = new MaintainerBuilder(item);
        if (index < 0 || index >= _visitables.get("maintainers").size()) { _visitables.get("maintainers").add(builder); } else { _visitables.get("maintainers").set(index, builder);}
        if (index < 0 || index >= maintainers.size()) { maintainers.add(builder); } else { maintainers.set(index, builder);}
         return (A)this;
    }

    public A addToMaintainers(Maintainer... items) {
        if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
        for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
    }

    public A addAllToMaintainers(Collection<Maintainer> items) {
        if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
        for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
    }

    public A removeFromMaintainers(Maintainer... items) {
        for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
    }

    public A removeAllFromMaintainers(Collection<Maintainer> items) {
        for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMaintainers(Predicate<MaintainerBuilder> predicate) {
        if (maintainers == null) return (A) this;
        final Iterator<MaintainerBuilder> each = maintainers.iterator();
        final List visitables = _visitables.get("maintainers");
        while (each.hasNext()) {
          MaintainerBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMaintainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Maintainer> getMaintainers() {
        return build(maintainers);
    }

    public List<Maintainer> buildMaintainers() {
        return build(maintainers);
    }

    public Maintainer buildMaintainer(int index) {
        return this.maintainers.get(index).build();
    }

    public Maintainer buildFirstMaintainer() {
        return this.maintainers.get(0).build();
    }

    public Maintainer buildLastMaintainer() {
        return this.maintainers.get(maintainers.size() - 1).build();
    }

    public Maintainer buildMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMaintainers(List<Maintainer> maintainers) {
        if (this.maintainers != null) { _visitables.get("maintainers").removeAll(this.maintainers);}
        if (maintainers != null) {this.maintainers = new ArrayList<MaintainerBuilder>(); for (Maintainer item : maintainers){this.addToMaintainers(item);}} else { this.maintainers = null;} return (A) this;
    }

    public A withMaintainers(Maintainer... maintainers) {
        if (this.maintainers != null) {this.maintainers.clear();}
        if (maintainers != null) {for (Maintainer item :maintainers){ this.addToMaintainers(item);}} return (A) this;
    }

    public Boolean hasMaintainers() {
        return maintainers != null && !maintainers.isEmpty();
    }

    public A addNewMaintainer(String email,String name) {
        return (A)addToMaintainers(new Maintainer(email, name));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.MaintainersNested<A> addNewMaintainer() {
        return new MaintainersNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.MaintainersNested<A> addNewMaintainerLike(Maintainer item) {
        return new MaintainersNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.MaintainersNested<A> setNewMaintainerLike(int index,Maintainer item) {
        return new MaintainersNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.MaintainersNested<A> editMaintainer(int index) {
        if (maintainers.size() <= index) throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
        return setNewMaintainerLike(index, buildMaintainer(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.MaintainersNested<A> editFirstMaintainer() {
        if (maintainers.size() == 0) throw new RuntimeException("Can't edit first maintainers. The list is empty.");
        return setNewMaintainerLike(0, buildMaintainer(0));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.MaintainersNested<A> editLastMaintainer() {
        int index = maintainers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last maintainers. The list is empty.");
        return setNewMaintainerLike(index, buildMaintainer(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.MaintainersNested<A> editMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<maintainers.size();i++) { 
        if (predicate.test(maintainers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching maintainers. No match found.");
        return setNewMaintainerLike(index, buildMaintainer(index));
    }

    public String getMaturity() {
        return this.maturity;
    }

    public A withMaturity(String maturity) {
        this.maturity=maturity; return (A) this;
    }

    public Boolean hasMaturity() {
        return this.maturity != null;
    }

    public A withNewMaturity(StringBuilder arg1) {
        return (A)withMaturity(new String(arg1));
    }

    public A withNewMaturity(int[] arg1,int arg2,int arg3) {
        return (A)withMaturity(new String(arg1, arg2, arg3));
    }

    public A withNewMaturity(char[] arg1) {
        return (A)withMaturity(new String(arg1));
    }

    public A withNewMaturity(StringBuffer arg1) {
        return (A)withMaturity(new String(arg1));
    }

    public A withNewMaturity(byte[] arg1,int arg2) {
        return (A)withMaturity(new String(arg1, arg2));
    }

    public A withNewMaturity(byte[] arg1) {
        return (A)withMaturity(new String(arg1));
    }

    public A withNewMaturity(char[] arg1,int arg2,int arg3) {
        return (A)withMaturity(new String(arg1, arg2, arg3));
    }

    public A withNewMaturity(byte[] arg1,int arg2,int arg3) {
        return (A)withMaturity(new String(arg1, arg2, arg3));
    }

    public A withNewMaturity(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMaturity(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMaturity(String arg1) {
        return (A)withMaturity(new String(arg1));
    }

    public String getMinKubeVersion() {
        return this.minKubeVersion;
    }

    public A withMinKubeVersion(String minKubeVersion) {
        this.minKubeVersion=minKubeVersion; return (A) this;
    }

    public Boolean hasMinKubeVersion() {
        return this.minKubeVersion != null;
    }

    public A withNewMinKubeVersion(StringBuilder arg1) {
        return (A)withMinKubeVersion(new String(arg1));
    }

    public A withNewMinKubeVersion(int[] arg1,int arg2,int arg3) {
        return (A)withMinKubeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewMinKubeVersion(char[] arg1) {
        return (A)withMinKubeVersion(new String(arg1));
    }

    public A withNewMinKubeVersion(StringBuffer arg1) {
        return (A)withMinKubeVersion(new String(arg1));
    }

    public A withNewMinKubeVersion(byte[] arg1,int arg2) {
        return (A)withMinKubeVersion(new String(arg1, arg2));
    }

    public A withNewMinKubeVersion(byte[] arg1) {
        return (A)withMinKubeVersion(new String(arg1));
    }

    public A withNewMinKubeVersion(char[] arg1,int arg2,int arg3) {
        return (A)withMinKubeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewMinKubeVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withMinKubeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewMinKubeVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMinKubeVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMinKubeVersion(String arg1) {
        return (A)withMinKubeVersion(new String(arg1));
    }

    public A addToNativeAPIs(int index,GroupVersionKind item) {
        if (this.nativeAPIs == null) {this.nativeAPIs = new ArrayList<GroupVersionKind>();}
        this.nativeAPIs.add(index, item);
        return (A)this;
    }

    public A setToNativeAPIs(int index,GroupVersionKind item) {
        if (this.nativeAPIs == null) {this.nativeAPIs = new ArrayList<GroupVersionKind>();}
        this.nativeAPIs.set(index, item); return (A)this;
    }

    public A addToNativeAPIs(GroupVersionKind... items) {
        if (this.nativeAPIs == null) {this.nativeAPIs = new ArrayList<GroupVersionKind>();}
        for (GroupVersionKind item : items) {this.nativeAPIs.add(item);} return (A)this;
    }

    public A addAllToNativeAPIs(Collection<GroupVersionKind> items) {
        if (this.nativeAPIs == null) {this.nativeAPIs = new ArrayList<GroupVersionKind>();}
        for (GroupVersionKind item : items) {this.nativeAPIs.add(item);} return (A)this;
    }

    public A removeFromNativeAPIs(GroupVersionKind... items) {
        for (GroupVersionKind item : items) {if (this.nativeAPIs!= null){ this.nativeAPIs.remove(item);}} return (A)this;
    }

    public A removeAllFromNativeAPIs(Collection<GroupVersionKind> items) {
        for (GroupVersionKind item : items) {if (this.nativeAPIs!= null){ this.nativeAPIs.remove(item);}} return (A)this;
    }

    public List<GroupVersionKind> getNativeAPIs() {
        return this.nativeAPIs;
    }

    public GroupVersionKind getNativeAPI(int index) {
        return this.nativeAPIs.get(index);
    }

    public GroupVersionKind getFirstNativeAPI() {
        return this.nativeAPIs.get(0);
    }

    public GroupVersionKind getLastNativeAPI() {
        return this.nativeAPIs.get(nativeAPIs.size() - 1);
    }

    public GroupVersionKind getMatchingNativeAPI(Predicate<GroupVersionKind> predicate) {
        for (GroupVersionKind item: nativeAPIs) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNativeAPI(Predicate<GroupVersionKind> predicate) {
        for (GroupVersionKind item: nativeAPIs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNativeAPIs(List<GroupVersionKind> nativeAPIs) {
        if (this.nativeAPIs != null) { _visitables.get("nativeAPIs").removeAll(this.nativeAPIs);}
        if (nativeAPIs != null) {this.nativeAPIs = new ArrayList<GroupVersionKind>(); for (GroupVersionKind item : nativeAPIs){this.addToNativeAPIs(item);}} else { this.nativeAPIs = null;} return (A) this;
    }

    public A withNativeAPIs(GroupVersionKind... nativeAPIs) {
        if (this.nativeAPIs != null) {this.nativeAPIs.clear();}
        if (nativeAPIs != null) {for (GroupVersionKind item :nativeAPIs){ this.addToNativeAPIs(item);}} return (A) this;
    }

    public Boolean hasNativeAPIs() {
        return nativeAPIs != null && !nativeAPIs.isEmpty();
    }

    public A addNewNativeAPI(String group,String kind,String version) {
        return (A)addToNativeAPIs(new GroupVersionKind(group, kind, version));
    }

    
/**
 * This method has been deprecated, please use method buildProvider instead.
 * @return The buildable object.
 */
@Deprecated public AppLink getProvider() {
        return this.provider!=null?this.provider.build():null;
    }

    public AppLink buildProvider() {
        return this.provider!=null?this.provider.build():null;
    }

    public A withProvider(AppLink provider) {
        _visitables.get("provider").remove(this.provider);
        if (provider!=null){ this.provider= new AppLinkBuilder(provider); _visitables.get("provider").add(this.provider);} return (A) this;
    }

    public Boolean hasProvider() {
        return this.provider != null;
    }

    public A withNewProvider(String name,String url) {
        return (A)withProvider(new AppLink(name, url));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ProviderNested<A> withNewProvider() {
        return new ProviderNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ProviderNested<A> withNewProviderLike(AppLink item) {
        return new ProviderNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ProviderNested<A> editProvider() {
        return withNewProviderLike(getProvider());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ProviderNested<A> editOrNewProvider() {
        return withNewProviderLike(getProvider() != null ? getProvider(): new AppLinkBuilder().build());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ProviderNested<A> editOrNewProviderLike(AppLink item) {
        return withNewProviderLike(getProvider() != null ? getProvider(): item);
    }

    public String getReplaces() {
        return this.replaces;
    }

    public A withReplaces(String replaces) {
        this.replaces=replaces; return (A) this;
    }

    public Boolean hasReplaces() {
        return this.replaces != null;
    }

    public A withNewReplaces(StringBuilder arg1) {
        return (A)withReplaces(new String(arg1));
    }

    public A withNewReplaces(int[] arg1,int arg2,int arg3) {
        return (A)withReplaces(new String(arg1, arg2, arg3));
    }

    public A withNewReplaces(char[] arg1) {
        return (A)withReplaces(new String(arg1));
    }

    public A withNewReplaces(StringBuffer arg1) {
        return (A)withReplaces(new String(arg1));
    }

    public A withNewReplaces(byte[] arg1,int arg2) {
        return (A)withReplaces(new String(arg1, arg2));
    }

    public A withNewReplaces(byte[] arg1) {
        return (A)withReplaces(new String(arg1));
    }

    public A withNewReplaces(char[] arg1,int arg2,int arg3) {
        return (A)withReplaces(new String(arg1, arg2, arg3));
    }

    public A withNewReplaces(byte[] arg1,int arg2,int arg3) {
        return (A)withReplaces(new String(arg1, arg2, arg3));
    }

    public A withNewReplaces(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withReplaces(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewReplaces(String arg1) {
        return (A)withReplaces(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(int[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(char[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(byte[] arg1,int arg2) {
        return (A)withVersion(new String(arg1, arg2));
    }

    public A withNewVersion(byte[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(char[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A addToWebhookdefinitions(int index,WebhookDescription item) {
        if (this.webhookdefinitions == null) {this.webhookdefinitions = new ArrayList<WebhookDescriptionBuilder>();}
        WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);_visitables.get("webhookdefinitions").add(index >= 0 ? index : _visitables.get("webhookdefinitions").size(), builder);this.webhookdefinitions.add(index >= 0 ? index : webhookdefinitions.size(), builder); return (A)this;
    }

    public A setToWebhookdefinitions(int index,WebhookDescription item) {
        if (this.webhookdefinitions == null) {this.webhookdefinitions = new ArrayList<WebhookDescriptionBuilder>();}
        WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);
        if (index < 0 || index >= _visitables.get("webhookdefinitions").size()) { _visitables.get("webhookdefinitions").add(builder); } else { _visitables.get("webhookdefinitions").set(index, builder);}
        if (index < 0 || index >= webhookdefinitions.size()) { webhookdefinitions.add(builder); } else { webhookdefinitions.set(index, builder);}
         return (A)this;
    }

    public A addToWebhookdefinitions(WebhookDescription... items) {
        if (this.webhookdefinitions == null) {this.webhookdefinitions = new ArrayList<WebhookDescriptionBuilder>();}
        for (WebhookDescription item : items) {WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);_visitables.get("webhookdefinitions").add(builder);this.webhookdefinitions.add(builder);} return (A)this;
    }

    public A addAllToWebhookdefinitions(Collection<WebhookDescription> items) {
        if (this.webhookdefinitions == null) {this.webhookdefinitions = new ArrayList<WebhookDescriptionBuilder>();}
        for (WebhookDescription item : items) {WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);_visitables.get("webhookdefinitions").add(builder);this.webhookdefinitions.add(builder);} return (A)this;
    }

    public A removeFromWebhookdefinitions(WebhookDescription... items) {
        for (WebhookDescription item : items) {WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);_visitables.get("webhookdefinitions").remove(builder);if (this.webhookdefinitions != null) {this.webhookdefinitions.remove(builder);}} return (A)this;
    }

    public A removeAllFromWebhookdefinitions(Collection<WebhookDescription> items) {
        for (WebhookDescription item : items) {WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);_visitables.get("webhookdefinitions").remove(builder);if (this.webhookdefinitions != null) {this.webhookdefinitions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromWebhookdefinitions(Predicate<WebhookDescriptionBuilder> predicate) {
        if (webhookdefinitions == null) return (A) this;
        final Iterator<WebhookDescriptionBuilder> each = webhookdefinitions.iterator();
        final List visitables = _visitables.get("webhookdefinitions");
        while (each.hasNext()) {
          WebhookDescriptionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildWebhookdefinitions instead.
 * @return The buildable object.
 */
@Deprecated public List<WebhookDescription> getWebhookdefinitions() {
        return build(webhookdefinitions);
    }

    public List<WebhookDescription> buildWebhookdefinitions() {
        return build(webhookdefinitions);
    }

    public WebhookDescription buildWebhookdefinition(int index) {
        return this.webhookdefinitions.get(index).build();
    }

    public WebhookDescription buildFirstWebhookdefinition() {
        return this.webhookdefinitions.get(0).build();
    }

    public WebhookDescription buildLastWebhookdefinition() {
        return this.webhookdefinitions.get(webhookdefinitions.size() - 1).build();
    }

    public WebhookDescription buildMatchingWebhookdefinition(Predicate<WebhookDescriptionBuilder> predicate) {
        for (WebhookDescriptionBuilder item: webhookdefinitions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingWebhookdefinition(Predicate<WebhookDescriptionBuilder> predicate) {
        for (WebhookDescriptionBuilder item: webhookdefinitions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withWebhookdefinitions(List<WebhookDescription> webhookdefinitions) {
        if (this.webhookdefinitions != null) { _visitables.get("webhookdefinitions").removeAll(this.webhookdefinitions);}
        if (webhookdefinitions != null) {this.webhookdefinitions = new ArrayList<WebhookDescriptionBuilder>(); for (WebhookDescription item : webhookdefinitions){this.addToWebhookdefinitions(item);}} else { this.webhookdefinitions = null;} return (A) this;
    }

    public A withWebhookdefinitions(WebhookDescription... webhookdefinitions) {
        if (this.webhookdefinitions != null) {this.webhookdefinitions.clear();}
        if (webhookdefinitions != null) {for (WebhookDescription item :webhookdefinitions){ this.addToWebhookdefinitions(item);}} return (A) this;
    }

    public Boolean hasWebhookdefinitions() {
        return webhookdefinitions != null && !webhookdefinitions.isEmpty();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> addNewWebhookdefinition() {
        return new WebhookdefinitionsNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> addNewWebhookdefinitionLike(WebhookDescription item) {
        return new WebhookdefinitionsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> setNewWebhookdefinitionLike(int index,WebhookDescription item) {
        return new WebhookdefinitionsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> editWebhookdefinition(int index) {
        if (webhookdefinitions.size() <= index) throw new RuntimeException("Can't edit webhookdefinitions. Index exceeds size.");
        return setNewWebhookdefinitionLike(index, buildWebhookdefinition(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> editFirstWebhookdefinition() {
        if (webhookdefinitions.size() == 0) throw new RuntimeException("Can't edit first webhookdefinitions. The list is empty.");
        return setNewWebhookdefinitionLike(0, buildWebhookdefinition(0));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> editLastWebhookdefinition() {
        int index = webhookdefinitions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last webhookdefinitions. The list is empty.");
        return setNewWebhookdefinitionLike(index, buildWebhookdefinition(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> editMatchingWebhookdefinition(Predicate<WebhookDescriptionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<webhookdefinitions.size();i++) { 
        if (predicate.test(webhookdefinitions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching webhookdefinitions. No match found.");
        return setNewWebhookdefinitionLike(index, buildWebhookdefinition(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusterServiceVersionSpecFluentImpl that = (ClusterServiceVersionSpecFluentImpl) o;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (apiservicedefinitions != null ? !apiservicedefinitions.equals(that.apiservicedefinitions) :that.apiservicedefinitions != null) return false;
        if (customresourcedefinitions != null ? !customresourcedefinitions.equals(that.customresourcedefinitions) :that.customresourcedefinitions != null) return false;
        if (description != null ? !description.equals(that.description) :that.description != null) return false;
        if (displayName != null ? !displayName.equals(that.displayName) :that.displayName != null) return false;
        if (icon != null ? !icon.equals(that.icon) :that.icon != null) return false;
        if (install != null ? !install.equals(that.install) :that.install != null) return false;
        if (installModes != null ? !installModes.equals(that.installModes) :that.installModes != null) return false;
        if (keywords != null ? !keywords.equals(that.keywords) :that.keywords != null) return false;
        if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
        if (links != null ? !links.equals(that.links) :that.links != null) return false;
        if (maintainers != null ? !maintainers.equals(that.maintainers) :that.maintainers != null) return false;
        if (maturity != null ? !maturity.equals(that.maturity) :that.maturity != null) return false;
        if (minKubeVersion != null ? !minKubeVersion.equals(that.minKubeVersion) :that.minKubeVersion != null) return false;
        if (nativeAPIs != null ? !nativeAPIs.equals(that.nativeAPIs) :that.nativeAPIs != null) return false;
        if (provider != null ? !provider.equals(that.provider) :that.provider != null) return false;
        if (replaces != null ? !replaces.equals(that.replaces) :that.replaces != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (webhookdefinitions != null ? !webhookdefinitions.equals(that.webhookdefinitions) :that.webhookdefinitions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(annotations,  apiservicedefinitions,  customresourcedefinitions,  description,  displayName,  icon,  install,  installModes,  keywords,  labels,  links,  maintainers,  maturity,  minKubeVersion,  nativeAPIs,  provider,  replaces,  selector,  version,  webhookdefinitions,  super.hashCode());
    }

    public class ApiservicedefinitionsNestedImpl<N> extends APIServiceDefinitionsFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceDefinitionsBuilder builder;

            ApiservicedefinitionsNestedImpl(APIServiceDefinitions item) {
                this.builder = new APIServiceDefinitionsBuilder(this, item);
                        
            }

            ApiservicedefinitionsNestedImpl() {
                this.builder = new APIServiceDefinitionsBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterServiceVersionSpecFluentImpl.this.withApiservicedefinitions(builder.build());
            }

            public N endApiservicedefinitions() {
                return and();
            }
    }


    public class CustomresourcedefinitionsNestedImpl<N> extends CustomResourceDefinitionsFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CustomResourceDefinitionsBuilder builder;

            CustomresourcedefinitionsNestedImpl(CustomResourceDefinitions item) {
                this.builder = new CustomResourceDefinitionsBuilder(this, item);
                        
            }

            CustomresourcedefinitionsNestedImpl() {
                this.builder = new CustomResourceDefinitionsBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterServiceVersionSpecFluentImpl.this.withCustomresourcedefinitions(builder.build());
            }

            public N endCustomresourcedefinitions() {
                return and();
            }
    }


    public class IconNestedImpl<N> extends IconFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.IconNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.IconNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IconBuilder builder;
        private final int index;

            IconNestedImpl(int index,Icon item) {
                this.index = index;
                this.builder = new IconBuilder(this, item);
                        
            }

            IconNestedImpl() {
                this.index = -1;
                this.builder = new IconBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterServiceVersionSpecFluentImpl.this.setToIcon(index,builder.build());
            }

            public N endIcon() {
                return and();
            }
    }


    public class InstallNestedImpl<N> extends NamedInstallStrategyFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamedInstallStrategyBuilder builder;

            InstallNestedImpl(NamedInstallStrategy item) {
                this.builder = new NamedInstallStrategyBuilder(this, item);
                        
            }

            InstallNestedImpl() {
                this.builder = new NamedInstallStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterServiceVersionSpecFluentImpl.this.withInstall(builder.build());
            }

            public N endInstall() {
                return and();
            }
    }


    public class InstallModesNestedImpl<N> extends InstallModeFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallModesNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.InstallModesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InstallModeBuilder builder;
        private final int index;

            InstallModesNestedImpl(int index,InstallMode item) {
                this.index = index;
                this.builder = new InstallModeBuilder(this, item);
                        
            }

            InstallModesNestedImpl() {
                this.index = -1;
                this.builder = new InstallModeBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterServiceVersionSpecFluentImpl.this.setToInstallModes(index,builder.build());
            }

            public N endInstallMode() {
                return and();
            }
    }


    public class LinksNestedImpl<N> extends AppLinkFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.LinksNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.LinksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AppLinkBuilder builder;
        private final int index;

            LinksNestedImpl(int index,AppLink item) {
                this.index = index;
                this.builder = new AppLinkBuilder(this, item);
                        
            }

            LinksNestedImpl() {
                this.index = -1;
                this.builder = new AppLinkBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterServiceVersionSpecFluentImpl.this.setToLinks(index,builder.build());
            }

            public N endLink() {
                return and();
            }
    }


    public class MaintainersNestedImpl<N> extends MaintainerFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.MaintainersNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.MaintainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MaintainerBuilder builder;
        private final int index;

            MaintainersNestedImpl(int index,Maintainer item) {
                this.index = index;
                this.builder = new MaintainerBuilder(this, item);
                        
            }

            MaintainersNestedImpl() {
                this.index = -1;
                this.builder = new MaintainerBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterServiceVersionSpecFluentImpl.this.setToMaintainers(index,builder.build());
            }

            public N endMaintainer() {
                return and();
            }
    }


    public class ProviderNestedImpl<N> extends AppLinkFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ProviderNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.ProviderNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AppLinkBuilder builder;

            ProviderNestedImpl(AppLink item) {
                this.builder = new AppLinkBuilder(this, item);
                        
            }

            ProviderNestedImpl() {
                this.builder = new AppLinkBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterServiceVersionSpecFluentImpl.this.withProvider(builder.build());
            }

            public N endProvider() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.SelectorNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            SelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterServiceVersionSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


    public class WebhookdefinitionsNestedImpl<N> extends WebhookDescriptionFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final WebhookDescriptionBuilder builder;
        private final int index;

            WebhookdefinitionsNestedImpl(int index,WebhookDescription item) {
                this.index = index;
                this.builder = new WebhookDescriptionBuilder(this, item);
                        
            }

            WebhookdefinitionsNestedImpl() {
                this.index = -1;
                this.builder = new WebhookDescriptionBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterServiceVersionSpecFluentImpl.this.setToWebhookdefinitions(index,builder.build());
            }

            public N endWebhookdefinition() {
                return and();
            }
    }


}
