package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BundleLookupConditionBuilder extends BundleLookupConditionFluentImpl<BundleLookupConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<BundleLookupCondition,BundleLookupConditionBuilder> {

    BundleLookupConditionFluent<?> fluent;
    Boolean validationEnabled;

    public BundleLookupConditionBuilder() {
        this(true);
    }

    public BundleLookupConditionBuilder(Boolean validationEnabled) {
        this(new BundleLookupCondition(), validationEnabled);
    }

    public BundleLookupConditionBuilder(BundleLookupConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public BundleLookupConditionBuilder(BundleLookupConditionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BundleLookupCondition(), validationEnabled);
    }

    public BundleLookupConditionBuilder(BundleLookupConditionFluent<?> fluent,BundleLookupCondition instance) {
        this(fluent, instance, true);
    }

    public BundleLookupConditionBuilder(BundleLookupConditionFluent<?> fluent,BundleLookupCondition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public BundleLookupConditionBuilder(BundleLookupCondition instance) {
        this(instance,true);
    }

    public BundleLookupConditionBuilder(BundleLookupCondition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withLastUpdateTime(instance.getLastUpdateTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public BundleLookupCondition build() {
        BundleLookupCondition buildable = new BundleLookupCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BundleLookupConditionBuilder that = (BundleLookupConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
