package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class SubscriptionConfigFluentImpl<A extends SubscriptionConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscriptionConfigFluent<A> {

    private List<EnvVar> env = new ArrayList<EnvVar>();
    private List<EnvFromSource> envFrom = new ArrayList<EnvFromSource>();
    private Map<String,String> nodeSelector;
    private ResourceRequirementsBuilder resources;
    private LabelSelectorBuilder selector;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private List<Volume> volumes = new ArrayList<Volume>();

    public SubscriptionConfigFluentImpl() {
    }

    public SubscriptionConfigFluentImpl(SubscriptionConfig instance) {
        this.withEnv(instance.getEnv()); 
        this.withEnvFrom(instance.getEnvFrom()); 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withResources(instance.getResources()); 
        this.withSelector(instance.getSelector()); 
        this.withTolerations(instance.getTolerations()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
    }

    public A addToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        this.env.add(index, item);
        return (A)this;
    }

    public A setToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        this.env.set(index, item); return (A)this;
    }

    public A addToEnv(EnvVar... items) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items) {
        for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public List<EnvVar> getEnv() {
        return this.env;
    }

    public EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    public EnvVar getLastEnv() {
        return this.env.get(env.size() - 1);
    }

    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new ArrayList<EnvVar>(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(EnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public A addToEnvFrom(int index,EnvFromSource item) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
        this.envFrom.add(index, item);
        return (A)this;
    }

    public A setToEnvFrom(int index,EnvFromSource item) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
        this.envFrom.set(index, item); return (A)this;
    }

    public A addToEnvFrom(EnvFromSource... items) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
        for (EnvFromSource item : items) {this.envFrom.add(item);} return (A)this;
    }

    public A addAllToEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
        for (EnvFromSource item : items) {this.envFrom.add(item);} return (A)this;
    }

    public A removeFromEnvFrom(EnvFromSource... items) {
        for (EnvFromSource item : items) {if (this.envFrom!= null){ this.envFrom.remove(item);}} return (A)this;
    }

    public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
        for (EnvFromSource item : items) {if (this.envFrom!= null){ this.envFrom.remove(item);}} return (A)this;
    }

    public List<EnvFromSource> getEnvFrom() {
        return this.envFrom;
    }

    public EnvFromSource getEnvFrom(int index) {
        return this.envFrom.get(index);
    }

    public EnvFromSource getFirstEnvFrom() {
        return this.envFrom.get(0);
    }

    public EnvFromSource getLastEnvFrom() {
        return this.envFrom.get(envFrom.size() - 1);
    }

    public EnvFromSource getMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
        for (EnvFromSource item: envFrom) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
        for (EnvFromSource item: envFrom) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnvFrom(List<EnvFromSource> envFrom) {
        if (this.envFrom != null) { _visitables.get("envFrom").removeAll(this.envFrom);}
        if (envFrom != null) {this.envFrom = new ArrayList<EnvFromSource>(); for (EnvFromSource item : envFrom){this.addToEnvFrom(item);}} else { this.envFrom = null;} return (A) this;
    }

    public A withEnvFrom(EnvFromSource... envFrom) {
        if (this.envFrom != null) {this.envFrom.clear();}
        if (envFrom != null) {for (EnvFromSource item :envFrom){ this.addToEnvFrom(item);}} return (A) this;
    }

    public Boolean hasEnvFrom() {
        return envFrom != null && !envFrom.isEmpty();
    }

    public A addToNodeSelector(String key,String value) {
        if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if(this.nodeSelector == null) { return (A) this; }
        if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K extends Object,V extends Object>A withNodeSelector(Map<String,String> nodeSelector) {
        if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap<String,String>(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public ResourceRequirements buildResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public A withResources(ResourceRequirements resources) {
        _visitables.get("resources").remove(this.resources);
        if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    public SubscriptionConfigFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    public SubscriptionConfigFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    public SubscriptionConfigFluent.ResourcesNested<A> editResources() {
        return withNewResourcesLike(getResources());
    }

    public SubscriptionConfigFluent.ResourcesNested<A> editOrNewResources() {
        return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
    }

    public SubscriptionConfigFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public SubscriptionConfigFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public SubscriptionConfigFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    public SubscriptionConfigFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public SubscriptionConfigFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
    }

    public SubscriptionConfigFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public A addToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        this.volumeMounts.add(index, item);
        return (A)this;
    }

    public A setToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        this.volumeMounts.set(index, item); return (A)this;
    }

    public A addToVolumeMounts(VolumeMount... items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
    }

    public A removeFromVolumeMounts(VolumeMount... items) {
        for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public VolumeMount getVolumeMount(int index) {
        return this.volumeMounts.get(index);
    }

    public VolumeMount getFirstVolumeMount() {
        return this.volumeMounts.get(0);
    }

    public VolumeMount getLastVolumeMount() {
        return this.volumeMounts.get(volumeMounts.size() - 1);
    }

    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
        if (volumeMounts != null) {this.volumeMounts = new ArrayList<VolumeMount>(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
    }

    public A withVolumeMounts(VolumeMount... volumeMounts) {
        if (this.volumeMounts != null) {this.volumeMounts.clear();}
        if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public Boolean hasVolumeMounts() {
        return volumeMounts != null && !volumeMounts.isEmpty();
    }

    public A addToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        this.volumes.add(index, item);
        return (A)this;
    }

    public A setToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        this.volumes.set(index, item); return (A)this;
    }

    public A addToVolumes(Volume... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(Volume... items) {
        for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    public Volume getLastVolume() {
        return this.volumes.get(volumes.size() - 1);
    }

    public Volume getMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item: volumes) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new ArrayList<Volume>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(Volume... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubscriptionConfigFluentImpl that = (SubscriptionConfigFluentImpl) o;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (envFrom != null ? !envFrom.equals(that.envFrom) :that.envFrom != null) return false;
        if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(env,  envFrom,  nodeSelector,  resources,  selector,  tolerations,  volumeMounts,  volumes,  super.hashCode());
    }

    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<SubscriptionConfigFluent.ResourcesNested<N>> implements SubscriptionConfigFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceRequirementsBuilder builder;

            ResourcesNestedImpl(ResourceRequirements item) {
                this.builder = new ResourceRequirementsBuilder(this, item);
                        
            }

            ResourcesNestedImpl() {
                this.builder = new ResourceRequirementsBuilder(this);
                        
            }

            public N and() {
                return (N) SubscriptionConfigFluentImpl.this.withResources(builder.build());
            }

            public N endResources() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<SubscriptionConfigFluent.SelectorNested<N>> implements SubscriptionConfigFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            SelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) SubscriptionConfigFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
