package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface InstallPlanSpecFluent<A extends InstallPlanSpecFluent<A>> extends Fluent<A> {


    public String getApproval();
    public A withApproval(String approval);
    public Boolean hasApproval();
    public A withNewApproval(StringBuilder arg1);
    public A withNewApproval(int[] arg1,int arg2,int arg3);
    public A withNewApproval(char[] arg1);
    public A withNewApproval(StringBuffer arg1);
    public A withNewApproval(byte[] arg1,int arg2);
    public A withNewApproval(byte[] arg1);
    public A withNewApproval(char[] arg1,int arg2,int arg3);
    public A withNewApproval(byte[] arg1,int arg2,int arg3);
    public A withNewApproval(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApproval(String arg1);
    public Boolean getApproved();
    public A withApproved(Boolean approved);
    public Boolean hasApproved();
    public A withNewApproved(String arg1);
    public A withNewApproved(boolean arg1);
    public A addToClusterServiceVersionNames(int index,String item);
    public A setToClusterServiceVersionNames(int index,String item);
    public A addToClusterServiceVersionNames(String... items);
    public A addAllToClusterServiceVersionNames(Collection<String> items);
    public A removeFromClusterServiceVersionNames(String... items);
    public A removeAllFromClusterServiceVersionNames(Collection<String> items);
    public List<String> getClusterServiceVersionNames();
    public String getClusterServiceVersionName(int index);
    public String getFirstClusterServiceVersionName();
    public String getLastClusterServiceVersionName();
    public String getMatchingClusterServiceVersionName(Predicate<String> predicate);
    public Boolean hasMatchingClusterServiceVersionName(Predicate<String> predicate);
    public A withClusterServiceVersionNames(List<String> clusterServiceVersionNames);
    public A withClusterServiceVersionNames(String... clusterServiceVersionNames);
    public Boolean hasClusterServiceVersionNames();
    public A addNewClusterServiceVersionName(StringBuilder arg1);
    public A addNewClusterServiceVersionName(int[] arg1,int arg2,int arg3);
    public A addNewClusterServiceVersionName(char[] arg1);
    public A addNewClusterServiceVersionName(StringBuffer arg1);
    public A addNewClusterServiceVersionName(byte[] arg1,int arg2);
    public A addNewClusterServiceVersionName(byte[] arg1);
    public A addNewClusterServiceVersionName(char[] arg1,int arg2,int arg3);
    public A addNewClusterServiceVersionName(byte[] arg1,int arg2,int arg3);
    public A addNewClusterServiceVersionName(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewClusterServiceVersionName(String arg1);
    public Integer getGeneration();
    public A withGeneration(Integer generation);
    public Boolean hasGeneration();
    public A withNewGeneration(int arg1);
    public String getSource();
    public A withSource(String source);
    public Boolean hasSource();
    public A withNewSource(StringBuilder arg1);
    public A withNewSource(int[] arg1,int arg2,int arg3);
    public A withNewSource(char[] arg1);
    public A withNewSource(StringBuffer arg1);
    public A withNewSource(byte[] arg1,int arg2);
    public A withNewSource(byte[] arg1);
    public A withNewSource(char[] arg1,int arg2,int arg3);
    public A withNewSource(byte[] arg1,int arg2,int arg3);
    public A withNewSource(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSource(String arg1);
    public String getSourceNamespace();
    public A withSourceNamespace(String sourceNamespace);
    public Boolean hasSourceNamespace();
    public A withNewSourceNamespace(StringBuilder arg1);
    public A withNewSourceNamespace(int[] arg1,int arg2,int arg3);
    public A withNewSourceNamespace(char[] arg1);
    public A withNewSourceNamespace(StringBuffer arg1);
    public A withNewSourceNamespace(byte[] arg1,int arg2);
    public A withNewSourceNamespace(byte[] arg1);
    public A withNewSourceNamespace(char[] arg1,int arg2,int arg3);
    public A withNewSourceNamespace(byte[] arg1,int arg2,int arg3);
    public A withNewSourceNamespace(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSourceNamespace(String arg1);
}
