package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InstallPlanSpecBuilder extends InstallPlanSpecFluentImpl<InstallPlanSpecBuilder> implements VisitableBuilder<InstallPlanSpec,InstallPlanSpecBuilder> {

    InstallPlanSpecFluent<?> fluent;
    Boolean validationEnabled;

    public InstallPlanSpecBuilder() {
        this(true);
    }

    public InstallPlanSpecBuilder(Boolean validationEnabled) {
        this(new InstallPlanSpec(), validationEnabled);
    }

    public InstallPlanSpecBuilder(InstallPlanSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public InstallPlanSpecBuilder(InstallPlanSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new InstallPlanSpec(), validationEnabled);
    }

    public InstallPlanSpecBuilder(InstallPlanSpecFluent<?> fluent,InstallPlanSpec instance) {
        this(fluent, instance, true);
    }

    public InstallPlanSpecBuilder(InstallPlanSpecFluent<?> fluent,InstallPlanSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApproval(instance.getApproval()); 
        fluent.withApproved(instance.getApproved()); 
        fluent.withClusterServiceVersionNames(instance.getClusterServiceVersionNames()); 
        fluent.withGeneration(instance.getGeneration()); 
        fluent.withSource(instance.getSource()); 
        fluent.withSourceNamespace(instance.getSourceNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public InstallPlanSpecBuilder(InstallPlanSpec instance) {
        this(instance,true);
    }

    public InstallPlanSpecBuilder(InstallPlanSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApproval(instance.getApproval()); 
        this.withApproved(instance.getApproved()); 
        this.withClusterServiceVersionNames(instance.getClusterServiceVersionNames()); 
        this.withGeneration(instance.getGeneration()); 
        this.withSource(instance.getSource()); 
        this.withSourceNamespace(instance.getSourceNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public InstallPlanSpec build() {
        InstallPlanSpec buildable = new InstallPlanSpec(fluent.getApproval(),fluent.getApproved(),fluent.getClusterServiceVersionNames(),fluent.getGeneration(),fluent.getSource(),fluent.getSourceNamespace());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InstallPlanSpecBuilder that = (InstallPlanSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
