package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface CRDDescriptionFluent<A extends CRDDescriptionFluent<A>> extends Fluent<A> {


    public A addToActionDescriptors(int index,ActionDescriptor item);
    public A setToActionDescriptors(int index,ActionDescriptor item);
    public A addToActionDescriptors(ActionDescriptor... items);
    public A addAllToActionDescriptors(Collection<ActionDescriptor> items);
    public A removeFromActionDescriptors(ActionDescriptor... items);
    public A removeAllFromActionDescriptors(Collection<ActionDescriptor> items);
    public A removeMatchingFromActionDescriptors(Predicate<ActionDescriptorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildActionDescriptors instead.
 * @return The buildable object.
 */
@Deprecated public List<ActionDescriptor> getActionDescriptors();
    public List<ActionDescriptor> buildActionDescriptors();
    public ActionDescriptor buildActionDescriptor(int index);
    public ActionDescriptor buildFirstActionDescriptor();
    public ActionDescriptor buildLastActionDescriptor();
    public ActionDescriptor buildMatchingActionDescriptor(Predicate<ActionDescriptorBuilder> predicate);
    public Boolean hasMatchingActionDescriptor(Predicate<ActionDescriptorBuilder> predicate);
    public A withActionDescriptors(List<ActionDescriptor> actionDescriptors);
    public A withActionDescriptors(ActionDescriptor... actionDescriptors);
    public Boolean hasActionDescriptors();
    public CRDDescriptionFluent.ActionDescriptorsNested<A> addNewActionDescriptor();
    public CRDDescriptionFluent.ActionDescriptorsNested<A> addNewActionDescriptorLike(ActionDescriptor item);
    public CRDDescriptionFluent.ActionDescriptorsNested<A> setNewActionDescriptorLike(int index,ActionDescriptor item);
    public CRDDescriptionFluent.ActionDescriptorsNested<A> editActionDescriptor(int index);
    public CRDDescriptionFluent.ActionDescriptorsNested<A> editFirstActionDescriptor();
    public CRDDescriptionFluent.ActionDescriptorsNested<A> editLastActionDescriptor();
    public CRDDescriptionFluent.ActionDescriptorsNested<A> editMatchingActionDescriptor(Predicate<ActionDescriptorBuilder> predicate);
    public String getDescription();
    public A withDescription(String description);
    public Boolean hasDescription();
    public A withNewDescription(StringBuilder arg1);
    public A withNewDescription(int[] arg1,int arg2,int arg3);
    public A withNewDescription(char[] arg1);
    public A withNewDescription(StringBuffer arg1);
    public A withNewDescription(byte[] arg1,int arg2);
    public A withNewDescription(byte[] arg1);
    public A withNewDescription(char[] arg1,int arg2,int arg3);
    public A withNewDescription(byte[] arg1,int arg2,int arg3);
    public A withNewDescription(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDescription(String arg1);
    public String getDisplayName();
    public A withDisplayName(String displayName);
    public Boolean hasDisplayName();
    public A withNewDisplayName(StringBuilder arg1);
    public A withNewDisplayName(int[] arg1,int arg2,int arg3);
    public A withNewDisplayName(char[] arg1);
    public A withNewDisplayName(StringBuffer arg1);
    public A withNewDisplayName(byte[] arg1,int arg2);
    public A withNewDisplayName(byte[] arg1);
    public A withNewDisplayName(char[] arg1,int arg2,int arg3);
    public A withNewDisplayName(byte[] arg1,int arg2,int arg3);
    public A withNewDisplayName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDisplayName(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
    public A addToResources(int index,APIResourceReference item);
    public A setToResources(int index,APIResourceReference item);
    public A addToResources(APIResourceReference... items);
    public A addAllToResources(Collection<APIResourceReference> items);
    public A removeFromResources(APIResourceReference... items);
    public A removeAllFromResources(Collection<APIResourceReference> items);
    public A removeMatchingFromResources(Predicate<APIResourceReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<APIResourceReference> getResources();
    public List<APIResourceReference> buildResources();
    public APIResourceReference buildResource(int index);
    public APIResourceReference buildFirstResource();
    public APIResourceReference buildLastResource();
    public APIResourceReference buildMatchingResource(Predicate<APIResourceReferenceBuilder> predicate);
    public Boolean hasMatchingResource(Predicate<APIResourceReferenceBuilder> predicate);
    public A withResources(List<APIResourceReference> resources);
    public A withResources(APIResourceReference... resources);
    public Boolean hasResources();
    public A addNewResource(String kind,String name,String version);
    public CRDDescriptionFluent.ResourcesNested<A> addNewResource();
    public CRDDescriptionFluent.ResourcesNested<A> addNewResourceLike(APIResourceReference item);
    public CRDDescriptionFluent.ResourcesNested<A> setNewResourceLike(int index,APIResourceReference item);
    public CRDDescriptionFluent.ResourcesNested<A> editResource(int index);
    public CRDDescriptionFluent.ResourcesNested<A> editFirstResource();
    public CRDDescriptionFluent.ResourcesNested<A> editLastResource();
    public CRDDescriptionFluent.ResourcesNested<A> editMatchingResource(Predicate<APIResourceReferenceBuilder> predicate);
    public A addToSpecDescriptors(int index,SpecDescriptor item);
    public A setToSpecDescriptors(int index,SpecDescriptor item);
    public A addToSpecDescriptors(SpecDescriptor... items);
    public A addAllToSpecDescriptors(Collection<SpecDescriptor> items);
    public A removeFromSpecDescriptors(SpecDescriptor... items);
    public A removeAllFromSpecDescriptors(Collection<SpecDescriptor> items);
    public A removeMatchingFromSpecDescriptors(Predicate<SpecDescriptorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSpecDescriptors instead.
 * @return The buildable object.
 */
@Deprecated public List<SpecDescriptor> getSpecDescriptors();
    public List<SpecDescriptor> buildSpecDescriptors();
    public SpecDescriptor buildSpecDescriptor(int index);
    public SpecDescriptor buildFirstSpecDescriptor();
    public SpecDescriptor buildLastSpecDescriptor();
    public SpecDescriptor buildMatchingSpecDescriptor(Predicate<SpecDescriptorBuilder> predicate);
    public Boolean hasMatchingSpecDescriptor(Predicate<SpecDescriptorBuilder> predicate);
    public A withSpecDescriptors(List<SpecDescriptor> specDescriptors);
    public A withSpecDescriptors(SpecDescriptor... specDescriptors);
    public Boolean hasSpecDescriptors();
    public CRDDescriptionFluent.SpecDescriptorsNested<A> addNewSpecDescriptor();
    public CRDDescriptionFluent.SpecDescriptorsNested<A> addNewSpecDescriptorLike(SpecDescriptor item);
    public CRDDescriptionFluent.SpecDescriptorsNested<A> setNewSpecDescriptorLike(int index,SpecDescriptor item);
    public CRDDescriptionFluent.SpecDescriptorsNested<A> editSpecDescriptor(int index);
    public CRDDescriptionFluent.SpecDescriptorsNested<A> editFirstSpecDescriptor();
    public CRDDescriptionFluent.SpecDescriptorsNested<A> editLastSpecDescriptor();
    public CRDDescriptionFluent.SpecDescriptorsNested<A> editMatchingSpecDescriptor(Predicate<SpecDescriptorBuilder> predicate);
    public A addToStatusDescriptors(int index,StatusDescriptor item);
    public A setToStatusDescriptors(int index,StatusDescriptor item);
    public A addToStatusDescriptors(StatusDescriptor... items);
    public A addAllToStatusDescriptors(Collection<StatusDescriptor> items);
    public A removeFromStatusDescriptors(StatusDescriptor... items);
    public A removeAllFromStatusDescriptors(Collection<StatusDescriptor> items);
    public A removeMatchingFromStatusDescriptors(Predicate<StatusDescriptorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildStatusDescriptors instead.
 * @return The buildable object.
 */
@Deprecated public List<StatusDescriptor> getStatusDescriptors();
    public List<StatusDescriptor> buildStatusDescriptors();
    public StatusDescriptor buildStatusDescriptor(int index);
    public StatusDescriptor buildFirstStatusDescriptor();
    public StatusDescriptor buildLastStatusDescriptor();
    public StatusDescriptor buildMatchingStatusDescriptor(Predicate<StatusDescriptorBuilder> predicate);
    public Boolean hasMatchingStatusDescriptor(Predicate<StatusDescriptorBuilder> predicate);
    public A withStatusDescriptors(List<StatusDescriptor> statusDescriptors);
    public A withStatusDescriptors(StatusDescriptor... statusDescriptors);
    public Boolean hasStatusDescriptors();
    public CRDDescriptionFluent.StatusDescriptorsNested<A> addNewStatusDescriptor();
    public CRDDescriptionFluent.StatusDescriptorsNested<A> addNewStatusDescriptorLike(StatusDescriptor item);
    public CRDDescriptionFluent.StatusDescriptorsNested<A> setNewStatusDescriptorLike(int index,StatusDescriptor item);
    public CRDDescriptionFluent.StatusDescriptorsNested<A> editStatusDescriptor(int index);
    public CRDDescriptionFluent.StatusDescriptorsNested<A> editFirstStatusDescriptor();
    public CRDDescriptionFluent.StatusDescriptorsNested<A> editLastStatusDescriptor();
    public CRDDescriptionFluent.StatusDescriptorsNested<A> editMatchingStatusDescriptor(Predicate<StatusDescriptorBuilder> predicate);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(int[] arg1,int arg2,int arg3);
    public A withNewVersion(char[] arg1);
    public A withNewVersion(StringBuffer arg1);
    public A withNewVersion(byte[] arg1,int arg2);
    public A withNewVersion(byte[] arg1);
    public A withNewVersion(char[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersion(String arg1);
    public interface ActionDescriptorsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ActionDescriptorFluent<CRDDescriptionFluent.ActionDescriptorsNested<N>> {

            public N and();
            public N endActionDescriptor();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIResourceReferenceFluent<CRDDescriptionFluent.ResourcesNested<N>> {

            public N and();
            public N endResource();    }


    public interface SpecDescriptorsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SpecDescriptorFluent<CRDDescriptionFluent.SpecDescriptorsNested<N>> {

            public N and();
            public N endSpecDescriptor();    }


    public interface StatusDescriptorsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StatusDescriptorFluent<CRDDescriptionFluent.StatusDescriptorsNested<N>> {

            public N and();
            public N endStatusDescriptor();    }


}
