package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

public class SubscriptionStatusFluentImpl<A extends SubscriptionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscriptionStatusFluent<A> {

    private List<SubscriptionCatalogHealthBuilder> catalogHealth =  new ArrayList<SubscriptionCatalogHealthBuilder>();
    private List<SubscriptionConditionBuilder> conditions =  new ArrayList<SubscriptionConditionBuilder>();
    private String currentCSV;
    private Integer installPlanGeneration;
    private ObjectReferenceBuilder installPlanRef;
    private String installedCSV;
    private InstallPlanReferenceBuilder installplan;
    private String lastUpdated;
    private String reason;
    private String state;

    public SubscriptionStatusFluentImpl() {
    }

    public SubscriptionStatusFluentImpl(SubscriptionStatus instance) {
        this.withCatalogHealth(instance.getCatalogHealth()); 
        this.withConditions(instance.getConditions()); 
        this.withCurrentCSV(instance.getCurrentCSV()); 
        this.withInstallPlanGeneration(instance.getInstallPlanGeneration()); 
        this.withInstallPlanRef(instance.getInstallPlanRef()); 
        this.withInstalledCSV(instance.getInstalledCSV()); 
        this.withInstallplan(instance.getInstallplan()); 
        this.withLastUpdated(instance.getLastUpdated()); 
        this.withReason(instance.getReason()); 
        this.withState(instance.getState()); 
    }

    public A addToCatalogHealth(int index,SubscriptionCatalogHealth item) {
        if (this.catalogHealth == null) {this.catalogHealth = new ArrayList<SubscriptionCatalogHealthBuilder>();}
        SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);_visitables.get("catalogHealth").add(index >= 0 ? index : _visitables.get("catalogHealth").size(), builder);this.catalogHealth.add(index >= 0 ? index : catalogHealth.size(), builder); return (A)this;
    }

    public A setToCatalogHealth(int index,SubscriptionCatalogHealth item) {
        if (this.catalogHealth == null) {this.catalogHealth = new ArrayList<SubscriptionCatalogHealthBuilder>();}
        SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);
        if (index < 0 || index >= _visitables.get("catalogHealth").size()) { _visitables.get("catalogHealth").add(builder); } else { _visitables.get("catalogHealth").set(index, builder);}
        if (index < 0 || index >= catalogHealth.size()) { catalogHealth.add(builder); } else { catalogHealth.set(index, builder);}
         return (A)this;
    }

    public A addToCatalogHealth(SubscriptionCatalogHealth... items) {
        if (this.catalogHealth == null) {this.catalogHealth = new ArrayList<SubscriptionCatalogHealthBuilder>();}
        for (SubscriptionCatalogHealth item : items) {SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);_visitables.get("catalogHealth").add(builder);this.catalogHealth.add(builder);} return (A)this;
    }

    public A addAllToCatalogHealth(Collection<SubscriptionCatalogHealth> items) {
        if (this.catalogHealth == null) {this.catalogHealth = new ArrayList<SubscriptionCatalogHealthBuilder>();}
        for (SubscriptionCatalogHealth item : items) {SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);_visitables.get("catalogHealth").add(builder);this.catalogHealth.add(builder);} return (A)this;
    }

    public A removeFromCatalogHealth(SubscriptionCatalogHealth... items) {
        for (SubscriptionCatalogHealth item : items) {SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);_visitables.get("catalogHealth").remove(builder);if (this.catalogHealth != null) {this.catalogHealth.remove(builder);}} return (A)this;
    }

    public A removeAllFromCatalogHealth(Collection<SubscriptionCatalogHealth> items) {
        for (SubscriptionCatalogHealth item : items) {SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);_visitables.get("catalogHealth").remove(builder);if (this.catalogHealth != null) {this.catalogHealth.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
        if (catalogHealth == null) return (A) this;
        final Iterator<SubscriptionCatalogHealthBuilder> each = catalogHealth.iterator();
        final List visitables = _visitables.get("catalogHealth");
        while (each.hasNext()) {
          SubscriptionCatalogHealthBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildCatalogHealth instead.
 * @return The buildable object.
 */
@Deprecated public List<SubscriptionCatalogHealth> getCatalogHealth() {
        return build(catalogHealth);
    }

    public List<SubscriptionCatalogHealth> buildCatalogHealth() {
        return build(catalogHealth);
    }

    public SubscriptionCatalogHealth buildCatalogHealth(int index) {
        return this.catalogHealth.get(index).build();
    }

    public SubscriptionCatalogHealth buildFirstCatalogHealth() {
        return this.catalogHealth.get(0).build();
    }

    public SubscriptionCatalogHealth buildLastCatalogHealth() {
        return this.catalogHealth.get(catalogHealth.size() - 1).build();
    }

    public SubscriptionCatalogHealth buildMatchingCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
        for (SubscriptionCatalogHealthBuilder item: catalogHealth) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
        for (SubscriptionCatalogHealthBuilder item: catalogHealth) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCatalogHealth(List<SubscriptionCatalogHealth> catalogHealth) {
        if (this.catalogHealth != null) { _visitables.get("catalogHealth").removeAll(this.catalogHealth);}
        if (catalogHealth != null) {this.catalogHealth = new ArrayList<SubscriptionCatalogHealthBuilder>(); for (SubscriptionCatalogHealth item : catalogHealth){this.addToCatalogHealth(item);}} else { this.catalogHealth = null;} return (A) this;
    }

    public A withCatalogHealth(SubscriptionCatalogHealth... catalogHealth) {
        if (this.catalogHealth != null) {this.catalogHealth.clear();}
        if (catalogHealth != null) {for (SubscriptionCatalogHealth item :catalogHealth){ this.addToCatalogHealth(item);}} return (A) this;
    }

    public Boolean hasCatalogHealth() {
        return catalogHealth != null && !catalogHealth.isEmpty();
    }

    public SubscriptionStatusFluent.CatalogHealthNested<A> addNewCatalogHealth() {
        return new CatalogHealthNestedImpl();
    }

    public SubscriptionStatusFluent.CatalogHealthNested<A> addNewCatalogHealthLike(SubscriptionCatalogHealth item) {
        return new CatalogHealthNestedImpl(-1, item);
    }

    public SubscriptionStatusFluent.CatalogHealthNested<A> setNewCatalogHealthLike(int index,SubscriptionCatalogHealth item) {
        return new CatalogHealthNestedImpl(index, item);
    }

    public SubscriptionStatusFluent.CatalogHealthNested<A> editCatalogHealth(int index) {
        if (catalogHealth.size() <= index) throw new RuntimeException("Can't edit catalogHealth. Index exceeds size.");
        return setNewCatalogHealthLike(index, buildCatalogHealth(index));
    }

    public SubscriptionStatusFluent.CatalogHealthNested<A> editFirstCatalogHealth() {
        if (catalogHealth.size() == 0) throw new RuntimeException("Can't edit first catalogHealth. The list is empty.");
        return setNewCatalogHealthLike(0, buildCatalogHealth(0));
    }

    public SubscriptionStatusFluent.CatalogHealthNested<A> editLastCatalogHealth() {
        int index = catalogHealth.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last catalogHealth. The list is empty.");
        return setNewCatalogHealthLike(index, buildCatalogHealth(index));
    }

    public SubscriptionStatusFluent.CatalogHealthNested<A> editMatchingCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
        int index = -1;
        for (int i=0;i<catalogHealth.size();i++) { 
        if (predicate.test(catalogHealth.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching catalogHealth. No match found.");
        return setNewCatalogHealthLike(index, buildCatalogHealth(index));
    }

    public A addToConditions(int index,SubscriptionCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<SubscriptionConditionBuilder>();}
        SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,SubscriptionCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<SubscriptionConditionBuilder>();}
        SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(SubscriptionCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<SubscriptionConditionBuilder>();}
        for (SubscriptionCondition item : items) {SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<SubscriptionCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<SubscriptionConditionBuilder>();}
        for (SubscriptionCondition item : items) {SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(SubscriptionCondition... items) {
        for (SubscriptionCondition item : items) {SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<SubscriptionCondition> items) {
        for (SubscriptionCondition item : items) {SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<SubscriptionConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<SubscriptionConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          SubscriptionConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<SubscriptionCondition> getConditions() {
        return build(conditions);
    }

    public List<SubscriptionCondition> buildConditions() {
        return build(conditions);
    }

    public SubscriptionCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public SubscriptionCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public SubscriptionCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public SubscriptionCondition buildMatchingCondition(Predicate<SubscriptionConditionBuilder> predicate) {
        for (SubscriptionConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<SubscriptionConditionBuilder> predicate) {
        for (SubscriptionConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<SubscriptionCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<SubscriptionConditionBuilder>(); for (SubscriptionCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(SubscriptionCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (SubscriptionCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public SubscriptionStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public SubscriptionStatusFluent.ConditionsNested<A> addNewConditionLike(SubscriptionCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public SubscriptionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,SubscriptionCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public SubscriptionStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public SubscriptionStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public SubscriptionStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public SubscriptionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<SubscriptionConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public String getCurrentCSV() {
        return this.currentCSV;
    }

    public A withCurrentCSV(String currentCSV) {
        this.currentCSV=currentCSV; return (A) this;
    }

    public Boolean hasCurrentCSV() {
        return this.currentCSV != null;
    }

    public A withNewCurrentCSV(StringBuilder arg1) {
        return (A)withCurrentCSV(new String(arg1));
    }

    public A withNewCurrentCSV(int[] arg1,int arg2,int arg3) {
        return (A)withCurrentCSV(new String(arg1, arg2, arg3));
    }

    public A withNewCurrentCSV(char[] arg1) {
        return (A)withCurrentCSV(new String(arg1));
    }

    public A withNewCurrentCSV(StringBuffer arg1) {
        return (A)withCurrentCSV(new String(arg1));
    }

    public A withNewCurrentCSV(byte[] arg1,int arg2) {
        return (A)withCurrentCSV(new String(arg1, arg2));
    }

    public A withNewCurrentCSV(byte[] arg1) {
        return (A)withCurrentCSV(new String(arg1));
    }

    public A withNewCurrentCSV(char[] arg1,int arg2,int arg3) {
        return (A)withCurrentCSV(new String(arg1, arg2, arg3));
    }

    public A withNewCurrentCSV(byte[] arg1,int arg2,int arg3) {
        return (A)withCurrentCSV(new String(arg1, arg2, arg3));
    }

    public A withNewCurrentCSV(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCurrentCSV(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCurrentCSV(String arg1) {
        return (A)withCurrentCSV(new String(arg1));
    }

    public Integer getInstallPlanGeneration() {
        return this.installPlanGeneration;
    }

    public A withInstallPlanGeneration(Integer installPlanGeneration) {
        this.installPlanGeneration=installPlanGeneration; return (A) this;
    }

    public Boolean hasInstallPlanGeneration() {
        return this.installPlanGeneration != null;
    }

    public A withNewInstallPlanGeneration(int arg1) {
        return (A)withInstallPlanGeneration(new Integer(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildInstallPlanRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getInstallPlanRef() {
        return this.installPlanRef!=null?this.installPlanRef.build():null;
    }

    public ObjectReference buildInstallPlanRef() {
        return this.installPlanRef!=null?this.installPlanRef.build():null;
    }

    public A withInstallPlanRef(ObjectReference installPlanRef) {
        _visitables.get("installPlanRef").remove(this.installPlanRef);
        if (installPlanRef!=null){ this.installPlanRef= new ObjectReferenceBuilder(installPlanRef); _visitables.get("installPlanRef").add(this.installPlanRef);} return (A) this;
    }

    public Boolean hasInstallPlanRef() {
        return this.installPlanRef != null;
    }

    public SubscriptionStatusFluent.InstallPlanRefNested<A> withNewInstallPlanRef() {
        return new InstallPlanRefNestedImpl();
    }

    public SubscriptionStatusFluent.InstallPlanRefNested<A> withNewInstallPlanRefLike(ObjectReference item) {
        return new InstallPlanRefNestedImpl(item);
    }

    public SubscriptionStatusFluent.InstallPlanRefNested<A> editInstallPlanRef() {
        return withNewInstallPlanRefLike(getInstallPlanRef());
    }

    public SubscriptionStatusFluent.InstallPlanRefNested<A> editOrNewInstallPlanRef() {
        return withNewInstallPlanRefLike(getInstallPlanRef() != null ? getInstallPlanRef(): new ObjectReferenceBuilder().build());
    }

    public SubscriptionStatusFluent.InstallPlanRefNested<A> editOrNewInstallPlanRefLike(ObjectReference item) {
        return withNewInstallPlanRefLike(getInstallPlanRef() != null ? getInstallPlanRef(): item);
    }

    public String getInstalledCSV() {
        return this.installedCSV;
    }

    public A withInstalledCSV(String installedCSV) {
        this.installedCSV=installedCSV; return (A) this;
    }

    public Boolean hasInstalledCSV() {
        return this.installedCSV != null;
    }

    public A withNewInstalledCSV(StringBuilder arg1) {
        return (A)withInstalledCSV(new String(arg1));
    }

    public A withNewInstalledCSV(int[] arg1,int arg2,int arg3) {
        return (A)withInstalledCSV(new String(arg1, arg2, arg3));
    }

    public A withNewInstalledCSV(char[] arg1) {
        return (A)withInstalledCSV(new String(arg1));
    }

    public A withNewInstalledCSV(StringBuffer arg1) {
        return (A)withInstalledCSV(new String(arg1));
    }

    public A withNewInstalledCSV(byte[] arg1,int arg2) {
        return (A)withInstalledCSV(new String(arg1, arg2));
    }

    public A withNewInstalledCSV(byte[] arg1) {
        return (A)withInstalledCSV(new String(arg1));
    }

    public A withNewInstalledCSV(char[] arg1,int arg2,int arg3) {
        return (A)withInstalledCSV(new String(arg1, arg2, arg3));
    }

    public A withNewInstalledCSV(byte[] arg1,int arg2,int arg3) {
        return (A)withInstalledCSV(new String(arg1, arg2, arg3));
    }

    public A withNewInstalledCSV(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withInstalledCSV(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewInstalledCSV(String arg1) {
        return (A)withInstalledCSV(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildInstallplan instead.
 * @return The buildable object.
 */
@Deprecated public InstallPlanReference getInstallplan() {
        return this.installplan!=null?this.installplan.build():null;
    }

    public InstallPlanReference buildInstallplan() {
        return this.installplan!=null?this.installplan.build():null;
    }

    public A withInstallplan(InstallPlanReference installplan) {
        _visitables.get("installplan").remove(this.installplan);
        if (installplan!=null){ this.installplan= new InstallPlanReferenceBuilder(installplan); _visitables.get("installplan").add(this.installplan);} return (A) this;
    }

    public Boolean hasInstallplan() {
        return this.installplan != null;
    }

    public A withNewInstallplan(String apiVersion,String kind,String name,String uuid) {
        return (A)withInstallplan(new InstallPlanReference(apiVersion, kind, name, uuid));
    }

    public SubscriptionStatusFluent.InstallplanNested<A> withNewInstallplan() {
        return new InstallplanNestedImpl();
    }

    public SubscriptionStatusFluent.InstallplanNested<A> withNewInstallplanLike(InstallPlanReference item) {
        return new InstallplanNestedImpl(item);
    }

    public SubscriptionStatusFluent.InstallplanNested<A> editInstallplan() {
        return withNewInstallplanLike(getInstallplan());
    }

    public SubscriptionStatusFluent.InstallplanNested<A> editOrNewInstallplan() {
        return withNewInstallplanLike(getInstallplan() != null ? getInstallplan(): new InstallPlanReferenceBuilder().build());
    }

    public SubscriptionStatusFluent.InstallplanNested<A> editOrNewInstallplanLike(InstallPlanReference item) {
        return withNewInstallplanLike(getInstallplan() != null ? getInstallplan(): item);
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated=lastUpdated; return (A) this;
    }

    public Boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    public A withNewLastUpdated(StringBuilder arg1) {
        return (A)withLastUpdated(new String(arg1));
    }

    public A withNewLastUpdated(int[] arg1,int arg2,int arg3) {
        return (A)withLastUpdated(new String(arg1, arg2, arg3));
    }

    public A withNewLastUpdated(char[] arg1) {
        return (A)withLastUpdated(new String(arg1));
    }

    public A withNewLastUpdated(StringBuffer arg1) {
        return (A)withLastUpdated(new String(arg1));
    }

    public A withNewLastUpdated(byte[] arg1,int arg2) {
        return (A)withLastUpdated(new String(arg1, arg2));
    }

    public A withNewLastUpdated(byte[] arg1) {
        return (A)withLastUpdated(new String(arg1));
    }

    public A withNewLastUpdated(char[] arg1,int arg2,int arg3) {
        return (A)withLastUpdated(new String(arg1, arg2, arg3));
    }

    public A withNewLastUpdated(byte[] arg1,int arg2,int arg3) {
        return (A)withLastUpdated(new String(arg1, arg2, arg3));
    }

    public A withNewLastUpdated(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLastUpdated(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLastUpdated(String arg1) {
        return (A)withLastUpdated(new String(arg1));
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason=reason; return (A) this;
    }

    public Boolean hasReason() {
        return this.reason != null;
    }

    public A withNewReason(StringBuilder arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(int[] arg1,int arg2,int arg3) {
        return (A)withReason(new String(arg1, arg2, arg3));
    }

    public A withNewReason(char[] arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(byte[] arg1,int arg2) {
        return (A)withReason(new String(arg1, arg2));
    }

    public A withNewReason(byte[] arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(char[] arg1,int arg2,int arg3) {
        return (A)withReason(new String(arg1, arg2, arg3));
    }

    public A withNewReason(byte[] arg1,int arg2,int arg3) {
        return (A)withReason(new String(arg1, arg2, arg3));
    }

    public A withNewReason(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withReason(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewReason(String arg1) {
        return (A)withReason(new String(arg1));
    }

    public String getState() {
        return this.state;
    }

    public A withState(String state) {
        this.state=state; return (A) this;
    }

    public Boolean hasState() {
        return this.state != null;
    }

    public A withNewState(StringBuilder arg1) {
        return (A)withState(new String(arg1));
    }

    public A withNewState(int[] arg1,int arg2,int arg3) {
        return (A)withState(new String(arg1, arg2, arg3));
    }

    public A withNewState(char[] arg1) {
        return (A)withState(new String(arg1));
    }

    public A withNewState(StringBuffer arg1) {
        return (A)withState(new String(arg1));
    }

    public A withNewState(byte[] arg1,int arg2) {
        return (A)withState(new String(arg1, arg2));
    }

    public A withNewState(byte[] arg1) {
        return (A)withState(new String(arg1));
    }

    public A withNewState(char[] arg1,int arg2,int arg3) {
        return (A)withState(new String(arg1, arg2, arg3));
    }

    public A withNewState(byte[] arg1,int arg2,int arg3) {
        return (A)withState(new String(arg1, arg2, arg3));
    }

    public A withNewState(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withState(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewState(String arg1) {
        return (A)withState(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubscriptionStatusFluentImpl that = (SubscriptionStatusFluentImpl) o;
        if (catalogHealth != null ? !catalogHealth.equals(that.catalogHealth) :that.catalogHealth != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (currentCSV != null ? !currentCSV.equals(that.currentCSV) :that.currentCSV != null) return false;
        if (installPlanGeneration != null ? !installPlanGeneration.equals(that.installPlanGeneration) :that.installPlanGeneration != null) return false;
        if (installPlanRef != null ? !installPlanRef.equals(that.installPlanRef) :that.installPlanRef != null) return false;
        if (installedCSV != null ? !installedCSV.equals(that.installedCSV) :that.installedCSV != null) return false;
        if (installplan != null ? !installplan.equals(that.installplan) :that.installplan != null) return false;
        if (lastUpdated != null ? !lastUpdated.equals(that.lastUpdated) :that.lastUpdated != null) return false;
        if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
        if (state != null ? !state.equals(that.state) :that.state != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(catalogHealth,  conditions,  currentCSV,  installPlanGeneration,  installPlanRef,  installedCSV,  installplan,  lastUpdated,  reason,  state,  super.hashCode());
    }

    public class CatalogHealthNestedImpl<N> extends SubscriptionCatalogHealthFluentImpl<SubscriptionStatusFluent.CatalogHealthNested<N>> implements SubscriptionStatusFluent.CatalogHealthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SubscriptionCatalogHealthBuilder builder;
        private final int index;

            CatalogHealthNestedImpl(int index,SubscriptionCatalogHealth item) {
                this.index = index;
                this.builder = new SubscriptionCatalogHealthBuilder(this, item);
                        
            }

            CatalogHealthNestedImpl() {
                this.index = -1;
                this.builder = new SubscriptionCatalogHealthBuilder(this);
                        
            }

            public N and() {
                return (N) SubscriptionStatusFluentImpl.this.setToCatalogHealth(index,builder.build());
            }

            public N endCatalogHealth() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends SubscriptionConditionFluentImpl<SubscriptionStatusFluent.ConditionsNested<N>> implements SubscriptionStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SubscriptionConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,SubscriptionCondition item) {
                this.index = index;
                this.builder = new SubscriptionConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new SubscriptionConditionBuilder(this);
                        
            }

            public N and() {
                return (N) SubscriptionStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class InstallPlanRefNestedImpl<N> extends ObjectReferenceFluentImpl<SubscriptionStatusFluent.InstallPlanRefNested<N>> implements SubscriptionStatusFluent.InstallPlanRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectReferenceBuilder builder;

            InstallPlanRefNestedImpl(ObjectReference item) {
                this.builder = new ObjectReferenceBuilder(this, item);
                        
            }

            InstallPlanRefNestedImpl() {
                this.builder = new ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) SubscriptionStatusFluentImpl.this.withInstallPlanRef(builder.build());
            }

            public N endInstallPlanRef() {
                return and();
            }
    }


    public class InstallplanNestedImpl<N> extends InstallPlanReferenceFluentImpl<SubscriptionStatusFluent.InstallplanNested<N>> implements SubscriptionStatusFluent.InstallplanNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InstallPlanReferenceBuilder builder;

            InstallplanNestedImpl(InstallPlanReference item) {
                this.builder = new InstallPlanReferenceBuilder(this, item);
                        
            }

            InstallplanNestedImpl() {
                this.builder = new InstallPlanReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) SubscriptionStatusFluentImpl.this.withInstallplan(builder.build());
            }

            public N endInstallplan() {
                return and();
            }
    }


}
