package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriptionSpecFluentImpl<A extends SubscriptionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscriptionSpecFluent<A> {

    private String channel;
    private SubscriptionConfigBuilder config;
    private String installPlanApproval;
    private String name;
    private String source;
    private String sourceNamespace;
    private String startingCSV;

    public SubscriptionSpecFluentImpl() {
    }

    public SubscriptionSpecFluentImpl(SubscriptionSpec instance) {
        this.withChannel(instance.getChannel()); 
        this.withConfig(instance.getConfig()); 
        this.withInstallPlanApproval(instance.getInstallPlanApproval()); 
        this.withName(instance.getName()); 
        this.withSource(instance.getSource()); 
        this.withSourceNamespace(instance.getSourceNamespace()); 
        this.withStartingCSV(instance.getStartingCSV()); 
    }

    public String getChannel() {
        return this.channel;
    }

    public A withChannel(String channel) {
        this.channel=channel; return (A) this;
    }

    public Boolean hasChannel() {
        return this.channel != null;
    }

    public A withNewChannel(StringBuilder arg1) {
        return (A)withChannel(new String(arg1));
    }

    public A withNewChannel(int[] arg1,int arg2,int arg3) {
        return (A)withChannel(new String(arg1, arg2, arg3));
    }

    public A withNewChannel(char[] arg1) {
        return (A)withChannel(new String(arg1));
    }

    public A withNewChannel(StringBuffer arg1) {
        return (A)withChannel(new String(arg1));
    }

    public A withNewChannel(byte[] arg1,int arg2) {
        return (A)withChannel(new String(arg1, arg2));
    }

    public A withNewChannel(byte[] arg1) {
        return (A)withChannel(new String(arg1));
    }

    public A withNewChannel(char[] arg1,int arg2,int arg3) {
        return (A)withChannel(new String(arg1, arg2, arg3));
    }

    public A withNewChannel(byte[] arg1,int arg2,int arg3) {
        return (A)withChannel(new String(arg1, arg2, arg3));
    }

    public A withNewChannel(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withChannel(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewChannel(String arg1) {
        return (A)withChannel(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildConfig instead.
 * @return The buildable object.
 */
@Deprecated public SubscriptionConfig getConfig() {
        return this.config!=null?this.config.build():null;
    }

    public SubscriptionConfig buildConfig() {
        return this.config!=null?this.config.build():null;
    }

    public A withConfig(SubscriptionConfig config) {
        _visitables.get("config").remove(this.config);
        if (config!=null){ this.config= new SubscriptionConfigBuilder(config); _visitables.get("config").add(this.config);} return (A) this;
    }

    public Boolean hasConfig() {
        return this.config != null;
    }

    public SubscriptionSpecFluent.ConfigNested<A> withNewConfig() {
        return new ConfigNestedImpl();
    }

    public SubscriptionSpecFluent.ConfigNested<A> withNewConfigLike(SubscriptionConfig item) {
        return new ConfigNestedImpl(item);
    }

    public SubscriptionSpecFluent.ConfigNested<A> editConfig() {
        return withNewConfigLike(getConfig());
    }

    public SubscriptionSpecFluent.ConfigNested<A> editOrNewConfig() {
        return withNewConfigLike(getConfig() != null ? getConfig(): new SubscriptionConfigBuilder().build());
    }

    public SubscriptionSpecFluent.ConfigNested<A> editOrNewConfigLike(SubscriptionConfig item) {
        return withNewConfigLike(getConfig() != null ? getConfig(): item);
    }

    public String getInstallPlanApproval() {
        return this.installPlanApproval;
    }

    public A withInstallPlanApproval(String installPlanApproval) {
        this.installPlanApproval=installPlanApproval; return (A) this;
    }

    public Boolean hasInstallPlanApproval() {
        return this.installPlanApproval != null;
    }

    public A withNewInstallPlanApproval(StringBuilder arg1) {
        return (A)withInstallPlanApproval(new String(arg1));
    }

    public A withNewInstallPlanApproval(int[] arg1,int arg2,int arg3) {
        return (A)withInstallPlanApproval(new String(arg1, arg2, arg3));
    }

    public A withNewInstallPlanApproval(char[] arg1) {
        return (A)withInstallPlanApproval(new String(arg1));
    }

    public A withNewInstallPlanApproval(StringBuffer arg1) {
        return (A)withInstallPlanApproval(new String(arg1));
    }

    public A withNewInstallPlanApproval(byte[] arg1,int arg2) {
        return (A)withInstallPlanApproval(new String(arg1, arg2));
    }

    public A withNewInstallPlanApproval(byte[] arg1) {
        return (A)withInstallPlanApproval(new String(arg1));
    }

    public A withNewInstallPlanApproval(char[] arg1,int arg2,int arg3) {
        return (A)withInstallPlanApproval(new String(arg1, arg2, arg3));
    }

    public A withNewInstallPlanApproval(byte[] arg1,int arg2,int arg3) {
        return (A)withInstallPlanApproval(new String(arg1, arg2, arg3));
    }

    public A withNewInstallPlanApproval(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withInstallPlanApproval(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewInstallPlanApproval(String arg1) {
        return (A)withInstallPlanApproval(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source=source; return (A) this;
    }

    public Boolean hasSource() {
        return this.source != null;
    }

    public A withNewSource(StringBuilder arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(int[] arg1,int arg2,int arg3) {
        return (A)withSource(new String(arg1, arg2, arg3));
    }

    public A withNewSource(char[] arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuffer arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(byte[] arg1,int arg2) {
        return (A)withSource(new String(arg1, arg2));
    }

    public A withNewSource(byte[] arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(char[] arg1,int arg2,int arg3) {
        return (A)withSource(new String(arg1, arg2, arg3));
    }

    public A withNewSource(byte[] arg1,int arg2,int arg3) {
        return (A)withSource(new String(arg1, arg2, arg3));
    }

    public A withNewSource(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSource(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSource(String arg1) {
        return (A)withSource(new String(arg1));
    }

    public String getSourceNamespace() {
        return this.sourceNamespace;
    }

    public A withSourceNamespace(String sourceNamespace) {
        this.sourceNamespace=sourceNamespace; return (A) this;
    }

    public Boolean hasSourceNamespace() {
        return this.sourceNamespace != null;
    }

    public A withNewSourceNamespace(StringBuilder arg1) {
        return (A)withSourceNamespace(new String(arg1));
    }

    public A withNewSourceNamespace(int[] arg1,int arg2,int arg3) {
        return (A)withSourceNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewSourceNamespace(char[] arg1) {
        return (A)withSourceNamespace(new String(arg1));
    }

    public A withNewSourceNamespace(StringBuffer arg1) {
        return (A)withSourceNamespace(new String(arg1));
    }

    public A withNewSourceNamespace(byte[] arg1,int arg2) {
        return (A)withSourceNamespace(new String(arg1, arg2));
    }

    public A withNewSourceNamespace(byte[] arg1) {
        return (A)withSourceNamespace(new String(arg1));
    }

    public A withNewSourceNamespace(char[] arg1,int arg2,int arg3) {
        return (A)withSourceNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewSourceNamespace(byte[] arg1,int arg2,int arg3) {
        return (A)withSourceNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewSourceNamespace(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSourceNamespace(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSourceNamespace(String arg1) {
        return (A)withSourceNamespace(new String(arg1));
    }

    public String getStartingCSV() {
        return this.startingCSV;
    }

    public A withStartingCSV(String startingCSV) {
        this.startingCSV=startingCSV; return (A) this;
    }

    public Boolean hasStartingCSV() {
        return this.startingCSV != null;
    }

    public A withNewStartingCSV(StringBuilder arg1) {
        return (A)withStartingCSV(new String(arg1));
    }

    public A withNewStartingCSV(int[] arg1,int arg2,int arg3) {
        return (A)withStartingCSV(new String(arg1, arg2, arg3));
    }

    public A withNewStartingCSV(char[] arg1) {
        return (A)withStartingCSV(new String(arg1));
    }

    public A withNewStartingCSV(StringBuffer arg1) {
        return (A)withStartingCSV(new String(arg1));
    }

    public A withNewStartingCSV(byte[] arg1,int arg2) {
        return (A)withStartingCSV(new String(arg1, arg2));
    }

    public A withNewStartingCSV(byte[] arg1) {
        return (A)withStartingCSV(new String(arg1));
    }

    public A withNewStartingCSV(char[] arg1,int arg2,int arg3) {
        return (A)withStartingCSV(new String(arg1, arg2, arg3));
    }

    public A withNewStartingCSV(byte[] arg1,int arg2,int arg3) {
        return (A)withStartingCSV(new String(arg1, arg2, arg3));
    }

    public A withNewStartingCSV(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withStartingCSV(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewStartingCSV(String arg1) {
        return (A)withStartingCSV(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubscriptionSpecFluentImpl that = (SubscriptionSpecFluentImpl) o;
        if (channel != null ? !channel.equals(that.channel) :that.channel != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (installPlanApproval != null ? !installPlanApproval.equals(that.installPlanApproval) :that.installPlanApproval != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        if (sourceNamespace != null ? !sourceNamespace.equals(that.sourceNamespace) :that.sourceNamespace != null) return false;
        if (startingCSV != null ? !startingCSV.equals(that.startingCSV) :that.startingCSV != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(channel,  config,  installPlanApproval,  name,  source,  sourceNamespace,  startingCSV,  super.hashCode());
    }

    public class ConfigNestedImpl<N> extends SubscriptionConfigFluentImpl<SubscriptionSpecFluent.ConfigNested<N>> implements SubscriptionSpecFluent.ConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SubscriptionConfigBuilder builder;

            ConfigNestedImpl(SubscriptionConfig item) {
                this.builder = new SubscriptionConfigBuilder(this, item);
                        
            }

            ConfigNestedImpl() {
                this.builder = new SubscriptionConfigBuilder(this);
                        
            }

            public N and() {
                return (N) SubscriptionSpecFluentImpl.this.withConfig(builder.build());
            }

            public N endConfig() {
                return and();
            }
    }


}
