package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

public class BundleLookupFluentImpl<A extends BundleLookupFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BundleLookupFluent<A> {

    private ObjectReferenceBuilder catalogSourceRef;
    private List<BundleLookupConditionBuilder> conditions =  new ArrayList<BundleLookupConditionBuilder>();
    private String identifier;
    private String path;
    private String replaces;

    public BundleLookupFluentImpl() {
    }

    public BundleLookupFluentImpl(BundleLookup instance) {
        this.withCatalogSourceRef(instance.getCatalogSourceRef()); 
        this.withConditions(instance.getConditions()); 
        this.withIdentifier(instance.getIdentifier()); 
        this.withPath(instance.getPath()); 
        this.withReplaces(instance.getReplaces()); 
    }

    
/**
 * This method has been deprecated, please use method buildCatalogSourceRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getCatalogSourceRef() {
        return this.catalogSourceRef!=null?this.catalogSourceRef.build():null;
    }

    public ObjectReference buildCatalogSourceRef() {
        return this.catalogSourceRef!=null?this.catalogSourceRef.build():null;
    }

    public A withCatalogSourceRef(ObjectReference catalogSourceRef) {
        _visitables.get("catalogSourceRef").remove(this.catalogSourceRef);
        if (catalogSourceRef!=null){ this.catalogSourceRef= new ObjectReferenceBuilder(catalogSourceRef); _visitables.get("catalogSourceRef").add(this.catalogSourceRef);} return (A) this;
    }

    public Boolean hasCatalogSourceRef() {
        return this.catalogSourceRef != null;
    }

    public BundleLookupFluent.CatalogSourceRefNested<A> withNewCatalogSourceRef() {
        return new CatalogSourceRefNestedImpl();
    }

    public BundleLookupFluent.CatalogSourceRefNested<A> withNewCatalogSourceRefLike(ObjectReference item) {
        return new CatalogSourceRefNestedImpl(item);
    }

    public BundleLookupFluent.CatalogSourceRefNested<A> editCatalogSourceRef() {
        return withNewCatalogSourceRefLike(getCatalogSourceRef());
    }

    public BundleLookupFluent.CatalogSourceRefNested<A> editOrNewCatalogSourceRef() {
        return withNewCatalogSourceRefLike(getCatalogSourceRef() != null ? getCatalogSourceRef(): new ObjectReferenceBuilder().build());
    }

    public BundleLookupFluent.CatalogSourceRefNested<A> editOrNewCatalogSourceRefLike(ObjectReference item) {
        return withNewCatalogSourceRefLike(getCatalogSourceRef() != null ? getCatalogSourceRef(): item);
    }

    public A addToConditions(int index,BundleLookupCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<BundleLookupConditionBuilder>();}
        BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,BundleLookupCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<BundleLookupConditionBuilder>();}
        BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(BundleLookupCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<BundleLookupConditionBuilder>();}
        for (BundleLookupCondition item : items) {BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<BundleLookupCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<BundleLookupConditionBuilder>();}
        for (BundleLookupCondition item : items) {BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(BundleLookupCondition... items) {
        for (BundleLookupCondition item : items) {BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<BundleLookupCondition> items) {
        for (BundleLookupCondition item : items) {BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<BundleLookupConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<BundleLookupConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          BundleLookupConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<BundleLookupCondition> getConditions() {
        return build(conditions);
    }

    public List<BundleLookupCondition> buildConditions() {
        return build(conditions);
    }

    public BundleLookupCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public BundleLookupCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public BundleLookupCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public BundleLookupCondition buildMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
        for (BundleLookupConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
        for (BundleLookupConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<BundleLookupCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<BundleLookupConditionBuilder>(); for (BundleLookupCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(BundleLookupCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (BundleLookupCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public BundleLookupFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public BundleLookupFluent.ConditionsNested<A> addNewConditionLike(BundleLookupCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public BundleLookupFluent.ConditionsNested<A> setNewConditionLike(int index,BundleLookupCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public BundleLookupFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public BundleLookupFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public BundleLookupFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public BundleLookupFluent.ConditionsNested<A> editMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public A withIdentifier(String identifier) {
        this.identifier=identifier; return (A) this;
    }

    public Boolean hasIdentifier() {
        return this.identifier != null;
    }

    public A withNewIdentifier(StringBuilder arg1) {
        return (A)withIdentifier(new String(arg1));
    }

    public A withNewIdentifier(int[] arg1,int arg2,int arg3) {
        return (A)withIdentifier(new String(arg1, arg2, arg3));
    }

    public A withNewIdentifier(char[] arg1) {
        return (A)withIdentifier(new String(arg1));
    }

    public A withNewIdentifier(StringBuffer arg1) {
        return (A)withIdentifier(new String(arg1));
    }

    public A withNewIdentifier(byte[] arg1,int arg2) {
        return (A)withIdentifier(new String(arg1, arg2));
    }

    public A withNewIdentifier(byte[] arg1) {
        return (A)withIdentifier(new String(arg1));
    }

    public A withNewIdentifier(char[] arg1,int arg2,int arg3) {
        return (A)withIdentifier(new String(arg1, arg2, arg3));
    }

    public A withNewIdentifier(byte[] arg1,int arg2,int arg3) {
        return (A)withIdentifier(new String(arg1, arg2, arg3));
    }

    public A withNewIdentifier(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withIdentifier(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewIdentifier(String arg1) {
        return (A)withIdentifier(new String(arg1));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(int[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(char[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(byte[] arg1,int arg2) {
        return (A)withPath(new String(arg1, arg2));
    }

    public A withNewPath(byte[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(char[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public String getReplaces() {
        return this.replaces;
    }

    public A withReplaces(String replaces) {
        this.replaces=replaces; return (A) this;
    }

    public Boolean hasReplaces() {
        return this.replaces != null;
    }

    public A withNewReplaces(StringBuilder arg1) {
        return (A)withReplaces(new String(arg1));
    }

    public A withNewReplaces(int[] arg1,int arg2,int arg3) {
        return (A)withReplaces(new String(arg1, arg2, arg3));
    }

    public A withNewReplaces(char[] arg1) {
        return (A)withReplaces(new String(arg1));
    }

    public A withNewReplaces(StringBuffer arg1) {
        return (A)withReplaces(new String(arg1));
    }

    public A withNewReplaces(byte[] arg1,int arg2) {
        return (A)withReplaces(new String(arg1, arg2));
    }

    public A withNewReplaces(byte[] arg1) {
        return (A)withReplaces(new String(arg1));
    }

    public A withNewReplaces(char[] arg1,int arg2,int arg3) {
        return (A)withReplaces(new String(arg1, arg2, arg3));
    }

    public A withNewReplaces(byte[] arg1,int arg2,int arg3) {
        return (A)withReplaces(new String(arg1, arg2, arg3));
    }

    public A withNewReplaces(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withReplaces(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewReplaces(String arg1) {
        return (A)withReplaces(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BundleLookupFluentImpl that = (BundleLookupFluentImpl) o;
        if (catalogSourceRef != null ? !catalogSourceRef.equals(that.catalogSourceRef) :that.catalogSourceRef != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (identifier != null ? !identifier.equals(that.identifier) :that.identifier != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (replaces != null ? !replaces.equals(that.replaces) :that.replaces != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(catalogSourceRef,  conditions,  identifier,  path,  replaces,  super.hashCode());
    }

    public class CatalogSourceRefNestedImpl<N> extends ObjectReferenceFluentImpl<BundleLookupFluent.CatalogSourceRefNested<N>> implements BundleLookupFluent.CatalogSourceRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectReferenceBuilder builder;

            CatalogSourceRefNestedImpl(ObjectReference item) {
                this.builder = new ObjectReferenceBuilder(this, item);
                        
            }

            CatalogSourceRefNestedImpl() {
                this.builder = new ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) BundleLookupFluentImpl.this.withCatalogSourceRef(builder.build());
            }

            public N endCatalogSourceRef() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends BundleLookupConditionFluentImpl<BundleLookupFluent.ConditionsNested<N>> implements BundleLookupFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BundleLookupConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,BundleLookupCondition item) {
                this.index = index;
                this.builder = new BundleLookupConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new BundleLookupConditionBuilder(this);
                        
            }

            public N and() {
                return (N) BundleLookupFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


}
