package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SpecDescriptorFluentImpl<A extends SpecDescriptorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SpecDescriptorFluent<A> {

    private String description;
    private String displayName;
    private String path;
    private String value;
    private List<String> xDescriptors = new ArrayList<String>();

    public SpecDescriptorFluentImpl() {
    }

    public SpecDescriptorFluentImpl(SpecDescriptor instance) {
        this.withDescription(instance.getDescription()); 
        this.withDisplayName(instance.getDisplayName()); 
        this.withPath(instance.getPath()); 
        this.withValue(instance.getValue()); 
        this.withXDescriptors(instance.getXDescriptors()); 
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description=description; return (A) this;
    }

    public Boolean hasDescription() {
        return this.description != null;
    }

    public A withNewDescription(String arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuilder arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1) {
        return (A)withDescription(new String(arg1));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName=displayName; return (A) this;
    }

    public Boolean hasDisplayName() {
        return this.displayName != null;
    }

    public A withNewDisplayName(String arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(StringBuilder arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(StringBuffer arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuilder arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1) {
        return (A)withValue(new String(arg1));
    }

    public A addToXDescriptors(int index,String item) {
        if (this.xDescriptors == null) {this.xDescriptors = new ArrayList<String>();}
        this.xDescriptors.add(index, item);
        return (A)this;
    }

    public A setToXDescriptors(int index,String item) {
        if (this.xDescriptors == null) {this.xDescriptors = new ArrayList<String>();}
        this.xDescriptors.set(index, item); return (A)this;
    }

    public A addToXDescriptors(String... items) {
        if (this.xDescriptors == null) {this.xDescriptors = new ArrayList<String>();}
        for (String item : items) {this.xDescriptors.add(item);} return (A)this;
    }

    public A addAllToXDescriptors(Collection<String> items) {
        if (this.xDescriptors == null) {this.xDescriptors = new ArrayList<String>();}
        for (String item : items) {this.xDescriptors.add(item);} return (A)this;
    }

    public A removeFromXDescriptors(String... items) {
        for (String item : items) {if (this.xDescriptors!= null){ this.xDescriptors.remove(item);}} return (A)this;
    }

    public A removeAllFromXDescriptors(Collection<String> items) {
        for (String item : items) {if (this.xDescriptors!= null){ this.xDescriptors.remove(item);}} return (A)this;
    }

    public List<String> getXDescriptors() {
        return this.xDescriptors;
    }

    public String getXDescriptor(int index) {
        return this.xDescriptors.get(index);
    }

    public String getFirstXDescriptor() {
        return this.xDescriptors.get(0);
    }

    public String getLastXDescriptor() {
        return this.xDescriptors.get(xDescriptors.size() - 1);
    }

    public String getMatchingXDescriptor(Predicate<String> predicate) {
        for (String item: xDescriptors) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingXDescriptor(Predicate<String> predicate) {
        for (String item: xDescriptors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withXDescriptors(List<String> xDescriptors) {
        if (this.xDescriptors != null) { _visitables.get("xDescriptors").removeAll(this.xDescriptors);}
        if (xDescriptors != null) {this.xDescriptors = new ArrayList<String>(); for (String item : xDescriptors){this.addToXDescriptors(item);}} else { this.xDescriptors = null;} return (A) this;
    }

    public A withXDescriptors(String... xDescriptors) {
        if (this.xDescriptors != null) {this.xDescriptors.clear();}
        if (xDescriptors != null) {for (String item :xDescriptors){ this.addToXDescriptors(item);}} return (A) this;
    }

    public Boolean hasXDescriptors() {
        return xDescriptors != null && !xDescriptors.isEmpty();
    }

    public A addNewXDescriptor(String arg1) {
        return (A)addToXDescriptors(new String(arg1));
    }

    public A addNewXDescriptor(StringBuilder arg1) {
        return (A)addToXDescriptors(new String(arg1));
    }

    public A addNewXDescriptor(StringBuffer arg1) {
        return (A)addToXDescriptors(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SpecDescriptorFluentImpl that = (SpecDescriptorFluentImpl) o;
        if (description != null ? !description.equals(that.description) :that.description != null) return false;
        if (displayName != null ? !displayName.equals(that.displayName) :that.displayName != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        if (xDescriptors != null ? !xDescriptors.equals(that.xDescriptors) :that.xDescriptors != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(description,  displayName,  path,  value,  xDescriptors,  super.hashCode());
    }

}
