package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class IconFluentImpl<A extends IconFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IconFluent<A> {

    private String base64data;
    private String mediatype;

    public IconFluentImpl() {
    }

    public IconFluentImpl(Icon instance) {
        this.withBase64data(instance.getBase64data()); 
        this.withMediatype(instance.getMediatype()); 
    }

    public String getBase64data() {
        return this.base64data;
    }

    public A withBase64data(String base64data) {
        this.base64data=base64data; return (A) this;
    }

    public Boolean hasBase64data() {
        return this.base64data != null;
    }

    public A withNewBase64data(String arg1) {
        return (A)withBase64data(new String(arg1));
    }

    public A withNewBase64data(StringBuilder arg1) {
        return (A)withBase64data(new String(arg1));
    }

    public A withNewBase64data(StringBuffer arg1) {
        return (A)withBase64data(new String(arg1));
    }

    public String getMediatype() {
        return this.mediatype;
    }

    public A withMediatype(String mediatype) {
        this.mediatype=mediatype; return (A) this;
    }

    public Boolean hasMediatype() {
        return this.mediatype != null;
    }

    public A withNewMediatype(String arg1) {
        return (A)withMediatype(new String(arg1));
    }

    public A withNewMediatype(StringBuilder arg1) {
        return (A)withMediatype(new String(arg1));
    }

    public A withNewMediatype(StringBuffer arg1) {
        return (A)withMediatype(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IconFluentImpl that = (IconFluentImpl) o;
        if (base64data != null ? !base64data.equals(that.base64data) :that.base64data != null) return false;
        if (mediatype != null ? !mediatype.equals(that.mediatype) :that.mediatype != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(base64data,  mediatype,  super.hashCode());
    }

}
