package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CatalogSourceStatusBuilder extends CatalogSourceStatusFluentImpl<CatalogSourceStatusBuilder> implements VisitableBuilder<CatalogSourceStatus,CatalogSourceStatusBuilder> {

    CatalogSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public CatalogSourceStatusBuilder() {
        this(true);
    }

    public CatalogSourceStatusBuilder(Boolean validationEnabled) {
        this(new CatalogSourceStatus(), validationEnabled);
    }

    public CatalogSourceStatusBuilder(CatalogSourceStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public CatalogSourceStatusBuilder(CatalogSourceStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CatalogSourceStatus(), validationEnabled);
    }

    public CatalogSourceStatusBuilder(CatalogSourceStatusFluent<?> fluent,CatalogSourceStatus instance) {
        this(fluent, instance, true);
    }

    public CatalogSourceStatusBuilder(CatalogSourceStatusFluent<?> fluent,CatalogSourceStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfigMapReference(instance.getConfigMapReference()); 
        fluent.withConnectionState(instance.getConnectionState()); 
        fluent.withLatestImageRegistryPoll(instance.getLatestImageRegistryPoll()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withRegistryService(instance.getRegistryService()); 
        this.validationEnabled = validationEnabled; 
    }

    public CatalogSourceStatusBuilder(CatalogSourceStatus instance) {
        this(instance,true);
    }

    public CatalogSourceStatusBuilder(CatalogSourceStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfigMapReference(instance.getConfigMapReference()); 
        this.withConnectionState(instance.getConnectionState()); 
        this.withLatestImageRegistryPoll(instance.getLatestImageRegistryPoll()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withRegistryService(instance.getRegistryService()); 
        this.validationEnabled = validationEnabled; 
    }

    public CatalogSourceStatus build() {
        CatalogSourceStatus buildable = new CatalogSourceStatus(fluent.getConfigMapReference(),fluent.getConnectionState(),fluent.getLatestImageRegistryPoll(),fluent.getMessage(),fluent.getReason(),fluent.getRegistryService());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CatalogSourceStatusBuilder that = (CatalogSourceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
