package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class UpdateStrategyBuilder extends UpdateStrategyFluentImpl<UpdateStrategyBuilder> implements VisitableBuilder<UpdateStrategy,UpdateStrategyBuilder> {

    UpdateStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public UpdateStrategyBuilder() {
        this(true);
    }

    public UpdateStrategyBuilder(Boolean validationEnabled) {
        this(new UpdateStrategy(), validationEnabled);
    }

    public UpdateStrategyBuilder(UpdateStrategyFluent<?> fluent) {
        this(fluent, true);
    }

    public UpdateStrategyBuilder(UpdateStrategyFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new UpdateStrategy(), validationEnabled);
    }

    public UpdateStrategyBuilder(UpdateStrategyFluent<?> fluent,UpdateStrategy instance) {
        this(fluent, instance, true);
    }

    public UpdateStrategyBuilder(UpdateStrategyFluent<?> fluent,UpdateStrategy instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withRegistryPoll(instance.getRegistryPoll()); 
        this.validationEnabled = validationEnabled; 
    }

    public UpdateStrategyBuilder(UpdateStrategy instance) {
        this(instance,true);
    }

    public UpdateStrategyBuilder(UpdateStrategy instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withRegistryPoll(instance.getRegistryPoll()); 
        this.validationEnabled = validationEnabled; 
    }

    public UpdateStrategy build() {
        UpdateStrategy buildable = new UpdateStrategy(fluent.getRegistryPoll());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        UpdateStrategyBuilder that = (UpdateStrategyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
