package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class APIServiceDefinitionsFluentImpl<A extends APIServiceDefinitionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIServiceDefinitionsFluent<A> {

    private List<APIServiceDescriptionBuilder> owned =  new ArrayList<APIServiceDescriptionBuilder>();
    private List<APIServiceDescriptionBuilder> required =  new ArrayList<APIServiceDescriptionBuilder>();

    public APIServiceDefinitionsFluentImpl() {
    }

    public APIServiceDefinitionsFluentImpl(APIServiceDefinitions instance) {
        this.withOwned(instance.getOwned()); 
        this.withRequired(instance.getRequired()); 
    }

    public A addToOwned(int index,APIServiceDescription item) {
        if (this.owned == null) {this.owned = new ArrayList<APIServiceDescriptionBuilder>();}
        APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);_visitables.get("owned").add(index >= 0 ? index : _visitables.get("owned").size(), builder);this.owned.add(index >= 0 ? index : owned.size(), builder); return (A)this;
    }

    public A setToOwned(int index,APIServiceDescription item) {
        if (this.owned == null) {this.owned = new ArrayList<APIServiceDescriptionBuilder>();}
        APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);
        if (index < 0 || index >= _visitables.get("owned").size()) { _visitables.get("owned").add(builder); } else { _visitables.get("owned").set(index, builder);}
        if (index < 0 || index >= owned.size()) { owned.add(builder); } else { owned.set(index, builder);}
         return (A)this;
    }

    public A addToOwned(APIServiceDescription... items) {
        if (this.owned == null) {this.owned = new ArrayList<APIServiceDescriptionBuilder>();}
        for (APIServiceDescription item : items) {APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);_visitables.get("owned").add(builder);this.owned.add(builder);} return (A)this;
    }

    public A addAllToOwned(Collection<APIServiceDescription> items) {
        if (this.owned == null) {this.owned = new ArrayList<APIServiceDescriptionBuilder>();}
        for (APIServiceDescription item : items) {APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);_visitables.get("owned").add(builder);this.owned.add(builder);} return (A)this;
    }

    public A removeFromOwned(APIServiceDescription... items) {
        for (APIServiceDescription item : items) {APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);_visitables.get("owned").remove(builder);if (this.owned != null) {this.owned.remove(builder);}} return (A)this;
    }

    public A removeAllFromOwned(Collection<APIServiceDescription> items) {
        for (APIServiceDescription item : items) {APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);_visitables.get("owned").remove(builder);if (this.owned != null) {this.owned.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOwned(Predicate<APIServiceDescriptionBuilder> predicate) {
        if (owned == null) return (A) this;
        final Iterator<APIServiceDescriptionBuilder> each = owned.iterator();
        final List visitables = _visitables.get("owned");
        while (each.hasNext()) {
          APIServiceDescriptionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOwned instead.
 * @return The buildable object.
 */
@Deprecated public List<APIServiceDescription> getOwned() {
        return build(owned);
    }

    public List<APIServiceDescription> buildOwned() {
        return build(owned);
    }

    public APIServiceDescription buildOwned(int index) {
        return this.owned.get(index).build();
    }

    public APIServiceDescription buildFirstOwned() {
        return this.owned.get(0).build();
    }

    public APIServiceDescription buildLastOwned() {
        return this.owned.get(owned.size() - 1).build();
    }

    public APIServiceDescription buildMatchingOwned(Predicate<APIServiceDescriptionBuilder> predicate) {
        for (APIServiceDescriptionBuilder item: owned) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingOwned(Predicate<APIServiceDescriptionBuilder> predicate) {
        for (APIServiceDescriptionBuilder item: owned) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withOwned(List<APIServiceDescription> owned) {
        if (this.owned != null) { _visitables.get("owned").removeAll(this.owned);}
        if (owned != null) {this.owned = new ArrayList<APIServiceDescriptionBuilder>(); for (APIServiceDescription item : owned){this.addToOwned(item);}} else { this.owned = null;} return (A) this;
    }

    public A withOwned(APIServiceDescription... owned) {
        if (this.owned != null) {this.owned.clear();}
        if (owned != null) {for (APIServiceDescription item :owned){ this.addToOwned(item);}} return (A) this;
    }

    public Boolean hasOwned() {
        return owned != null && !owned.isEmpty();
    }

    public APIServiceDefinitionsFluent.OwnedNested<A> addNewOwned() {
        return new OwnedNestedImpl();
    }

    public APIServiceDefinitionsFluent.OwnedNested<A> addNewOwnedLike(APIServiceDescription item) {
        return new OwnedNestedImpl(-1, item);
    }

    public APIServiceDefinitionsFluent.OwnedNested<A> setNewOwnedLike(int index,APIServiceDescription item) {
        return new OwnedNestedImpl(index, item);
    }

    public APIServiceDefinitionsFluent.OwnedNested<A> editOwned(int index) {
        if (owned.size() <= index) throw new RuntimeException("Can't edit owned. Index exceeds size.");
        return setNewOwnedLike(index, buildOwned(index));
    }

    public APIServiceDefinitionsFluent.OwnedNested<A> editFirstOwned() {
        if (owned.size() == 0) throw new RuntimeException("Can't edit first owned. The list is empty.");
        return setNewOwnedLike(0, buildOwned(0));
    }

    public APIServiceDefinitionsFluent.OwnedNested<A> editLastOwned() {
        int index = owned.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last owned. The list is empty.");
        return setNewOwnedLike(index, buildOwned(index));
    }

    public APIServiceDefinitionsFluent.OwnedNested<A> editMatchingOwned(Predicate<APIServiceDescriptionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<owned.size();i++) { 
        if (predicate.test(owned.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching owned. No match found.");
        return setNewOwnedLike(index, buildOwned(index));
    }

    public A addToRequired(int index,APIServiceDescription item) {
        if (this.required == null) {this.required = new ArrayList<APIServiceDescriptionBuilder>();}
        APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);_visitables.get("required").add(index >= 0 ? index : _visitables.get("required").size(), builder);this.required.add(index >= 0 ? index : required.size(), builder); return (A)this;
    }

    public A setToRequired(int index,APIServiceDescription item) {
        if (this.required == null) {this.required = new ArrayList<APIServiceDescriptionBuilder>();}
        APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);
        if (index < 0 || index >= _visitables.get("required").size()) { _visitables.get("required").add(builder); } else { _visitables.get("required").set(index, builder);}
        if (index < 0 || index >= required.size()) { required.add(builder); } else { required.set(index, builder);}
         return (A)this;
    }

    public A addToRequired(APIServiceDescription... items) {
        if (this.required == null) {this.required = new ArrayList<APIServiceDescriptionBuilder>();}
        for (APIServiceDescription item : items) {APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);_visitables.get("required").add(builder);this.required.add(builder);} return (A)this;
    }

    public A addAllToRequired(Collection<APIServiceDescription> items) {
        if (this.required == null) {this.required = new ArrayList<APIServiceDescriptionBuilder>();}
        for (APIServiceDescription item : items) {APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);_visitables.get("required").add(builder);this.required.add(builder);} return (A)this;
    }

    public A removeFromRequired(APIServiceDescription... items) {
        for (APIServiceDescription item : items) {APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);_visitables.get("required").remove(builder);if (this.required != null) {this.required.remove(builder);}} return (A)this;
    }

    public A removeAllFromRequired(Collection<APIServiceDescription> items) {
        for (APIServiceDescription item : items) {APIServiceDescriptionBuilder builder = new APIServiceDescriptionBuilder(item);_visitables.get("required").remove(builder);if (this.required != null) {this.required.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRequired(Predicate<APIServiceDescriptionBuilder> predicate) {
        if (required == null) return (A) this;
        final Iterator<APIServiceDescriptionBuilder> each = required.iterator();
        final List visitables = _visitables.get("required");
        while (each.hasNext()) {
          APIServiceDescriptionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRequired instead.
 * @return The buildable object.
 */
@Deprecated public List<APIServiceDescription> getRequired() {
        return build(required);
    }

    public List<APIServiceDescription> buildRequired() {
        return build(required);
    }

    public APIServiceDescription buildRequired(int index) {
        return this.required.get(index).build();
    }

    public APIServiceDescription buildFirstRequired() {
        return this.required.get(0).build();
    }

    public APIServiceDescription buildLastRequired() {
        return this.required.get(required.size() - 1).build();
    }

    public APIServiceDescription buildMatchingRequired(Predicate<APIServiceDescriptionBuilder> predicate) {
        for (APIServiceDescriptionBuilder item: required) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRequired(Predicate<APIServiceDescriptionBuilder> predicate) {
        for (APIServiceDescriptionBuilder item: required) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRequired(List<APIServiceDescription> required) {
        if (this.required != null) { _visitables.get("required").removeAll(this.required);}
        if (required != null) {this.required = new ArrayList<APIServiceDescriptionBuilder>(); for (APIServiceDescription item : required){this.addToRequired(item);}} else { this.required = null;} return (A) this;
    }

    public A withRequired(APIServiceDescription... required) {
        if (this.required != null) {this.required.clear();}
        if (required != null) {for (APIServiceDescription item :required){ this.addToRequired(item);}} return (A) this;
    }

    public Boolean hasRequired() {
        return required != null && !required.isEmpty();
    }

    public APIServiceDefinitionsFluent.RequiredNested<A> addNewRequired() {
        return new RequiredNestedImpl();
    }

    public APIServiceDefinitionsFluent.RequiredNested<A> addNewRequiredLike(APIServiceDescription item) {
        return new RequiredNestedImpl(-1, item);
    }

    public APIServiceDefinitionsFluent.RequiredNested<A> setNewRequiredLike(int index,APIServiceDescription item) {
        return new RequiredNestedImpl(index, item);
    }

    public APIServiceDefinitionsFluent.RequiredNested<A> editRequired(int index) {
        if (required.size() <= index) throw new RuntimeException("Can't edit required. Index exceeds size.");
        return setNewRequiredLike(index, buildRequired(index));
    }

    public APIServiceDefinitionsFluent.RequiredNested<A> editFirstRequired() {
        if (required.size() == 0) throw new RuntimeException("Can't edit first required. The list is empty.");
        return setNewRequiredLike(0, buildRequired(0));
    }

    public APIServiceDefinitionsFluent.RequiredNested<A> editLastRequired() {
        int index = required.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last required. The list is empty.");
        return setNewRequiredLike(index, buildRequired(index));
    }

    public APIServiceDefinitionsFluent.RequiredNested<A> editMatchingRequired(Predicate<APIServiceDescriptionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<required.size();i++) { 
        if (predicate.test(required.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching required. No match found.");
        return setNewRequiredLike(index, buildRequired(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIServiceDefinitionsFluentImpl that = (APIServiceDefinitionsFluentImpl) o;
        if (owned != null ? !owned.equals(that.owned) :that.owned != null) return false;
        if (required != null ? !required.equals(that.required) :that.required != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(owned,  required,  super.hashCode());
    }

    public class OwnedNestedImpl<N> extends APIServiceDescriptionFluentImpl<APIServiceDefinitionsFluent.OwnedNested<N>> implements APIServiceDefinitionsFluent.OwnedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceDescriptionBuilder builder;
        private final int index;

            OwnedNestedImpl(int index,APIServiceDescription item) {
                this.index = index;
                this.builder = new APIServiceDescriptionBuilder(this, item);
                        
            }

            OwnedNestedImpl() {
                this.index = -1;
                this.builder = new APIServiceDescriptionBuilder(this);
                        
            }

            public N and() {
                return (N) APIServiceDefinitionsFluentImpl.this.setToOwned(index,builder.build());
            }

            public N endOwned() {
                return and();
            }
    }


    public class RequiredNestedImpl<N> extends APIServiceDescriptionFluentImpl<APIServiceDefinitionsFluent.RequiredNested<N>> implements APIServiceDefinitionsFluent.RequiredNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceDescriptionBuilder builder;
        private final int index;

            RequiredNestedImpl(int index,APIServiceDescription item) {
                this.index = index;
                this.builder = new APIServiceDescriptionBuilder(this, item);
                        
            }

            RequiredNestedImpl() {
                this.index = -1;
                this.builder = new APIServiceDescriptionBuilder(this);
                        
            }

            public N and() {
                return (N) APIServiceDefinitionsFluentImpl.this.setToRequired(index,builder.build());
            }

            public N endRequired() {
                return and();
            }
    }


}
