package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterServiceVersionListFluent<A extends ClusterServiceVersionListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ClusterServiceVersion item);
    public A setToItems(int index,ClusterServiceVersion item);
    public A addToItems(ClusterServiceVersion... items);
    public A addAllToItems(Collection<ClusterServiceVersion> items);
    public A removeFromItems(ClusterServiceVersion... items);
    public A removeAllFromItems(Collection<ClusterServiceVersion> items);
    public A removeMatchingFromItems(Predicate<ClusterServiceVersionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterServiceVersion> getItems();
    public List<ClusterServiceVersion> buildItems();
    public ClusterServiceVersion buildItem(int index);
    public ClusterServiceVersion buildFirstItem();
    public ClusterServiceVersion buildLastItem();
    public ClusterServiceVersion buildMatchingItem(Predicate<ClusterServiceVersionBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ClusterServiceVersionBuilder> predicate);
    public A withItems(List<ClusterServiceVersion> items);
    public A withItems(ClusterServiceVersion... items);
    public Boolean hasItems();
    public ClusterServiceVersionListFluent.ItemsNested<A> addNewItem();
    public ClusterServiceVersionListFluent.ItemsNested<A> addNewItemLike(ClusterServiceVersion item);
    public ClusterServiceVersionListFluent.ItemsNested<A> setNewItemLike(int index,ClusterServiceVersion item);
    public ClusterServiceVersionListFluent.ItemsNested<A> editItem(int index);
    public ClusterServiceVersionListFluent.ItemsNested<A> editFirstItem();
    public ClusterServiceVersionListFluent.ItemsNested<A> editLastItem();
    public ClusterServiceVersionListFluent.ItemsNested<A> editMatchingItem(Predicate<ClusterServiceVersionBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterServiceVersionFluent<ClusterServiceVersionListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
