package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RequirementStatusBuilder extends RequirementStatusFluentImpl<RequirementStatusBuilder> implements VisitableBuilder<RequirementStatus,RequirementStatusBuilder> {

    RequirementStatusFluent<?> fluent;
    Boolean validationEnabled;

    public RequirementStatusBuilder() {
        this(true);
    }

    public RequirementStatusBuilder(Boolean validationEnabled) {
        this(new RequirementStatus(), validationEnabled);
    }

    public RequirementStatusBuilder(RequirementStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public RequirementStatusBuilder(RequirementStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RequirementStatus(), validationEnabled);
    }

    public RequirementStatusBuilder(RequirementStatusFluent<?> fluent,RequirementStatus instance) {
        this(fluent, instance, true);
    }

    public RequirementStatusBuilder(RequirementStatusFluent<?> fluent,RequirementStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDependents(instance.getDependents()); 
        fluent.withGroup(instance.getGroup()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withName(instance.getName()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withUuid(instance.getUuid()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public RequirementStatusBuilder(RequirementStatus instance) {
        this(instance,true);
    }

    public RequirementStatusBuilder(RequirementStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDependents(instance.getDependents()); 
        this.withGroup(instance.getGroup()); 
        this.withKind(instance.getKind()); 
        this.withMessage(instance.getMessage()); 
        this.withName(instance.getName()); 
        this.withStatus(instance.getStatus()); 
        this.withUuid(instance.getUuid()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public RequirementStatus build() {
        RequirementStatus buildable = new RequirementStatus(fluent.getDependents(),fluent.getGroup(),fluent.getKind(),fluent.getMessage(),fluent.getName(),fluent.getStatus(),fluent.getUuid(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RequirementStatusBuilder that = (RequirementStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
