package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriptionConfigBuilder extends SubscriptionConfigFluentImpl<SubscriptionConfigBuilder> implements VisitableBuilder<SubscriptionConfig,SubscriptionConfigBuilder> {

    SubscriptionConfigFluent<?> fluent;
    Boolean validationEnabled;

    public SubscriptionConfigBuilder() { 
        this(true);
    }


    public SubscriptionConfigBuilder(Boolean validationEnabled) { 
        this(new SubscriptionConfig(), validationEnabled);
    }


    public SubscriptionConfigBuilder(SubscriptionConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public SubscriptionConfigBuilder(SubscriptionConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new SubscriptionConfig(), validationEnabled);
    }


    public SubscriptionConfigBuilder(SubscriptionConfigFluent<?> fluent,SubscriptionConfig instance) { 
        this(fluent, instance, true);
    }


    public SubscriptionConfigBuilder(SubscriptionConfigFluent<?> fluent,SubscriptionConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withEnv(instance.getEnv()); 
        fluent.withEnvFrom(instance.getEnvFrom()); 
        fluent.withNodeSelector(instance.getNodeSelector()); 
        fluent.withResources(instance.getResources()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withTolerations(instance.getTolerations()); 
        fluent.withVolumeMounts(instance.getVolumeMounts()); 
        fluent.withVolumes(instance.getVolumes()); 
        this.validationEnabled = validationEnabled; 
    }


    public SubscriptionConfigBuilder(SubscriptionConfig instance) { 
        this(instance,true);
    }


    public SubscriptionConfigBuilder(SubscriptionConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withEnv(instance.getEnv()); 
        this.withEnvFrom(instance.getEnvFrom()); 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withResources(instance.getResources()); 
        this.withSelector(instance.getSelector()); 
        this.withTolerations(instance.getTolerations()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
        this.validationEnabled = validationEnabled; 
    }


    public SubscriptionConfig build() {
        SubscriptionConfig buildable = new SubscriptionConfig(fluent.getEnv(),fluent.getEnvFrom(),fluent.getNodeSelector(),fluent.getResources(),fluent.getSelector(),fluent.getTolerations(),fluent.getVolumeMounts(),fluent.getVolumes());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SubscriptionConfigBuilder that = (SubscriptionConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
