package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class StrategyDeploymentPermissionsFluentImpl<A extends StrategyDeploymentPermissionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StrategyDeploymentPermissionsFluent<A> {

    private List<PolicyRule> rules = new ArrayList<PolicyRule>();
    private String serviceAccountName;

    public StrategyDeploymentPermissionsFluentImpl() { 
    }


    public StrategyDeploymentPermissionsFluentImpl(StrategyDeploymentPermissions instance) { 
        this.withRules(instance.getRules()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
    }


    public A addToRules(int index,PolicyRule item) {
        if (this.rules == null) {this.rules = new ArrayList<PolicyRule>();}
        this.rules.add(index, item);
        return (A)this;
    }

    public A setToRules(int index,PolicyRule item) {
        if (this.rules == null) {this.rules = new ArrayList<PolicyRule>();}
        this.rules.set(index, item); return (A)this;
    }

    public A addToRules(PolicyRule... items) {
        if (this.rules == null) {this.rules = new ArrayList<PolicyRule>();}
        for (PolicyRule item : items) {this.rules.add(item);} return (A)this;
    }

    public A addAllToRules(Collection<PolicyRule> items) {
        if (this.rules == null) {this.rules = new ArrayList<PolicyRule>();}
        for (PolicyRule item : items) {this.rules.add(item);} return (A)this;
    }

    public A removeFromRules(PolicyRule... items) {
        for (PolicyRule item : items) {if (this.rules!= null){ this.rules.remove(item);}} return (A)this;
    }

    public A removeAllFromRules(Collection<PolicyRule> items) {
        for (PolicyRule item : items) {if (this.rules!= null){ this.rules.remove(item);}} return (A)this;
    }

    public List<PolicyRule> getRules() {
        return this.rules;
    }

    public PolicyRule getRule(int index) {
        return this.rules.get(index);
    }

    public PolicyRule getFirstRule() {
        return this.rules.get(0);
    }

    public PolicyRule getLastRule() {
        return this.rules.get(rules.size() - 1);
    }

    public PolicyRule getMatchingRule(Predicate<PolicyRule> predicate) {
        for (PolicyRule item: rules) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRule(Predicate<PolicyRule> predicate) {
        for (PolicyRule item: rules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRules(List<PolicyRule> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new ArrayList<PolicyRule>(); for (PolicyRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(PolicyRule... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (PolicyRule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StrategyDeploymentPermissionsFluentImpl that = (StrategyDeploymentPermissionsFluentImpl) o;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(rules,  serviceAccountName,  super.hashCode());
    }

}
