package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ConfigMapResourceReferenceFluentImpl<A extends ConfigMapResourceReferenceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConfigMapResourceReferenceFluent<A> {

    private String lastUpdateTime;
    private String name;
    private String namespace;
    private String resourceVersion;
    private String uid;

    public ConfigMapResourceReferenceFluentImpl() { 
    }


    public ConfigMapResourceReferenceFluentImpl(ConfigMapResourceReference instance) { 
        this.withLastUpdateTime(instance.getLastUpdateTime()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withResourceVersion(instance.getResourceVersion()); 
        this.withUid(instance.getUid()); 
    }


    public String getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public A withLastUpdateTime(String lastUpdateTime) {
        this.lastUpdateTime=lastUpdateTime; return (A) this;
    }

    public Boolean hasLastUpdateTime() {
        return this.lastUpdateTime != null;
    }

    public A withNewLastUpdateTime(String arg1) {
        return (A)withLastUpdateTime(new String(arg1));
    }

    public A withNewLastUpdateTime(StringBuilder arg1) {
        return (A)withLastUpdateTime(new String(arg1));
    }

    public A withNewLastUpdateTime(StringBuffer arg1) {
        return (A)withLastUpdateTime(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    public A withNewNamespace(String arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion=resourceVersion; return (A) this;
    }

    public Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    public A withNewResourceVersion(String arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuilder arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuffer arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid=uid; return (A) this;
    }

    public Boolean hasUid() {
        return this.uid != null;
    }

    public A withNewUid(String arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuilder arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1) {
        return (A)withUid(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConfigMapResourceReferenceFluentImpl that = (ConfigMapResourceReferenceFluentImpl) o;
        if (lastUpdateTime != null ? !lastUpdateTime.equals(that.lastUpdateTime) :that.lastUpdateTime != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(lastUpdateTime,  name,  namespace,  resourceVersion,  uid,  super.hashCode());
    }

}
