package io.fabric8.openshift.api.model.operatorhub.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class OperatorGroupStatusFluentImpl<A extends OperatorGroupStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OperatorGroupStatusFluent<A> {

    private String lastUpdated;
    private List<String> namespaces = new ArrayList<String>();
    private ObjectReferenceBuilder serviceAccountRef;

    public OperatorGroupStatusFluentImpl() { 
    }


    public OperatorGroupStatusFluentImpl(OperatorGroupStatus instance) { 
        this.withLastUpdated(instance.getLastUpdated()); 
        this.withNamespaces(instance.getNamespaces()); 
        this.withServiceAccountRef(instance.getServiceAccountRef()); 
    }


    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated=lastUpdated; return (A) this;
    }

    public Boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    public A withNewLastUpdated(String arg1) {
        return (A)withLastUpdated(new String(arg1));
    }

    public A withNewLastUpdated(StringBuilder arg1) {
        return (A)withLastUpdated(new String(arg1));
    }

    public A withNewLastUpdated(StringBuffer arg1) {
        return (A)withLastUpdated(new String(arg1));
    }

    public A addToNamespaces(int index,String item) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        this.namespaces.add(index, item);
        return (A)this;
    }

    public A setToNamespaces(int index,String item) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(String... items) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(String... items) {
        for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    public String getLastNamespace() {
        return this.namespaces.get(namespaces.size() - 1);
    }

    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item: namespaces) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item: namespaces) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNamespaces(List<String> namespaces) {
        if (this.namespaces != null) { _visitables.get("namespaces").removeAll(this.namespaces);}
        if (namespaces != null) {this.namespaces = new ArrayList<String>(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(String... namespaces) {
        if (this.namespaces != null) {this.namespaces.clear();}
        if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public Boolean hasNamespaces() {
        return namespaces != null && !namespaces.isEmpty();
    }

    public A addNewNamespace(String arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuilder arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuffer arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildServiceAccountRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getServiceAccountRef() {
        return this.serviceAccountRef!=null?this.serviceAccountRef.build():null;
    }

    public ObjectReference buildServiceAccountRef() {
        return this.serviceAccountRef!=null?this.serviceAccountRef.build():null;
    }

    public A withServiceAccountRef(ObjectReference serviceAccountRef) {
        _visitables.get("serviceAccountRef").remove(this.serviceAccountRef);
        if (serviceAccountRef!=null){ this.serviceAccountRef= new ObjectReferenceBuilder(serviceAccountRef); _visitables.get("serviceAccountRef").add(this.serviceAccountRef);} return (A) this;
    }

    public Boolean hasServiceAccountRef() {
        return this.serviceAccountRef != null;
    }

    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> withNewServiceAccountRef() {
        return new ServiceAccountRefNestedImpl();
    }

    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> withNewServiceAccountRefLike(ObjectReference item) {
        return new ServiceAccountRefNestedImpl(item);
    }

    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editServiceAccountRef() {
        return withNewServiceAccountRefLike(getServiceAccountRef());
    }

    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editOrNewServiceAccountRef() {
        return withNewServiceAccountRefLike(getServiceAccountRef() != null ? getServiceAccountRef(): new ObjectReferenceBuilder().build());
    }

    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editOrNewServiceAccountRefLike(ObjectReference item) {
        return withNewServiceAccountRefLike(getServiceAccountRef() != null ? getServiceAccountRef(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OperatorGroupStatusFluentImpl that = (OperatorGroupStatusFluentImpl) o;
        if (lastUpdated != null ? !lastUpdated.equals(that.lastUpdated) :that.lastUpdated != null) return false;
        if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
        if (serviceAccountRef != null ? !serviceAccountRef.equals(that.serviceAccountRef) :that.serviceAccountRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(lastUpdated,  namespaces,  serviceAccountRef,  super.hashCode());
    }

    public class ServiceAccountRefNestedImpl<N> extends ObjectReferenceFluentImpl<OperatorGroupStatusFluent.ServiceAccountRefNested<N>> implements OperatorGroupStatusFluent.ServiceAccountRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectReferenceBuilder builder;

        ServiceAccountRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ServiceAccountRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) OperatorGroupStatusFluentImpl.this.withServiceAccountRef(builder.build());
        }

        public N endServiceAccountRef() {
             return and();
        }
    }


}
