package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RequirementStatusFluentImpl<A extends RequirementStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RequirementStatusFluent<A> {

    private List<DependentStatusBuilder> dependents =  new ArrayList<DependentStatusBuilder>();
    private String group;
    private String kind;
    private String message;
    private String name;
    private String status;
    private String uuid;
    private String version;

    public RequirementStatusFluentImpl() { 
    }


    public RequirementStatusFluentImpl(RequirementStatus instance) { 
        this.withDependents(instance.getDependents()); 
        this.withGroup(instance.getGroup()); 
        this.withKind(instance.getKind()); 
        this.withMessage(instance.getMessage()); 
        this.withName(instance.getName()); 
        this.withStatus(instance.getStatus()); 
        this.withUuid(instance.getUuid()); 
        this.withVersion(instance.getVersion()); 
    }


    public A addToDependents(int index,DependentStatus item) {
        if (this.dependents == null) {this.dependents = new ArrayList<DependentStatusBuilder>();}
        DependentStatusBuilder builder = new DependentStatusBuilder(item);_visitables.get("dependents").add(index >= 0 ? index : _visitables.get("dependents").size(), builder);this.dependents.add(index >= 0 ? index : dependents.size(), builder); return (A)this;
    }

    public A setToDependents(int index,DependentStatus item) {
        if (this.dependents == null) {this.dependents = new ArrayList<DependentStatusBuilder>();}
        DependentStatusBuilder builder = new DependentStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("dependents").size()) { _visitables.get("dependents").add(builder); } else { _visitables.get("dependents").set(index, builder);}
        if (index < 0 || index >= dependents.size()) { dependents.add(builder); } else { dependents.set(index, builder);}
         return (A)this;
    }

    public A addToDependents(DependentStatus... items) {
        if (this.dependents == null) {this.dependents = new ArrayList<DependentStatusBuilder>();}
        for (DependentStatus item : items) {DependentStatusBuilder builder = new DependentStatusBuilder(item);_visitables.get("dependents").add(builder);this.dependents.add(builder);} return (A)this;
    }

    public A addAllToDependents(Collection<DependentStatus> items) {
        if (this.dependents == null) {this.dependents = new ArrayList<DependentStatusBuilder>();}
        for (DependentStatus item : items) {DependentStatusBuilder builder = new DependentStatusBuilder(item);_visitables.get("dependents").add(builder);this.dependents.add(builder);} return (A)this;
    }

    public A removeFromDependents(DependentStatus... items) {
        for (DependentStatus item : items) {DependentStatusBuilder builder = new DependentStatusBuilder(item);_visitables.get("dependents").remove(builder);if (this.dependents != null) {this.dependents.remove(builder);}} return (A)this;
    }

    public A removeAllFromDependents(Collection<DependentStatus> items) {
        for (DependentStatus item : items) {DependentStatusBuilder builder = new DependentStatusBuilder(item);_visitables.get("dependents").remove(builder);if (this.dependents != null) {this.dependents.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDependents(Predicate<DependentStatusBuilder> predicate) {
        if (dependents == null) return (A) this;
        final Iterator<DependentStatusBuilder> each = dependents.iterator();
        final List visitables = _visitables.get("dependents");
        while (each.hasNext()) {
          DependentStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDependents instead.
 * @return The buildable object.
 */
@Deprecated public List<DependentStatus> getDependents() {
        return build(dependents);
    }

    public List<DependentStatus> buildDependents() {
        return build(dependents);
    }

    public DependentStatus buildDependent(int index) {
        return this.dependents.get(index).build();
    }

    public DependentStatus buildFirstDependent() {
        return this.dependents.get(0).build();
    }

    public DependentStatus buildLastDependent() {
        return this.dependents.get(dependents.size() - 1).build();
    }

    public DependentStatus buildMatchingDependent(Predicate<DependentStatusBuilder> predicate) {
        for (DependentStatusBuilder item: dependents) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingDependent(Predicate<DependentStatusBuilder> predicate) {
        for (DependentStatusBuilder item: dependents) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependents(List<DependentStatus> dependents) {
        if (this.dependents != null) { _visitables.get("dependents").removeAll(this.dependents);}
        if (dependents != null) {this.dependents = new ArrayList<DependentStatusBuilder>(); for (DependentStatus item : dependents){this.addToDependents(item);}} else { this.dependents = null;} return (A) this;
    }

    public A withDependents(DependentStatus... dependents) {
        if (this.dependents != null) {this.dependents.clear();}
        if (dependents != null) {for (DependentStatus item :dependents){ this.addToDependents(item);}} return (A) this;
    }

    public Boolean hasDependents() {
        return dependents != null && !dependents.isEmpty();
    }

    public RequirementStatusFluent.DependentsNested<A> addNewDependent() {
        return new DependentsNestedImpl();
    }

    public RequirementStatusFluent.DependentsNested<A> addNewDependentLike(DependentStatus item) {
        return new DependentsNestedImpl(-1, item);
    }

    public RequirementStatusFluent.DependentsNested<A> setNewDependentLike(int index,DependentStatus item) {
        return new DependentsNestedImpl(index, item);
    }

    public RequirementStatusFluent.DependentsNested<A> editDependent(int index) {
        if (dependents.size() <= index) throw new RuntimeException("Can't edit dependents. Index exceeds size.");
        return setNewDependentLike(index, buildDependent(index));
    }

    public RequirementStatusFluent.DependentsNested<A> editFirstDependent() {
        if (dependents.size() == 0) throw new RuntimeException("Can't edit first dependents. The list is empty.");
        return setNewDependentLike(0, buildDependent(0));
    }

    public RequirementStatusFluent.DependentsNested<A> editLastDependent() {
        int index = dependents.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last dependents. The list is empty.");
        return setNewDependentLike(index, buildDependent(index));
    }

    public RequirementStatusFluent.DependentsNested<A> editMatchingDependent(Predicate<DependentStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<dependents.size();i++) { 
        if (predicate.test(dependents.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching dependents. No match found.");
        return setNewDependentLike(index, buildDependent(index));
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group=group; return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1) {
        return (A)withGroup(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message=message; return (A) this;
    }

    public Boolean hasMessage() {
        return this.message != null;
    }

    public A withNewMessage(String arg1) {
        return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1) {
        return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1) {
        return (A)withMessage(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getStatus() {
        return this.status;
    }

    public A withStatus(String status) {
        this.status=status; return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public A withNewStatus(String arg1) {
        return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuilder arg1) {
        return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuffer arg1) {
        return (A)withStatus(new String(arg1));
    }

    public String getUuid() {
        return this.uuid;
    }

    public A withUuid(String uuid) {
        this.uuid=uuid; return (A) this;
    }

    public Boolean hasUuid() {
        return this.uuid != null;
    }

    public A withNewUuid(String arg1) {
        return (A)withUuid(new String(arg1));
    }

    public A withNewUuid(StringBuilder arg1) {
        return (A)withUuid(new String(arg1));
    }

    public A withNewUuid(StringBuffer arg1) {
        return (A)withUuid(new String(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RequirementStatusFluentImpl that = (RequirementStatusFluentImpl) o;
        if (dependents != null ? !dependents.equals(that.dependents) :that.dependents != null) return false;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (message != null ? !message.equals(that.message) :that.message != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        if (uuid != null ? !uuid.equals(that.uuid) :that.uuid != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(dependents,  group,  kind,  message,  name,  status,  uuid,  version,  super.hashCode());
    }

    public class DependentsNestedImpl<N> extends DependentStatusFluentImpl<RequirementStatusFluent.DependentsNested<N>> implements RequirementStatusFluent.DependentsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DependentStatusBuilder builder;
        private final int index;

        DependentsNestedImpl(int index,DependentStatus item) {
            this.index = index;
            this.builder = new DependentStatusBuilder(this, item);
        }

        DependentsNestedImpl() {
            this.index = -1;
            this.builder = new DependentStatusBuilder(this);
        }

        public N and() {
             return (N) RequirementStatusFluentImpl.this.setToDependents(index,builder.build());
        }

        public N endDependent() {
             return and();
        }
    }


}
