package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface APIServiceDefinitionsFluent<A extends APIServiceDefinitionsFluent<A>> extends Fluent<A> {


    public A addToOwned(int index,APIServiceDescription item);
    public A setToOwned(int index,APIServiceDescription item);
    public A addToOwned(APIServiceDescription... items);
    public A addAllToOwned(Collection<APIServiceDescription> items);
    public A removeFromOwned(APIServiceDescription... items);
    public A removeAllFromOwned(Collection<APIServiceDescription> items);
    public A removeMatchingFromOwned(Predicate<APIServiceDescriptionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildOwned instead.
 * @return The buildable object.
 */
@Deprecated public List<APIServiceDescription> getOwned();
    public List<APIServiceDescription> buildOwned();
    public APIServiceDescription buildOwned(int index);
    public APIServiceDescription buildFirstOwned();
    public APIServiceDescription buildLastOwned();
    public APIServiceDescription buildMatchingOwned(Predicate<APIServiceDescriptionBuilder> predicate);
    public Boolean hasMatchingOwned(Predicate<APIServiceDescriptionBuilder> predicate);
    public A withOwned(List<APIServiceDescription> owned);
    public A withOwned(APIServiceDescription... owned);
    public Boolean hasOwned();
    public APIServiceDefinitionsFluent.OwnedNested<A> addNewOwned();
    public APIServiceDefinitionsFluent.OwnedNested<A> addNewOwnedLike(APIServiceDescription item);
    public APIServiceDefinitionsFluent.OwnedNested<A> setNewOwnedLike(int index,APIServiceDescription item);
    public APIServiceDefinitionsFluent.OwnedNested<A> editOwned(int index);
    public APIServiceDefinitionsFluent.OwnedNested<A> editFirstOwned();
    public APIServiceDefinitionsFluent.OwnedNested<A> editLastOwned();
    public APIServiceDefinitionsFluent.OwnedNested<A> editMatchingOwned(Predicate<APIServiceDescriptionBuilder> predicate);
    public A addToRequired(int index,APIServiceDescription item);
    public A setToRequired(int index,APIServiceDescription item);
    public A addToRequired(APIServiceDescription... items);
    public A addAllToRequired(Collection<APIServiceDescription> items);
    public A removeFromRequired(APIServiceDescription... items);
    public A removeAllFromRequired(Collection<APIServiceDescription> items);
    public A removeMatchingFromRequired(Predicate<APIServiceDescriptionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildRequired instead.
 * @return The buildable object.
 */
@Deprecated public List<APIServiceDescription> getRequired();
    public List<APIServiceDescription> buildRequired();
    public APIServiceDescription buildRequired(int index);
    public APIServiceDescription buildFirstRequired();
    public APIServiceDescription buildLastRequired();
    public APIServiceDescription buildMatchingRequired(Predicate<APIServiceDescriptionBuilder> predicate);
    public Boolean hasMatchingRequired(Predicate<APIServiceDescriptionBuilder> predicate);
    public A withRequired(List<APIServiceDescription> required);
    public A withRequired(APIServiceDescription... required);
    public Boolean hasRequired();
    public APIServiceDefinitionsFluent.RequiredNested<A> addNewRequired();
    public APIServiceDefinitionsFluent.RequiredNested<A> addNewRequiredLike(APIServiceDescription item);
    public APIServiceDefinitionsFluent.RequiredNested<A> setNewRequiredLike(int index,APIServiceDescription item);
    public APIServiceDefinitionsFluent.RequiredNested<A> editRequired(int index);
    public APIServiceDefinitionsFluent.RequiredNested<A> editFirstRequired();
    public APIServiceDefinitionsFluent.RequiredNested<A> editLastRequired();
    public APIServiceDefinitionsFluent.RequiredNested<A> editMatchingRequired(Predicate<APIServiceDescriptionBuilder> predicate);
    public interface OwnedNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServiceDescriptionFluent<APIServiceDefinitionsFluent.OwnedNested<N>> {

        public N and();
        public N endOwned();    }


    public interface RequiredNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServiceDescriptionFluent<APIServiceDefinitionsFluent.RequiredNested<N>> {

        public N and();
        public N endRequired();    }


}
