
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.GroupVersionKind;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "annotations",
    "apiservicedefinitions",
    "customresourcedefinitions",
    "description",
    "displayName",
    "icon",
    "install",
    "installModes",
    "keywords",
    "labels",
    "links",
    "maintainers",
    "maturity",
    "minKubeVersion",
    "nativeAPIs",
    "provider",
    "replaces",
    "selector",
    "version",
    "webhookdefinitions"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class ClusterServiceVersionSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("annotations")
    private Map<String, String> annotations;
    /**
     * 
     * 
     */
    @JsonProperty("apiservicedefinitions")
    private APIServiceDefinitions apiservicedefinitions;
    /**
     * 
     * 
     */
    @JsonProperty("customresourcedefinitions")
    private CustomResourceDefinitions customresourcedefinitions;
    /**
     * 
     * 
     */
    @JsonProperty("description")
    private java.lang.String description;
    /**
     * 
     * 
     */
    @JsonProperty("displayName")
    private java.lang.String displayName;
    /**
     * 
     * 
     */
    @JsonProperty("icon")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<Icon> icon = new ArrayList<Icon>();
    /**
     * 
     * 
     */
    @JsonProperty("install")
    private NamedInstallStrategy install;
    /**
     * 
     * 
     */
    @JsonProperty("installModes")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<InstallMode> installModes = new ArrayList<InstallMode>();
    /**
     * 
     * 
     */
    @JsonProperty("keywords")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<java.lang.String> keywords = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("labels")
    private Map<String, String> labels;
    /**
     * 
     * 
     */
    @JsonProperty("links")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<AppLink> links = new ArrayList<AppLink>();
    /**
     * 
     * 
     */
    @JsonProperty("maintainers")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<Maintainer> maintainers = new ArrayList<Maintainer>();
    /**
     * 
     * 
     */
    @JsonProperty("maturity")
    private java.lang.String maturity;
    /**
     * 
     * 
     */
    @JsonProperty("minKubeVersion")
    private java.lang.String minKubeVersion;
    /**
     * 
     * 
     */
    @JsonProperty("nativeAPIs")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<GroupVersionKind> nativeAPIs = new ArrayList<GroupVersionKind>();
    /**
     * 
     * 
     */
    @JsonProperty("provider")
    private AppLink provider;
    /**
     * 
     * 
     */
    @JsonProperty("replaces")
    private java.lang.String replaces;
    /**
     * 
     * 
     */
    @JsonProperty("selector")
    private io.fabric8.kubernetes.api.model.LabelSelector selector;
    /**
     * 
     * 
     */
    @JsonProperty("version")
    private OperatorVersion version;
    /**
     * 
     * 
     */
    @JsonProperty("webhookdefinitions")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<WebhookDescription> webhookdefinitions = new ArrayList<WebhookDescription>();
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ClusterServiceVersionSpec() {
    }

    /**
     * 
     * @param maintainers
     * @param customresourcedefinitions
     * @param installModes
     * @param keywords
     * @param apiservicedefinitions
     * @param maturity
     * @param displayName
     * @param replaces
     * @param icon
     * @param annotations
     * @param description
     * @param nativeAPIs
     * @param version
     * @param labels
     * @param webhookdefinitions
     * @param minKubeVersion
     * @param install
     * @param provider
     * @param links
     * @param selector
     */
    public ClusterServiceVersionSpec(Map<String, String> annotations, APIServiceDefinitions apiservicedefinitions, CustomResourceDefinitions customresourcedefinitions, java.lang.String description, java.lang.String displayName, List<Icon> icon, NamedInstallStrategy install, List<InstallMode> installModes, List<java.lang.String> keywords, Map<String, String> labels, List<AppLink> links, List<Maintainer> maintainers, java.lang.String maturity, java.lang.String minKubeVersion, List<GroupVersionKind> nativeAPIs, AppLink provider, java.lang.String replaces, io.fabric8.kubernetes.api.model.LabelSelector selector, OperatorVersion version, List<WebhookDescription> webhookdefinitions) {
        this.annotations = annotations;
        this.apiservicedefinitions = apiservicedefinitions;
        this.customresourcedefinitions = customresourcedefinitions;
        this.description = description;
        this.displayName = displayName;
        this.icon = icon;
        this.install = install;
        this.installModes = installModes;
        this.keywords = keywords;
        this.labels = labels;
        this.links = links;
        this.maintainers = maintainers;
        this.maturity = maturity;
        this.minKubeVersion = minKubeVersion;
        this.nativeAPIs = nativeAPIs;
        this.provider = provider;
        this.replaces = replaces;
        this.selector = selector;
        this.version = version;
        this.webhookdefinitions = webhookdefinitions;
    }

    /**
     * 
     * 
     * @return
     *     The annotations
     */
    @JsonProperty("annotations")
    public Map<String, String> getAnnotations() {
        return annotations;
    }

    /**
     * 
     * 
     * @param annotations
     *     The annotations
     */
    @JsonProperty("annotations")
    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    /**
     * 
     * 
     * @return
     *     The apiservicedefinitions
     */
    @JsonProperty("apiservicedefinitions")
    public APIServiceDefinitions getApiservicedefinitions() {
        return apiservicedefinitions;
    }

    /**
     * 
     * 
     * @param apiservicedefinitions
     *     The apiservicedefinitions
     */
    @JsonProperty("apiservicedefinitions")
    public void setApiservicedefinitions(APIServiceDefinitions apiservicedefinitions) {
        this.apiservicedefinitions = apiservicedefinitions;
    }

    /**
     * 
     * 
     * @return
     *     The customresourcedefinitions
     */
    @JsonProperty("customresourcedefinitions")
    public CustomResourceDefinitions getCustomresourcedefinitions() {
        return customresourcedefinitions;
    }

    /**
     * 
     * 
     * @param customresourcedefinitions
     *     The customresourcedefinitions
     */
    @JsonProperty("customresourcedefinitions")
    public void setCustomresourcedefinitions(CustomResourceDefinitions customresourcedefinitions) {
        this.customresourcedefinitions = customresourcedefinitions;
    }

    /**
     * 
     * 
     * @return
     *     The description
     */
    @JsonProperty("description")
    public java.lang.String getDescription() {
        return description;
    }

    /**
     * 
     * 
     * @param description
     *     The description
     */
    @JsonProperty("description")
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * 
     * 
     * @return
     *     The displayName
     */
    @JsonProperty("displayName")
    public java.lang.String getDisplayName() {
        return displayName;
    }

    /**
     * 
     * 
     * @param displayName
     *     The displayName
     */
    @JsonProperty("displayName")
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * 
     * 
     * @return
     *     The icon
     */
    @JsonProperty("icon")
    public List<Icon> getIcon() {
        return icon;
    }

    /**
     * 
     * 
     * @param icon
     *     The icon
     */
    @JsonProperty("icon")
    public void setIcon(List<Icon> icon) {
        this.icon = icon;
    }

    /**
     * 
     * 
     * @return
     *     The install
     */
    @JsonProperty("install")
    public NamedInstallStrategy getInstall() {
        return install;
    }

    /**
     * 
     * 
     * @param install
     *     The install
     */
    @JsonProperty("install")
    public void setInstall(NamedInstallStrategy install) {
        this.install = install;
    }

    /**
     * 
     * 
     * @return
     *     The installModes
     */
    @JsonProperty("installModes")
    public List<InstallMode> getInstallModes() {
        return installModes;
    }

    /**
     * 
     * 
     * @param installModes
     *     The installModes
     */
    @JsonProperty("installModes")
    public void setInstallModes(List<InstallMode> installModes) {
        this.installModes = installModes;
    }

    /**
     * 
     * 
     * @return
     *     The keywords
     */
    @JsonProperty("keywords")
    public List<java.lang.String> getKeywords() {
        return keywords;
    }

    /**
     * 
     * 
     * @param keywords
     *     The keywords
     */
    @JsonProperty("keywords")
    public void setKeywords(List<java.lang.String> keywords) {
        this.keywords = keywords;
    }

    /**
     * 
     * 
     * @return
     *     The labels
     */
    @JsonProperty("labels")
    public Map<String, String> getLabels() {
        return labels;
    }

    /**
     * 
     * 
     * @param labels
     *     The labels
     */
    @JsonProperty("labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    /**
     * 
     * 
     * @return
     *     The links
     */
    @JsonProperty("links")
    public List<AppLink> getLinks() {
        return links;
    }

    /**
     * 
     * 
     * @param links
     *     The links
     */
    @JsonProperty("links")
    public void setLinks(List<AppLink> links) {
        this.links = links;
    }

    /**
     * 
     * 
     * @return
     *     The maintainers
     */
    @JsonProperty("maintainers")
    public List<Maintainer> getMaintainers() {
        return maintainers;
    }

    /**
     * 
     * 
     * @param maintainers
     *     The maintainers
     */
    @JsonProperty("maintainers")
    public void setMaintainers(List<Maintainer> maintainers) {
        this.maintainers = maintainers;
    }

    /**
     * 
     * 
     * @return
     *     The maturity
     */
    @JsonProperty("maturity")
    public java.lang.String getMaturity() {
        return maturity;
    }

    /**
     * 
     * 
     * @param maturity
     *     The maturity
     */
    @JsonProperty("maturity")
    public void setMaturity(java.lang.String maturity) {
        this.maturity = maturity;
    }

    /**
     * 
     * 
     * @return
     *     The minKubeVersion
     */
    @JsonProperty("minKubeVersion")
    public java.lang.String getMinKubeVersion() {
        return minKubeVersion;
    }

    /**
     * 
     * 
     * @param minKubeVersion
     *     The minKubeVersion
     */
    @JsonProperty("minKubeVersion")
    public void setMinKubeVersion(java.lang.String minKubeVersion) {
        this.minKubeVersion = minKubeVersion;
    }

    /**
     * 
     * 
     * @return
     *     The nativeAPIs
     */
    @JsonProperty("nativeAPIs")
    public List<GroupVersionKind> getNativeAPIs() {
        return nativeAPIs;
    }

    /**
     * 
     * 
     * @param nativeAPIs
     *     The nativeAPIs
     */
    @JsonProperty("nativeAPIs")
    public void setNativeAPIs(List<GroupVersionKind> nativeAPIs) {
        this.nativeAPIs = nativeAPIs;
    }

    /**
     * 
     * 
     * @return
     *     The provider
     */
    @JsonProperty("provider")
    public AppLink getProvider() {
        return provider;
    }

    /**
     * 
     * 
     * @param provider
     *     The provider
     */
    @JsonProperty("provider")
    public void setProvider(AppLink provider) {
        this.provider = provider;
    }

    /**
     * 
     * 
     * @return
     *     The replaces
     */
    @JsonProperty("replaces")
    public java.lang.String getReplaces() {
        return replaces;
    }

    /**
     * 
     * 
     * @param replaces
     *     The replaces
     */
    @JsonProperty("replaces")
    public void setReplaces(java.lang.String replaces) {
        this.replaces = replaces;
    }

    /**
     * 
     * 
     * @return
     *     The selector
     */
    @JsonProperty("selector")
    public io.fabric8.kubernetes.api.model.LabelSelector getSelector() {
        return selector;
    }

    /**
     * 
     * 
     * @param selector
     *     The selector
     */
    @JsonProperty("selector")
    public void setSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
        this.selector = selector;
    }

    /**
     * 
     * 
     * @return
     *     The version
     */
    @JsonProperty("version")
    public OperatorVersion getVersion() {
        return version;
    }

    /**
     * 
     * 
     * @param version
     *     The version
     */
    @JsonProperty("version")
    public void setVersion(OperatorVersion version) {
        this.version = version;
    }

    /**
     * 
     * 
     * @return
     *     The webhookdefinitions
     */
    @JsonProperty("webhookdefinitions")
    public List<WebhookDescription> getWebhookdefinitions() {
        return webhookdefinitions;
    }

    /**
     * 
     * 
     * @param webhookdefinitions
     *     The webhookdefinitions
     */
    @JsonProperty("webhookdefinitions")
    public void setWebhookdefinitions(List<WebhookDescription> webhookdefinitions) {
        this.webhookdefinitions = webhookdefinitions;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
