package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperationsFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperationsBuilder;
import java.util.Collection;
import java.lang.Object;

public class WebhookDescriptionFluentImpl<A extends WebhookDescriptionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements WebhookDescriptionFluent<A> {

    private List<String> admissionReviewVersions = new ArrayList<String>();
    private Integer containerPort;
    private List<String> conversionCRDs = new ArrayList<String>();
    private String deploymentName;
    private String failurePolicy;
    private String generateName;
    private String matchPolicy;
    private LabelSelectorBuilder objectSelector;
    private String reinvocationPolicy;
    private List<RuleWithOperationsBuilder> rules =  new ArrayList<RuleWithOperationsBuilder>();
    private String sideEffects;
    private Integer timeoutSeconds;
    private String type;
    private String webhookPath;

    public WebhookDescriptionFluentImpl() { 
    }


    public WebhookDescriptionFluentImpl(WebhookDescription instance) { 
        this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions()); 
        this.withContainerPort(instance.getContainerPort()); 
        this.withConversionCRDs(instance.getConversionCRDs()); 
        this.withDeploymentName(instance.getDeploymentName()); 
        this.withFailurePolicy(instance.getFailurePolicy()); 
        this.withGenerateName(instance.getGenerateName()); 
        this.withMatchPolicy(instance.getMatchPolicy()); 
        this.withObjectSelector(instance.getObjectSelector()); 
        this.withReinvocationPolicy(instance.getReinvocationPolicy()); 
        this.withRules(instance.getRules()); 
        this.withSideEffects(instance.getSideEffects()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withType(instance.getType()); 
        this.withWebhookPath(instance.getWebhookPath()); 
    }


    public A addToAdmissionReviewVersions(int index,String item) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        this.admissionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToAdmissionReviewVersions(int index,String item) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        this.admissionReviewVersions.set(index, item); return (A)this;
    }

    public A addToAdmissionReviewVersions(String... items) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
    }

    public A addAllToAdmissionReviewVersions(Collection<String> items) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
    }

    public A removeFromAdmissionReviewVersions(String... items) {
        for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromAdmissionReviewVersions(Collection<String> items) {
        for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
    }

    public List<String> getAdmissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    public String getAdmissionReviewVersion(int index) {
        return this.admissionReviewVersions.get(index);
    }

    public String getFirstAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(0);
    }

    public String getLastAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(admissionReviewVersions.size() - 1);
    }

    public String getMatchingAdmissionReviewVersion(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: admissionReviewVersions) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAdmissionReviewVersion(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: admissionReviewVersions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAdmissionReviewVersions(List<String> admissionReviewVersions) {
        if (this.admissionReviewVersions != null) { _visitables.get("admissionReviewVersions").removeAll(this.admissionReviewVersions);}
        if (admissionReviewVersions != null) {this.admissionReviewVersions = new ArrayList<String>(); for (String item : admissionReviewVersions){this.addToAdmissionReviewVersions(item);}} else { this.admissionReviewVersions = null;} return (A) this;
    }

    public A withAdmissionReviewVersions(String... admissionReviewVersions) {
        if (this.admissionReviewVersions != null) {this.admissionReviewVersions.clear();}
        if (admissionReviewVersions != null) {for (String item :admissionReviewVersions){ this.addToAdmissionReviewVersions(item);}} return (A) this;
    }

    public Boolean hasAdmissionReviewVersions() {
        return admissionReviewVersions != null && !admissionReviewVersions.isEmpty();
    }

    public A addNewAdmissionReviewVersion(String arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public A addNewAdmissionReviewVersion(StringBuilder arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public A addNewAdmissionReviewVersion(StringBuffer arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public Integer getContainerPort() {
        return this.containerPort;
    }

    public A withContainerPort(Integer containerPort) {
        this.containerPort=containerPort; return (A) this;
    }

    public Boolean hasContainerPort() {
        return this.containerPort != null;
    }

    public A addToConversionCRDs(int index,String item) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
        this.conversionCRDs.add(index, item);
        return (A)this;
    }

    public A setToConversionCRDs(int index,String item) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
        this.conversionCRDs.set(index, item); return (A)this;
    }

    public A addToConversionCRDs(String... items) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
        for (String item : items) {this.conversionCRDs.add(item);} return (A)this;
    }

    public A addAllToConversionCRDs(Collection<String> items) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
        for (String item : items) {this.conversionCRDs.add(item);} return (A)this;
    }

    public A removeFromConversionCRDs(String... items) {
        for (String item : items) {if (this.conversionCRDs!= null){ this.conversionCRDs.remove(item);}} return (A)this;
    }

    public A removeAllFromConversionCRDs(Collection<String> items) {
        for (String item : items) {if (this.conversionCRDs!= null){ this.conversionCRDs.remove(item);}} return (A)this;
    }

    public List<String> getConversionCRDs() {
        return this.conversionCRDs;
    }

    public String getConversionCRD(int index) {
        return this.conversionCRDs.get(index);
    }

    public String getFirstConversionCRD() {
        return this.conversionCRDs.get(0);
    }

    public String getLastConversionCRD() {
        return this.conversionCRDs.get(conversionCRDs.size() - 1);
    }

    public String getMatchingConversionCRD(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: conversionCRDs) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingConversionCRD(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: conversionCRDs) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConversionCRDs(List<String> conversionCRDs) {
        if (this.conversionCRDs != null) { _visitables.get("conversionCRDs").removeAll(this.conversionCRDs);}
        if (conversionCRDs != null) {this.conversionCRDs = new ArrayList<String>(); for (String item : conversionCRDs){this.addToConversionCRDs(item);}} else { this.conversionCRDs = null;} return (A) this;
    }

    public A withConversionCRDs(String... conversionCRDs) {
        if (this.conversionCRDs != null) {this.conversionCRDs.clear();}
        if (conversionCRDs != null) {for (String item :conversionCRDs){ this.addToConversionCRDs(item);}} return (A) this;
    }

    public Boolean hasConversionCRDs() {
        return conversionCRDs != null && !conversionCRDs.isEmpty();
    }

    public A addNewConversionCRD(String arg1) {
        return (A)addToConversionCRDs(new String(arg1));
    }

    public A addNewConversionCRD(StringBuilder arg1) {
        return (A)addToConversionCRDs(new String(arg1));
    }

    public A addNewConversionCRD(StringBuffer arg1) {
        return (A)addToConversionCRDs(new String(arg1));
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public A withDeploymentName(String deploymentName) {
        this.deploymentName=deploymentName; return (A) this;
    }

    public Boolean hasDeploymentName() {
        return this.deploymentName != null;
    }

    public A withNewDeploymentName(String arg1) {
        return (A)withDeploymentName(new String(arg1));
    }

    public A withNewDeploymentName(StringBuilder arg1) {
        return (A)withDeploymentName(new String(arg1));
    }

    public A withNewDeploymentName(StringBuffer arg1) {
        return (A)withDeploymentName(new String(arg1));
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy=failurePolicy; return (A) this;
    }

    public Boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    public A withNewFailurePolicy(String arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(StringBuilder arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(StringBuffer arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public String getGenerateName() {
        return this.generateName;
    }

    public A withGenerateName(String generateName) {
        this.generateName=generateName; return (A) this;
    }

    public Boolean hasGenerateName() {
        return this.generateName != null;
    }

    public A withNewGenerateName(String arg1) {
        return (A)withGenerateName(new String(arg1));
    }

    public A withNewGenerateName(StringBuilder arg1) {
        return (A)withGenerateName(new String(arg1));
    }

    public A withNewGenerateName(StringBuffer arg1) {
        return (A)withGenerateName(new String(arg1));
    }

    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy=matchPolicy; return (A) this;
    }

    public Boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    public A withNewMatchPolicy(String arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    public A withNewMatchPolicy(StringBuilder arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    public A withNewMatchPolicy(StringBuffer arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildObjectSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getObjectSelector() {
        return this.objectSelector!=null?this.objectSelector.build():null;
    }

    public LabelSelector buildObjectSelector() {
        return this.objectSelector!=null?this.objectSelector.build():null;
    }

    public A withObjectSelector(LabelSelector objectSelector) {
        _visitables.get("objectSelector").remove(this.objectSelector);
        if (objectSelector!=null){ this.objectSelector= new LabelSelectorBuilder(objectSelector); _visitables.get("objectSelector").add(this.objectSelector);} return (A) this;
    }

    public Boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    public WebhookDescriptionFluent.ObjectSelectorNested<A> withNewObjectSelector() {
        return new ObjectSelectorNestedImpl();
    }

    public WebhookDescriptionFluent.ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
        return new ObjectSelectorNestedImpl(item);
    }

    public WebhookDescriptionFluent.ObjectSelectorNested<A> editObjectSelector() {
        return withNewObjectSelectorLike(getObjectSelector());
    }

    public WebhookDescriptionFluent.ObjectSelectorNested<A> editOrNewObjectSelector() {
        return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): new LabelSelectorBuilder().build());
    }

    public WebhookDescriptionFluent.ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
        return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): item);
    }

    public String getReinvocationPolicy() {
        return this.reinvocationPolicy;
    }

    public A withReinvocationPolicy(String reinvocationPolicy) {
        this.reinvocationPolicy=reinvocationPolicy; return (A) this;
    }

    public Boolean hasReinvocationPolicy() {
        return this.reinvocationPolicy != null;
    }

    public A withNewReinvocationPolicy(String arg1) {
        return (A)withReinvocationPolicy(new String(arg1));
    }

    public A withNewReinvocationPolicy(StringBuilder arg1) {
        return (A)withReinvocationPolicy(new String(arg1));
    }

    public A withNewReinvocationPolicy(StringBuffer arg1) {
        return (A)withReinvocationPolicy(new String(arg1));
    }

    public A addToRules(int index,RuleWithOperations item) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
        RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,RuleWithOperations item) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
        RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
        if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
        if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
         return (A)this;
    }

    public A addToRules(RuleWithOperations... items) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
        for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<RuleWithOperations> items) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
        for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(RuleWithOperations... items) {
        for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<RuleWithOperations> items) {
        for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(io.fabric8.kubernetes.api.builder.Predicate<RuleWithOperationsBuilder> predicate) {
        if (rules == null) return (A) this;
        final Iterator<RuleWithOperationsBuilder> each = rules.iterator();
        final List visitables = _visitables.get("rules");
        while (each.hasNext()) {
          RuleWithOperationsBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<RuleWithOperations> getRules() {
        return build(rules);
    }

    public List<RuleWithOperations> buildRules() {
        return build(rules);
    }

    public RuleWithOperations buildRule(int index) {
        return this.rules.get(index).build();
    }

    public RuleWithOperations buildFirstRule() {
        return this.rules.get(0).build();
    }

    public RuleWithOperations buildLastRule() {
        return this.rules.get(rules.size() - 1).build();
    }

    public RuleWithOperations buildMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<RuleWithOperationsBuilder> predicate) {
        for (RuleWithOperationsBuilder item: rules) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<RuleWithOperationsBuilder> predicate) {
        for (RuleWithOperationsBuilder item: rules) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRules(List<RuleWithOperations> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new ArrayList<RuleWithOperationsBuilder>(); for (RuleWithOperations item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(RuleWithOperations... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (RuleWithOperations item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public WebhookDescriptionFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    public WebhookDescriptionFluent.RulesNested<A> addNewRuleLike(RuleWithOperations item) {
        return new RulesNestedImpl(-1, item);
    }

    public WebhookDescriptionFluent.RulesNested<A> setNewRuleLike(int index,RuleWithOperations item) {
        return new RulesNestedImpl(index, item);
    }

    public WebhookDescriptionFluent.RulesNested<A> editRule(int index) {
        if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
        return setNewRuleLike(index, buildRule(index));
    }

    public WebhookDescriptionFluent.RulesNested<A> editFirstRule() {
        if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
        return setNewRuleLike(0, buildRule(0));
    }

    public WebhookDescriptionFluent.RulesNested<A> editLastRule() {
        int index = rules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
        return setNewRuleLike(index, buildRule(index));
    }

    public WebhookDescriptionFluent.RulesNested<A> editMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<RuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i=0;i<rules.size();i++) { 
        if (predicate.apply(rules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
        return setNewRuleLike(index, buildRule(index));
    }

    public String getSideEffects() {
        return this.sideEffects;
    }

    public A withSideEffects(String sideEffects) {
        this.sideEffects=sideEffects; return (A) this;
    }

    public Boolean hasSideEffects() {
        return this.sideEffects != null;
    }

    public A withNewSideEffects(String arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public A withNewSideEffects(StringBuilder arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public A withNewSideEffects(StringBuffer arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public String getWebhookPath() {
        return this.webhookPath;
    }

    public A withWebhookPath(String webhookPath) {
        this.webhookPath=webhookPath; return (A) this;
    }

    public Boolean hasWebhookPath() {
        return this.webhookPath != null;
    }

    public A withNewWebhookPath(String arg1) {
        return (A)withWebhookPath(new String(arg1));
    }

    public A withNewWebhookPath(StringBuilder arg1) {
        return (A)withWebhookPath(new String(arg1));
    }

    public A withNewWebhookPath(StringBuffer arg1) {
        return (A)withWebhookPath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WebhookDescriptionFluentImpl that = (WebhookDescriptionFluentImpl) o;
        if (admissionReviewVersions != null ? !admissionReviewVersions.equals(that.admissionReviewVersions) :that.admissionReviewVersions != null) return false;
        if (containerPort != null ? !containerPort.equals(that.containerPort) :that.containerPort != null) return false;
        if (conversionCRDs != null ? !conversionCRDs.equals(that.conversionCRDs) :that.conversionCRDs != null) return false;
        if (deploymentName != null ? !deploymentName.equals(that.deploymentName) :that.deploymentName != null) return false;
        if (failurePolicy != null ? !failurePolicy.equals(that.failurePolicy) :that.failurePolicy != null) return false;
        if (generateName != null ? !generateName.equals(that.generateName) :that.generateName != null) return false;
        if (matchPolicy != null ? !matchPolicy.equals(that.matchPolicy) :that.matchPolicy != null) return false;
        if (objectSelector != null ? !objectSelector.equals(that.objectSelector) :that.objectSelector != null) return false;
        if (reinvocationPolicy != null ? !reinvocationPolicy.equals(that.reinvocationPolicy) :that.reinvocationPolicy != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        if (sideEffects != null ? !sideEffects.equals(that.sideEffects) :that.sideEffects != null) return false;
        if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (webhookPath != null ? !webhookPath.equals(that.webhookPath) :that.webhookPath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(admissionReviewVersions,  containerPort,  conversionCRDs,  deploymentName,  failurePolicy,  generateName,  matchPolicy,  objectSelector,  reinvocationPolicy,  rules,  sideEffects,  timeoutSeconds,  type,  webhookPath,  super.hashCode());
    }

    public class ObjectSelectorNestedImpl<N> extends LabelSelectorFluentImpl<WebhookDescriptionFluent.ObjectSelectorNested<N>> implements WebhookDescriptionFluent.ObjectSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

        ObjectSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        ObjectSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        public N and() {
             return (N) WebhookDescriptionFluentImpl.this.withObjectSelector(builder.build());
        }

        public N endObjectSelector() {
             return and();
        }
    }


    public class RulesNestedImpl<N> extends RuleWithOperationsFluentImpl<WebhookDescriptionFluent.RulesNested<N>> implements WebhookDescriptionFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RuleWithOperationsBuilder builder;
        private final int index;

        RulesNestedImpl(int index,RuleWithOperations item) {
            this.index = index;
            this.builder = new RuleWithOperationsBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new RuleWithOperationsBuilder(this);
        }

        public N and() {
             return (N) WebhookDescriptionFluentImpl.this.setToRules(index,builder.build());
        }

        public N endRule() {
             return and();
        }
    }


}
