package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class ClusterServiceVersionListFluentImpl<A extends ClusterServiceVersionListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterServiceVersionListFluent<A> {

    private String apiVersion;
    private List<ClusterServiceVersionBuilder> items =  new ArrayList<ClusterServiceVersionBuilder>();
    private String kind;
    private ListMeta metadata;

    public ClusterServiceVersionListFluentImpl() { 
    }


    public ClusterServiceVersionListFluentImpl(ClusterServiceVersionList instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,ClusterServiceVersion item) {
        if (this.items == null) {this.items = new ArrayList<ClusterServiceVersionBuilder>();}
        ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,ClusterServiceVersion item) {
        if (this.items == null) {this.items = new ArrayList<ClusterServiceVersionBuilder>();}
        ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToItems(ClusterServiceVersion... items) {
        if (this.items == null) {this.items = new ArrayList<ClusterServiceVersionBuilder>();}
        for (ClusterServiceVersion item : items) {ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<ClusterServiceVersion> items) {
        if (this.items == null) {this.items = new ArrayList<ClusterServiceVersionBuilder>();}
        for (ClusterServiceVersion item : items) {ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(ClusterServiceVersion... items) {
        for (ClusterServiceVersion item : items) {ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<ClusterServiceVersion> items) {
        for (ClusterServiceVersion item : items) {ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<ClusterServiceVersionBuilder> predicate) {
        if (items == null) return (A) this;
        final Iterator<ClusterServiceVersionBuilder> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          ClusterServiceVersionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterServiceVersion> getItems() {
        return build(items);
    }

    public List<ClusterServiceVersion> buildItems() {
        return build(items);
    }

    public ClusterServiceVersion buildItem(int index) {
        return this.items.get(index).build();
    }

    public ClusterServiceVersion buildFirstItem() {
        return this.items.get(0).build();
    }

    public ClusterServiceVersion buildLastItem() {
        return this.items.get(items.size() - 1).build();
    }

    public ClusterServiceVersion buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterServiceVersionBuilder> predicate) {
        for (ClusterServiceVersionBuilder item: items) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterServiceVersionBuilder> predicate) {
        for (ClusterServiceVersionBuilder item: items) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withItems(List<ClusterServiceVersion> items) {
        if (this.items != null) { _visitables.get("items").removeAll(this.items);}
        if (items != null) {this.items = new ArrayList<ClusterServiceVersionBuilder>(); for (ClusterServiceVersion item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(ClusterServiceVersion... items) {
        if (this.items != null) {this.items.clear();}
        if (items != null) {for (ClusterServiceVersion item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems() {
        return items != null && !items.isEmpty();
    }

    public ClusterServiceVersionListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    public ClusterServiceVersionListFluent.ItemsNested<A> addNewItemLike(ClusterServiceVersion item) {
        return new ItemsNestedImpl(-1, item);
    }

    public ClusterServiceVersionListFluent.ItemsNested<A> setNewItemLike(int index,ClusterServiceVersion item) {
        return new ItemsNestedImpl(index, item);
    }

    public ClusterServiceVersionListFluent.ItemsNested<A> editItem(int index) {
        if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
        return setNewItemLike(index, buildItem(index));
    }

    public ClusterServiceVersionListFluent.ItemsNested<A> editFirstItem() {
        if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
        return setNewItemLike(0, buildItem(0));
    }

    public ClusterServiceVersionListFluent.ItemsNested<A> editLastItem() {
        int index = items.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
        return setNewItemLike(index, buildItem(index));
    }

    public ClusterServiceVersionListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterServiceVersionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<items.size();i++) { 
        if (predicate.apply(items.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
        return setNewItemLike(index, buildItem(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public ListMeta getMetadata() {
        return this.metadata;
    }

    public A withMetadata(ListMeta metadata) {
        this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
        return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusterServiceVersionListFluentImpl that = (ClusterServiceVersionListFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (items != null ? !items.equals(that.items) :that.items != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
    }

    public class ItemsNestedImpl<N> extends ClusterServiceVersionFluentImpl<ClusterServiceVersionListFluent.ItemsNested<N>> implements ClusterServiceVersionListFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterServiceVersionBuilder builder;
        private final int index;

        ItemsNestedImpl(int index,ClusterServiceVersion item) {
            this.index = index;
            this.builder = new ClusterServiceVersionBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ClusterServiceVersionBuilder(this);
        }

        public N and() {
             return (N) ClusterServiceVersionListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endItem() {
             return and();
        }
    }


}
