package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StrategyDeploymentSpecBuilder extends StrategyDeploymentSpecFluentImpl<StrategyDeploymentSpecBuilder> implements VisitableBuilder<StrategyDeploymentSpec,StrategyDeploymentSpecBuilder> {

    StrategyDeploymentSpecFluent<?> fluent;
    Boolean validationEnabled;

    public StrategyDeploymentSpecBuilder() { 
        this(true);
    }


    public StrategyDeploymentSpecBuilder(Boolean validationEnabled) { 
        this(new StrategyDeploymentSpec(), validationEnabled);
    }


    public StrategyDeploymentSpecBuilder(StrategyDeploymentSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public StrategyDeploymentSpecBuilder(StrategyDeploymentSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new StrategyDeploymentSpec(), validationEnabled);
    }


    public StrategyDeploymentSpecBuilder(StrategyDeploymentSpecFluent<?> fluent,StrategyDeploymentSpec instance) { 
        this(fluent, instance, true);
    }


    public StrategyDeploymentSpecBuilder(StrategyDeploymentSpecFluent<?> fluent,StrategyDeploymentSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withLabel(instance.getLabel()); 
        fluent.withName(instance.getName()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }


    public StrategyDeploymentSpecBuilder(StrategyDeploymentSpec instance) { 
        this(instance,true);
    }


    public StrategyDeploymentSpecBuilder(StrategyDeploymentSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withLabel(instance.getLabel()); 
        this.withName(instance.getName()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }


    public StrategyDeploymentSpec build() {
        StrategyDeploymentSpec buildable = new StrategyDeploymentSpec(fluent.getLabel(),fluent.getName(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StrategyDeploymentSpecBuilder that = (StrategyDeploymentSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
