package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StrategyDetailsDeploymentBuilder extends StrategyDetailsDeploymentFluentImpl<StrategyDetailsDeploymentBuilder> implements VisitableBuilder<StrategyDetailsDeployment,StrategyDetailsDeploymentBuilder> {

    StrategyDetailsDeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public StrategyDetailsDeploymentBuilder() { 
        this(true);
    }


    public StrategyDetailsDeploymentBuilder(Boolean validationEnabled) { 
        this(new StrategyDetailsDeployment(), validationEnabled);
    }


    public StrategyDetailsDeploymentBuilder(StrategyDetailsDeploymentFluent<?> fluent) { 
        this(fluent, true);
    }


    public StrategyDetailsDeploymentBuilder(StrategyDetailsDeploymentFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new StrategyDetailsDeployment(), validationEnabled);
    }


    public StrategyDetailsDeploymentBuilder(StrategyDetailsDeploymentFluent<?> fluent,StrategyDetailsDeployment instance) { 
        this(fluent, instance, true);
    }


    public StrategyDetailsDeploymentBuilder(StrategyDetailsDeploymentFluent<?> fluent,StrategyDetailsDeployment instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withClusterPermissions(instance.getClusterPermissions()); 
        fluent.withDeployments(instance.getDeployments()); 
        fluent.withPermissions(instance.getPermissions()); 
        this.validationEnabled = validationEnabled; 
    }


    public StrategyDetailsDeploymentBuilder(StrategyDetailsDeployment instance) { 
        this(instance,true);
    }


    public StrategyDetailsDeploymentBuilder(StrategyDetailsDeployment instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withClusterPermissions(instance.getClusterPermissions()); 
        this.withDeployments(instance.getDeployments()); 
        this.withPermissions(instance.getPermissions()); 
        this.validationEnabled = validationEnabled; 
    }


    public StrategyDetailsDeployment build() {
        StrategyDetailsDeployment buildable = new StrategyDetailsDeployment(fluent.getClusterPermissions(),fluent.getDeployments(),fluent.getPermissions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StrategyDetailsDeploymentBuilder that = (StrategyDetailsDeploymentBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
