package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.model.apps.DeploymentSpecBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluentImpl;

public class StrategyDeploymentSpecFluentImpl<A extends StrategyDeploymentSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StrategyDeploymentSpecFluent<A> {

    private Map<String,String> label;
    private String name;
    private DeploymentSpecBuilder spec;

    public StrategyDeploymentSpecFluentImpl() { 
    }


    public StrategyDeploymentSpecFluentImpl(StrategyDeploymentSpec instance) { 
        this.withLabel(instance.getLabel()); 
        this.withName(instance.getName()); 
        this.withSpec(instance.getSpec()); 
    }


    public A addToLabel(String key,String value) {
        if(this.label == null && key != null && value != null) { this.label = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.label.put(key, value);} return (A)this;
    }

    public A addToLabel(Map<String,String> map) {
        if(this.label == null && map != null) { this.label = new LinkedHashMap<String,String>(); }
        if(map != null) { this.label.putAll(map);} return (A)this;
    }

    public A removeFromLabel(String key) {
        if(this.label == null) { return (A) this; }
        if(key != null && this.label != null) {this.label.remove(key);} return (A)this;
    }

    public A removeFromLabel(Map<String,String> map) {
        if(this.label == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.label != null){this.label.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabel() {
        return this.label;
    }

    public A withLabel(Map<String,String> label) {
        if (label == null) { this.label =  null;} else {this.label = new LinkedHashMap<String,String>(label);} return (A) this;
    }

    public Boolean hasLabel() {
        return this.label != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public DeploymentSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public DeploymentSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(DeploymentSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new DeploymentSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public StrategyDeploymentSpecFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public StrategyDeploymentSpecFluent.SpecNested<A> withNewSpecLike(DeploymentSpec item) {
        return new SpecNestedImpl(item);
    }

    public StrategyDeploymentSpecFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public StrategyDeploymentSpecFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new DeploymentSpecBuilder().build());
    }

    public StrategyDeploymentSpecFluent.SpecNested<A> editOrNewSpecLike(DeploymentSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StrategyDeploymentSpecFluentImpl that = (StrategyDeploymentSpecFluentImpl) o;
        if (label != null ? !label.equals(that.label) :that.label != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(label,  name,  spec,  super.hashCode());
    }

    public class SpecNestedImpl<N> extends DeploymentSpecFluentImpl<StrategyDeploymentSpecFluent.SpecNested<N>> implements StrategyDeploymentSpecFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeploymentSpecBuilder builder;

        SpecNestedImpl(DeploymentSpec item) {
            this.builder = new DeploymentSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new DeploymentSpecBuilder(this);
        }

        public N and() {
             return (N) StrategyDeploymentSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endSpec() {
             return and();
        }
    }


}
