package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ActionDescriptorBuilder extends ActionDescriptorFluentImpl<ActionDescriptorBuilder> implements VisitableBuilder<ActionDescriptor,ActionDescriptorBuilder> {

    ActionDescriptorFluent<?> fluent;
    Boolean validationEnabled;

    public ActionDescriptorBuilder() { 
        this(true);
    }


    public ActionDescriptorBuilder(Boolean validationEnabled) { 
        this(new ActionDescriptor(), validationEnabled);
    }


    public ActionDescriptorBuilder(ActionDescriptorFluent<?> fluent) { 
        this(fluent, true);
    }


    public ActionDescriptorBuilder(ActionDescriptorFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ActionDescriptor(), validationEnabled);
    }


    public ActionDescriptorBuilder(ActionDescriptorFluent<?> fluent,ActionDescriptor instance) { 
        this(fluent, instance, true);
    }


    public ActionDescriptorBuilder(ActionDescriptorFluent<?> fluent,ActionDescriptor instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDescription(instance.getDescription()); 
        fluent.withDisplayName(instance.getDisplayName()); 
        fluent.withPath(instance.getPath()); 
        fluent.withValue(instance.getValue()); 
        fluent.withXDescriptors(instance.getXDescriptors()); 
        this.validationEnabled = validationEnabled; 
    }


    public ActionDescriptorBuilder(ActionDescriptor instance) { 
        this(instance,true);
    }


    public ActionDescriptorBuilder(ActionDescriptor instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDescription(instance.getDescription()); 
        this.withDisplayName(instance.getDisplayName()); 
        this.withPath(instance.getPath()); 
        this.withValue(instance.getValue()); 
        this.withXDescriptors(instance.getXDescriptors()); 
        this.validationEnabled = validationEnabled; 
    }


    public ActionDescriptor build() {
        ActionDescriptor buildable = new ActionDescriptor(fluent.getDescription(),fluent.getDisplayName(),fluent.getPath(),fluent.getValue(),fluent.getXDescriptors());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ActionDescriptorBuilder that = (ActionDescriptorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
