package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InstallPlanStatusBuilder extends InstallPlanStatusFluentImpl<InstallPlanStatusBuilder> implements VisitableBuilder<InstallPlanStatus,InstallPlanStatusBuilder> {

    InstallPlanStatusFluent<?> fluent;
    Boolean validationEnabled;

    public InstallPlanStatusBuilder() { 
        this(true);
    }


    public InstallPlanStatusBuilder(Boolean validationEnabled) { 
        this(new InstallPlanStatus(), validationEnabled);
    }


    public InstallPlanStatusBuilder(InstallPlanStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public InstallPlanStatusBuilder(InstallPlanStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new InstallPlanStatus(), validationEnabled);
    }


    public InstallPlanStatusBuilder(InstallPlanStatusFluent<?> fluent,InstallPlanStatus instance) { 
        this(fluent, instance, true);
    }


    public InstallPlanStatusBuilder(InstallPlanStatusFluent<?> fluent,InstallPlanStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAttenuatedServiceAccountRef(instance.getAttenuatedServiceAccountRef()); 
        fluent.withBundleLookups(instance.getBundleLookups()); 
        fluent.withCatalogSources(instance.getCatalogSources()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withPlan(instance.getPlan()); 
        this.validationEnabled = validationEnabled; 
    }


    public InstallPlanStatusBuilder(InstallPlanStatus instance) { 
        this(instance,true);
    }


    public InstallPlanStatusBuilder(InstallPlanStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAttenuatedServiceAccountRef(instance.getAttenuatedServiceAccountRef()); 
        this.withBundleLookups(instance.getBundleLookups()); 
        this.withCatalogSources(instance.getCatalogSources()); 
        this.withConditions(instance.getConditions()); 
        this.withPhase(instance.getPhase()); 
        this.withPlan(instance.getPlan()); 
        this.validationEnabled = validationEnabled; 
    }


    public InstallPlanStatus build() {
        InstallPlanStatus buildable = new InstallPlanStatus(fluent.getAttenuatedServiceAccountRef(),fluent.getBundleLookups(),fluent.getCatalogSources(),fluent.getConditions(),fluent.getPhase(),fluent.getPlan());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InstallPlanStatusBuilder that = (InstallPlanStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
