package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface OperatorGroupListFluent<A extends OperatorGroupListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,OperatorGroup item);
    public A setToItems(int index,OperatorGroup item);
    public A addToItems(OperatorGroup... items);
    public A addAllToItems(Collection<OperatorGroup> items);
    public A removeFromItems(OperatorGroup... items);
    public A removeAllFromItems(Collection<OperatorGroup> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<OperatorGroupBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorGroup> getItems();
    public List<OperatorGroup> buildItems();
    public OperatorGroup buildItem(int index);
    public OperatorGroup buildFirstItem();
    public OperatorGroup buildLastItem();
    public OperatorGroup buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<OperatorGroupBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<OperatorGroupBuilder> predicate);
    public A withItems(List<OperatorGroup> items);
    public A withItems(OperatorGroup... items);
    public Boolean hasItems();
    public OperatorGroupListFluent.ItemsNested<A> addNewItem();
    public OperatorGroupListFluent.ItemsNested<A> addNewItemLike(OperatorGroup item);
    public OperatorGroupListFluent.ItemsNested<A> setNewItemLike(int index,OperatorGroup item);
    public OperatorGroupListFluent.ItemsNested<A> editItem(int index);
    public OperatorGroupListFluent.ItemsNested<A> editFirstItem();
    public OperatorGroupListFluent.ItemsNested<A> editLastItem();
    public OperatorGroupListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<OperatorGroupBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorGroupFluent<OperatorGroupListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
