package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StatusDescriptorBuilder extends StatusDescriptorFluentImpl<StatusDescriptorBuilder> implements VisitableBuilder<StatusDescriptor,StatusDescriptorBuilder>{

    StatusDescriptorFluent<?> fluent;
    Boolean validationEnabled;

    public StatusDescriptorBuilder(){
            this(true);
    }
    public StatusDescriptorBuilder(Boolean validationEnabled){
            this(new StatusDescriptor(), validationEnabled);
    }
    public StatusDescriptorBuilder(StatusDescriptorFluent<?> fluent){
            this(fluent, true);
    }
    public StatusDescriptorBuilder(StatusDescriptorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StatusDescriptor(), validationEnabled);
    }
    public StatusDescriptorBuilder(StatusDescriptorFluent<?> fluent,StatusDescriptor instance){
            this(fluent, instance, true);
    }
    public StatusDescriptorBuilder(StatusDescriptorFluent<?> fluent,StatusDescriptor instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDescription(instance.getDescription()); 
            fluent.withDisplayName(instance.getDisplayName()); 
            fluent.withPath(instance.getPath()); 
            fluent.withValue(instance.getValue()); 
            fluent.withXDescriptors(instance.getXDescriptors()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatusDescriptorBuilder(StatusDescriptor instance){
            this(instance,true);
    }
    public StatusDescriptorBuilder(StatusDescriptor instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDescription(instance.getDescription()); 
            this.withDisplayName(instance.getDisplayName()); 
            this.withPath(instance.getPath()); 
            this.withValue(instance.getValue()); 
            this.withXDescriptors(instance.getXDescriptors()); 
            this.validationEnabled = validationEnabled; 
    }

    public StatusDescriptor build(){
            StatusDescriptor buildable = new StatusDescriptor(fluent.getDescription(),fluent.getDisplayName(),fluent.getPath(),fluent.getValue(),fluent.getXDescriptors());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatusDescriptorBuilder that = (StatusDescriptorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
