package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RegistryPollBuilder extends RegistryPollFluentImpl<RegistryPollBuilder> implements VisitableBuilder<RegistryPoll,RegistryPollBuilder>{

    RegistryPollFluent<?> fluent;
    Boolean validationEnabled;

    public RegistryPollBuilder(){
            this(true);
    }
    public RegistryPollBuilder(Boolean validationEnabled){
            this(new RegistryPoll(), validationEnabled);
    }
    public RegistryPollBuilder(RegistryPollFluent<?> fluent){
            this(fluent, true);
    }
    public RegistryPollBuilder(RegistryPollFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RegistryPoll(), validationEnabled);
    }
    public RegistryPollBuilder(RegistryPollFluent<?> fluent,RegistryPoll instance){
            this(fluent, instance, true);
    }
    public RegistryPollBuilder(RegistryPollFluent<?> fluent,RegistryPoll instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withInterval(instance.getInterval()); 
            this.validationEnabled = validationEnabled; 
    }
    public RegistryPollBuilder(RegistryPoll instance){
            this(instance,true);
    }
    public RegistryPollBuilder(RegistryPoll instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withInterval(instance.getInterval()); 
            this.validationEnabled = validationEnabled; 
    }

    public RegistryPoll build(){
            RegistryPoll buildable = new RegistryPoll(fluent.getInterval());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RegistryPollBuilder that = (RegistryPollBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
