package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CustomResourceDefinitionsFluentImpl<A extends CustomResourceDefinitionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CustomResourceDefinitionsFluent<A>{

    private List<CRDDescriptionBuilder> owned =  new ArrayList<CRDDescriptionBuilder>();
    private List<CRDDescriptionBuilder> required =  new ArrayList<CRDDescriptionBuilder>();

    public CustomResourceDefinitionsFluentImpl(){
    }
    public CustomResourceDefinitionsFluentImpl(CustomResourceDefinitions instance){
            this.withOwned(instance.getOwned()); 
            this.withRequired(instance.getRequired()); 
    }

    public A addToOwned(int index,CRDDescription item){
            if (this.owned == null) {this.owned = new ArrayList<CRDDescriptionBuilder>();}
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("owned").add(index >= 0 ? index : _visitables.get("owned").size(), builder);this.owned.add(index >= 0 ? index : owned.size(), builder); return (A)this;
    }

    public A setToOwned(int index,CRDDescription item){
            if (this.owned == null) {this.owned = new ArrayList<CRDDescriptionBuilder>();}
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
            if (index < 0 || index >= _visitables.get("owned").size()) { _visitables.get("owned").add(builder); } else { _visitables.get("owned").set(index, builder);}
            if (index < 0 || index >= owned.size()) { owned.add(builder); } else { owned.set(index, builder);}
             return (A)this;
    }

    public A addToOwned(CRDDescription... items){
            if (this.owned == null) {this.owned = new ArrayList<CRDDescriptionBuilder>();}
            for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("owned").add(builder);this.owned.add(builder);} return (A)this;
    }

    public A addAllToOwned(Collection<CRDDescription> items){
            if (this.owned == null) {this.owned = new ArrayList<CRDDescriptionBuilder>();}
            for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("owned").add(builder);this.owned.add(builder);} return (A)this;
    }

    public A removeFromOwned(CRDDescription... items){
            for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("owned").remove(builder);if (this.owned != null) {this.owned.remove(builder);}} return (A)this;
    }

    public A removeAllFromOwned(Collection<CRDDescription> items){
            for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("owned").remove(builder);if (this.owned != null) {this.owned.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOwned(io.fabric8.kubernetes.api.builder.Predicate<CRDDescriptionBuilder> predicate){
            if (owned == null) return (A) this;
            final Iterator<CRDDescriptionBuilder> each = owned.iterator();
            final List visitables = _visitables.get("owned");
            while (each.hasNext()) {
              CRDDescriptionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOwned instead.
 * @return The buildable object.
 */
@Deprecated public List<CRDDescription> getOwned(){
            return build(owned);
    }

    public List<CRDDescription> buildOwned(){
            return build(owned);
    }

    public CRDDescription buildOwned(int index){
            return this.owned.get(index).build();
    }

    public CRDDescription buildFirstOwned(){
            return this.owned.get(0).build();
    }

    public CRDDescription buildLastOwned(){
            return this.owned.get(owned.size() - 1).build();
    }

    public CRDDescription buildMatchingOwned(io.fabric8.kubernetes.api.builder.Predicate<CRDDescriptionBuilder> predicate){
            for (CRDDescriptionBuilder item: owned) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingOwned(io.fabric8.kubernetes.api.builder.Predicate<CRDDescriptionBuilder> predicate){
            for (CRDDescriptionBuilder item: owned) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withOwned(List<CRDDescription> owned){
            if (this.owned != null) { _visitables.get("owned").removeAll(this.owned);}
            if (owned != null) {this.owned = new ArrayList<CRDDescriptionBuilder>(); for (CRDDescription item : owned){this.addToOwned(item);}} else { this.owned = null;} return (A) this;
    }

    public A withOwned(CRDDescription... owned){
            if (this.owned != null) {this.owned.clear();}
            if (owned != null) {for (CRDDescription item :owned){ this.addToOwned(item);}} return (A) this;
    }

    public Boolean hasOwned(){
            return owned != null && !owned.isEmpty();
    }

    public CustomResourceDefinitionsFluent.OwnedNested<A> addNewOwned(){
            return new OwnedNestedImpl();
    }

    public CustomResourceDefinitionsFluent.OwnedNested<A> addNewOwnedLike(CRDDescription item){
            return new OwnedNestedImpl(-1, item);
    }

    public CustomResourceDefinitionsFluent.OwnedNested<A> setNewOwnedLike(int index,CRDDescription item){
            return new OwnedNestedImpl(index, item);
    }

    public CustomResourceDefinitionsFluent.OwnedNested<A> editOwned(int index){
            if (owned.size() <= index) throw new RuntimeException("Can't edit owned. Index exceeds size.");
            return setNewOwnedLike(index, buildOwned(index));
    }

    public CustomResourceDefinitionsFluent.OwnedNested<A> editFirstOwned(){
            if (owned.size() == 0) throw new RuntimeException("Can't edit first owned. The list is empty.");
            return setNewOwnedLike(0, buildOwned(0));
    }

    public CustomResourceDefinitionsFluent.OwnedNested<A> editLastOwned(){
            int index = owned.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last owned. The list is empty.");
            return setNewOwnedLike(index, buildOwned(index));
    }

    public CustomResourceDefinitionsFluent.OwnedNested<A> editMatchingOwned(io.fabric8.kubernetes.api.builder.Predicate<CRDDescriptionBuilder> predicate){
            int index = -1;
            for (int i=0;i<owned.size();i++) { 
            if (predicate.apply(owned.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching owned. No match found.");
            return setNewOwnedLike(index, buildOwned(index));
    }

    public A addToRequired(int index,CRDDescription item){
            if (this.required == null) {this.required = new ArrayList<CRDDescriptionBuilder>();}
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("required").add(index >= 0 ? index : _visitables.get("required").size(), builder);this.required.add(index >= 0 ? index : required.size(), builder); return (A)this;
    }

    public A setToRequired(int index,CRDDescription item){
            if (this.required == null) {this.required = new ArrayList<CRDDescriptionBuilder>();}
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
            if (index < 0 || index >= _visitables.get("required").size()) { _visitables.get("required").add(builder); } else { _visitables.get("required").set(index, builder);}
            if (index < 0 || index >= required.size()) { required.add(builder); } else { required.set(index, builder);}
             return (A)this;
    }

    public A addToRequired(CRDDescription... items){
            if (this.required == null) {this.required = new ArrayList<CRDDescriptionBuilder>();}
            for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("required").add(builder);this.required.add(builder);} return (A)this;
    }

    public A addAllToRequired(Collection<CRDDescription> items){
            if (this.required == null) {this.required = new ArrayList<CRDDescriptionBuilder>();}
            for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("required").add(builder);this.required.add(builder);} return (A)this;
    }

    public A removeFromRequired(CRDDescription... items){
            for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("required").remove(builder);if (this.required != null) {this.required.remove(builder);}} return (A)this;
    }

    public A removeAllFromRequired(Collection<CRDDescription> items){
            for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("required").remove(builder);if (this.required != null) {this.required.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRequired(io.fabric8.kubernetes.api.builder.Predicate<CRDDescriptionBuilder> predicate){
            if (required == null) return (A) this;
            final Iterator<CRDDescriptionBuilder> each = required.iterator();
            final List visitables = _visitables.get("required");
            while (each.hasNext()) {
              CRDDescriptionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRequired instead.
 * @return The buildable object.
 */
@Deprecated public List<CRDDescription> getRequired(){
            return build(required);
    }

    public List<CRDDescription> buildRequired(){
            return build(required);
    }

    public CRDDescription buildRequired(int index){
            return this.required.get(index).build();
    }

    public CRDDescription buildFirstRequired(){
            return this.required.get(0).build();
    }

    public CRDDescription buildLastRequired(){
            return this.required.get(required.size() - 1).build();
    }

    public CRDDescription buildMatchingRequired(io.fabric8.kubernetes.api.builder.Predicate<CRDDescriptionBuilder> predicate){
            for (CRDDescriptionBuilder item: required) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRequired(io.fabric8.kubernetes.api.builder.Predicate<CRDDescriptionBuilder> predicate){
            for (CRDDescriptionBuilder item: required) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRequired(List<CRDDescription> required){
            if (this.required != null) { _visitables.get("required").removeAll(this.required);}
            if (required != null) {this.required = new ArrayList<CRDDescriptionBuilder>(); for (CRDDescription item : required){this.addToRequired(item);}} else { this.required = null;} return (A) this;
    }

    public A withRequired(CRDDescription... required){
            if (this.required != null) {this.required.clear();}
            if (required != null) {for (CRDDescription item :required){ this.addToRequired(item);}} return (A) this;
    }

    public Boolean hasRequired(){
            return required != null && !required.isEmpty();
    }

    public CustomResourceDefinitionsFluent.RequiredNested<A> addNewRequired(){
            return new RequiredNestedImpl();
    }

    public CustomResourceDefinitionsFluent.RequiredNested<A> addNewRequiredLike(CRDDescription item){
            return new RequiredNestedImpl(-1, item);
    }

    public CustomResourceDefinitionsFluent.RequiredNested<A> setNewRequiredLike(int index,CRDDescription item){
            return new RequiredNestedImpl(index, item);
    }

    public CustomResourceDefinitionsFluent.RequiredNested<A> editRequired(int index){
            if (required.size() <= index) throw new RuntimeException("Can't edit required. Index exceeds size.");
            return setNewRequiredLike(index, buildRequired(index));
    }

    public CustomResourceDefinitionsFluent.RequiredNested<A> editFirstRequired(){
            if (required.size() == 0) throw new RuntimeException("Can't edit first required. The list is empty.");
            return setNewRequiredLike(0, buildRequired(0));
    }

    public CustomResourceDefinitionsFluent.RequiredNested<A> editLastRequired(){
            int index = required.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last required. The list is empty.");
            return setNewRequiredLike(index, buildRequired(index));
    }

    public CustomResourceDefinitionsFluent.RequiredNested<A> editMatchingRequired(io.fabric8.kubernetes.api.builder.Predicate<CRDDescriptionBuilder> predicate){
            int index = -1;
            for (int i=0;i<required.size();i++) { 
            if (predicate.apply(required.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching required. No match found.");
            return setNewRequiredLike(index, buildRequired(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CustomResourceDefinitionsFluentImpl that = (CustomResourceDefinitionsFluentImpl) o;
            if (owned != null ? !owned.equals(that.owned) :that.owned != null) return false;
            if (required != null ? !required.equals(that.required) :that.required != null) return false;
            return true;
    }


    public class OwnedNestedImpl<N> extends CRDDescriptionFluentImpl<CustomResourceDefinitionsFluent.OwnedNested<N>> implements CustomResourceDefinitionsFluent.OwnedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CRDDescriptionBuilder builder;
        private final int index;
    
            OwnedNestedImpl(int index,CRDDescription item){
                    this.index = index;
                    this.builder = new CRDDescriptionBuilder(this, item);
            }
            OwnedNestedImpl(){
                    this.index = -1;
                    this.builder = new CRDDescriptionBuilder(this);
            }
    
    public N and(){
            return (N) CustomResourceDefinitionsFluentImpl.this.setToOwned(index,builder.build());
    }
    public N endOwned(){
            return and();
    }

}
    public class RequiredNestedImpl<N> extends CRDDescriptionFluentImpl<CustomResourceDefinitionsFluent.RequiredNested<N>> implements CustomResourceDefinitionsFluent.RequiredNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CRDDescriptionBuilder builder;
        private final int index;
    
            RequiredNestedImpl(int index,CRDDescription item){
                    this.index = index;
                    this.builder = new CRDDescriptionBuilder(this, item);
            }
            RequiredNestedImpl(){
                    this.index = -1;
                    this.builder = new CRDDescriptionBuilder(this);
            }
    
    public N and(){
            return (N) CustomResourceDefinitionsFluentImpl.this.setToRequired(index,builder.build());
    }
    public N endRequired(){
            return and();
    }

}


}
