package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CatalogSourceBuilder extends CatalogSourceFluentImpl<CatalogSourceBuilder> implements VisitableBuilder<CatalogSource,CatalogSourceBuilder>{

    CatalogSourceFluent<?> fluent;
    Boolean validationEnabled;

    public CatalogSourceBuilder(){
            this(true);
    }
    public CatalogSourceBuilder(Boolean validationEnabled){
            this(new CatalogSource(), validationEnabled);
    }
    public CatalogSourceBuilder(CatalogSourceFluent<?> fluent){
            this(fluent, true);
    }
    public CatalogSourceBuilder(CatalogSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CatalogSource(), validationEnabled);
    }
    public CatalogSourceBuilder(CatalogSourceFluent<?> fluent,CatalogSource instance){
            this(fluent, instance, true);
    }
    public CatalogSourceBuilder(CatalogSourceFluent<?> fluent,CatalogSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public CatalogSourceBuilder(CatalogSource instance){
            this(instance,true);
    }
    public CatalogSourceBuilder(CatalogSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public CatalogSource build(){
            CatalogSource buildable = new CatalogSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CatalogSourceBuilder that = (CatalogSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
