package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorVersionBuilder extends OperatorVersionFluentImpl<OperatorVersionBuilder> implements VisitableBuilder<OperatorVersion,OperatorVersionBuilder>{

    OperatorVersionFluent<?> fluent;
    Boolean validationEnabled;

    public OperatorVersionBuilder(){
            this(true);
    }
    public OperatorVersionBuilder(Boolean validationEnabled){
            this(new OperatorVersion(), validationEnabled);
    }
    public OperatorVersionBuilder(OperatorVersionFluent<?> fluent){
            this(fluent, true);
    }
    public OperatorVersionBuilder(OperatorVersionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OperatorVersion(), validationEnabled);
    }
    public OperatorVersionBuilder(OperatorVersionFluent<?> fluent,OperatorVersion instance){
            this(fluent, instance, true);
    }
    public OperatorVersionBuilder(OperatorVersionFluent<?> fluent,OperatorVersion instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public OperatorVersionBuilder(OperatorVersion instance){
            this(instance,true);
    }
    public OperatorVersionBuilder(OperatorVersion instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public OperatorVersion build(){
            OperatorVersion buildable = new OperatorVersion();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OperatorVersionBuilder that = (OperatorVersionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
