package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

public class InstallPlanStatusFluentImpl<A extends InstallPlanStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements InstallPlanStatusFluent<A>{

    private ObjectReferenceBuilder attenuatedServiceAccountRef;
    private List<BundleLookupBuilder> bundleLookups =  new ArrayList<BundleLookupBuilder>();
    private List<String> catalogSources = new ArrayList<String>();
    private List<InstallPlanConditionBuilder> conditions =  new ArrayList<InstallPlanConditionBuilder>();
    private String phase;
    private List<StepBuilder> plan =  new ArrayList<StepBuilder>();

    public InstallPlanStatusFluentImpl(){
    }
    public InstallPlanStatusFluentImpl(InstallPlanStatus instance){
            this.withAttenuatedServiceAccountRef(instance.getAttenuatedServiceAccountRef()); 
            this.withBundleLookups(instance.getBundleLookups()); 
            this.withCatalogSources(instance.getCatalogSources()); 
            this.withConditions(instance.getConditions()); 
            this.withPhase(instance.getPhase()); 
            this.withPlan(instance.getPlan()); 
    }

    
/**
 * This method has been deprecated, please use method buildAttenuatedServiceAccountRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getAttenuatedServiceAccountRef(){
            return this.attenuatedServiceAccountRef!=null?this.attenuatedServiceAccountRef.build():null;
    }

    public ObjectReference buildAttenuatedServiceAccountRef(){
            return this.attenuatedServiceAccountRef!=null?this.attenuatedServiceAccountRef.build():null;
    }

    public A withAttenuatedServiceAccountRef(ObjectReference attenuatedServiceAccountRef){
            _visitables.get("attenuatedServiceAccountRef").remove(this.attenuatedServiceAccountRef);
            if (attenuatedServiceAccountRef!=null){ this.attenuatedServiceAccountRef= new ObjectReferenceBuilder(attenuatedServiceAccountRef); _visitables.get("attenuatedServiceAccountRef").add(this.attenuatedServiceAccountRef);} return (A) this;
    }

    public Boolean hasAttenuatedServiceAccountRef(){
            return this.attenuatedServiceAccountRef != null;
    }

    public InstallPlanStatusFluent.AttenuatedServiceAccountRefNested<A> withNewAttenuatedServiceAccountRef(){
            return new AttenuatedServiceAccountRefNestedImpl();
    }

    public InstallPlanStatusFluent.AttenuatedServiceAccountRefNested<A> withNewAttenuatedServiceAccountRefLike(ObjectReference item){
            return new AttenuatedServiceAccountRefNestedImpl(item);
    }

    public InstallPlanStatusFluent.AttenuatedServiceAccountRefNested<A> editAttenuatedServiceAccountRef(){
            return withNewAttenuatedServiceAccountRefLike(getAttenuatedServiceAccountRef());
    }

    public InstallPlanStatusFluent.AttenuatedServiceAccountRefNested<A> editOrNewAttenuatedServiceAccountRef(){
            return withNewAttenuatedServiceAccountRefLike(getAttenuatedServiceAccountRef() != null ? getAttenuatedServiceAccountRef(): new ObjectReferenceBuilder().build());
    }

    public InstallPlanStatusFluent.AttenuatedServiceAccountRefNested<A> editOrNewAttenuatedServiceAccountRefLike(ObjectReference item){
            return withNewAttenuatedServiceAccountRefLike(getAttenuatedServiceAccountRef() != null ? getAttenuatedServiceAccountRef(): item);
    }

    public A addToBundleLookups(int index,BundleLookup item){
            if (this.bundleLookups == null) {this.bundleLookups = new ArrayList<BundleLookupBuilder>();}
            BundleLookupBuilder builder = new BundleLookupBuilder(item);_visitables.get("bundleLookups").add(index >= 0 ? index : _visitables.get("bundleLookups").size(), builder);this.bundleLookups.add(index >= 0 ? index : bundleLookups.size(), builder); return (A)this;
    }

    public A setToBundleLookups(int index,BundleLookup item){
            if (this.bundleLookups == null) {this.bundleLookups = new ArrayList<BundleLookupBuilder>();}
            BundleLookupBuilder builder = new BundleLookupBuilder(item);
            if (index < 0 || index >= _visitables.get("bundleLookups").size()) { _visitables.get("bundleLookups").add(builder); } else { _visitables.get("bundleLookups").set(index, builder);}
            if (index < 0 || index >= bundleLookups.size()) { bundleLookups.add(builder); } else { bundleLookups.set(index, builder);}
             return (A)this;
    }

    public A addToBundleLookups(BundleLookup... items){
            if (this.bundleLookups == null) {this.bundleLookups = new ArrayList<BundleLookupBuilder>();}
            for (BundleLookup item : items) {BundleLookupBuilder builder = new BundleLookupBuilder(item);_visitables.get("bundleLookups").add(builder);this.bundleLookups.add(builder);} return (A)this;
    }

    public A addAllToBundleLookups(Collection<BundleLookup> items){
            if (this.bundleLookups == null) {this.bundleLookups = new ArrayList<BundleLookupBuilder>();}
            for (BundleLookup item : items) {BundleLookupBuilder builder = new BundleLookupBuilder(item);_visitables.get("bundleLookups").add(builder);this.bundleLookups.add(builder);} return (A)this;
    }

    public A removeFromBundleLookups(BundleLookup... items){
            for (BundleLookup item : items) {BundleLookupBuilder builder = new BundleLookupBuilder(item);_visitables.get("bundleLookups").remove(builder);if (this.bundleLookups != null) {this.bundleLookups.remove(builder);}} return (A)this;
    }

    public A removeAllFromBundleLookups(Collection<BundleLookup> items){
            for (BundleLookup item : items) {BundleLookupBuilder builder = new BundleLookupBuilder(item);_visitables.get("bundleLookups").remove(builder);if (this.bundleLookups != null) {this.bundleLookups.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBundleLookups(io.fabric8.kubernetes.api.builder.Predicate<BundleLookupBuilder> predicate){
            if (bundleLookups == null) return (A) this;
            final Iterator<BundleLookupBuilder> each = bundleLookups.iterator();
            final List visitables = _visitables.get("bundleLookups");
            while (each.hasNext()) {
              BundleLookupBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildBundleLookups instead.
 * @return The buildable object.
 */
@Deprecated public List<BundleLookup> getBundleLookups(){
            return build(bundleLookups);
    }

    public List<BundleLookup> buildBundleLookups(){
            return build(bundleLookups);
    }

    public BundleLookup buildBundleLookup(int index){
            return this.bundleLookups.get(index).build();
    }

    public BundleLookup buildFirstBundleLookup(){
            return this.bundleLookups.get(0).build();
    }

    public BundleLookup buildLastBundleLookup(){
            return this.bundleLookups.get(bundleLookups.size() - 1).build();
    }

    public BundleLookup buildMatchingBundleLookup(io.fabric8.kubernetes.api.builder.Predicate<BundleLookupBuilder> predicate){
            for (BundleLookupBuilder item: bundleLookups) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingBundleLookup(io.fabric8.kubernetes.api.builder.Predicate<BundleLookupBuilder> predicate){
            for (BundleLookupBuilder item: bundleLookups) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withBundleLookups(List<BundleLookup> bundleLookups){
            if (this.bundleLookups != null) { _visitables.get("bundleLookups").removeAll(this.bundleLookups);}
            if (bundleLookups != null) {this.bundleLookups = new ArrayList<BundleLookupBuilder>(); for (BundleLookup item : bundleLookups){this.addToBundleLookups(item);}} else { this.bundleLookups = null;} return (A) this;
    }

    public A withBundleLookups(BundleLookup... bundleLookups){
            if (this.bundleLookups != null) {this.bundleLookups.clear();}
            if (bundleLookups != null) {for (BundleLookup item :bundleLookups){ this.addToBundleLookups(item);}} return (A) this;
    }

    public Boolean hasBundleLookups(){
            return bundleLookups != null && !bundleLookups.isEmpty();
    }

    public InstallPlanStatusFluent.BundleLookupsNested<A> addNewBundleLookup(){
            return new BundleLookupsNestedImpl();
    }

    public InstallPlanStatusFluent.BundleLookupsNested<A> addNewBundleLookupLike(BundleLookup item){
            return new BundleLookupsNestedImpl(-1, item);
    }

    public InstallPlanStatusFluent.BundleLookupsNested<A> setNewBundleLookupLike(int index,BundleLookup item){
            return new BundleLookupsNestedImpl(index, item);
    }

    public InstallPlanStatusFluent.BundleLookupsNested<A> editBundleLookup(int index){
            if (bundleLookups.size() <= index) throw new RuntimeException("Can't edit bundleLookups. Index exceeds size.");
            return setNewBundleLookupLike(index, buildBundleLookup(index));
    }

    public InstallPlanStatusFluent.BundleLookupsNested<A> editFirstBundleLookup(){
            if (bundleLookups.size() == 0) throw new RuntimeException("Can't edit first bundleLookups. The list is empty.");
            return setNewBundleLookupLike(0, buildBundleLookup(0));
    }

    public InstallPlanStatusFluent.BundleLookupsNested<A> editLastBundleLookup(){
            int index = bundleLookups.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last bundleLookups. The list is empty.");
            return setNewBundleLookupLike(index, buildBundleLookup(index));
    }

    public InstallPlanStatusFluent.BundleLookupsNested<A> editMatchingBundleLookup(io.fabric8.kubernetes.api.builder.Predicate<BundleLookupBuilder> predicate){
            int index = -1;
            for (int i=0;i<bundleLookups.size();i++) { 
            if (predicate.apply(bundleLookups.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching bundleLookups. No match found.");
            return setNewBundleLookupLike(index, buildBundleLookup(index));
    }

    public A addToCatalogSources(int index,String item){
            if (this.catalogSources == null) {this.catalogSources = new ArrayList<String>();}
            this.catalogSources.add(index, item);
            return (A)this;
    }

    public A setToCatalogSources(int index,String item){
            if (this.catalogSources == null) {this.catalogSources = new ArrayList<String>();}
            this.catalogSources.set(index, item); return (A)this;
    }

    public A addToCatalogSources(String... items){
            if (this.catalogSources == null) {this.catalogSources = new ArrayList<String>();}
            for (String item : items) {this.catalogSources.add(item);} return (A)this;
    }

    public A addAllToCatalogSources(Collection<String> items){
            if (this.catalogSources == null) {this.catalogSources = new ArrayList<String>();}
            for (String item : items) {this.catalogSources.add(item);} return (A)this;
    }

    public A removeFromCatalogSources(String... items){
            for (String item : items) {if (this.catalogSources!= null){ this.catalogSources.remove(item);}} return (A)this;
    }

    public A removeAllFromCatalogSources(Collection<String> items){
            for (String item : items) {if (this.catalogSources!= null){ this.catalogSources.remove(item);}} return (A)this;
    }

    public List<String> getCatalogSources(){
            return this.catalogSources;
    }

    public String getCatalogSource(int index){
            return this.catalogSources.get(index);
    }

    public String getFirstCatalogSource(){
            return this.catalogSources.get(0);
    }

    public String getLastCatalogSource(){
            return this.catalogSources.get(catalogSources.size() - 1);
    }

    public String getMatchingCatalogSource(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: catalogSources) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCatalogSource(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: catalogSources) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withCatalogSources(List<String> catalogSources){
            if (this.catalogSources != null) { _visitables.get("catalogSources").removeAll(this.catalogSources);}
            if (catalogSources != null) {this.catalogSources = new ArrayList<String>(); for (String item : catalogSources){this.addToCatalogSources(item);}} else { this.catalogSources = null;} return (A) this;
    }

    public A withCatalogSources(String... catalogSources){
            if (this.catalogSources != null) {this.catalogSources.clear();}
            if (catalogSources != null) {for (String item :catalogSources){ this.addToCatalogSources(item);}} return (A) this;
    }

    public Boolean hasCatalogSources(){
            return catalogSources != null && !catalogSources.isEmpty();
    }

    public A addNewCatalogSource(String arg1){
            return (A)addToCatalogSources(new String(arg1));
    }

    public A addNewCatalogSource(StringBuilder arg1){
            return (A)addToCatalogSources(new String(arg1));
    }

    public A addNewCatalogSource(StringBuffer arg1){
            return (A)addToCatalogSources(new String(arg1));
    }

    public A addToConditions(int index,InstallPlanCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<InstallPlanConditionBuilder>();}
            InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,InstallPlanCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<InstallPlanConditionBuilder>();}
            InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(InstallPlanCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<InstallPlanConditionBuilder>();}
            for (InstallPlanCondition item : items) {InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<InstallPlanCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<InstallPlanConditionBuilder>();}
            for (InstallPlanCondition item : items) {InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(InstallPlanCondition... items){
            for (InstallPlanCondition item : items) {InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<InstallPlanCondition> items){
            for (InstallPlanCondition item : items) {InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<InstallPlanConditionBuilder> predicate){
            if (conditions == null) return (A) this;
            final Iterator<InstallPlanConditionBuilder> each = conditions.iterator();
            final List visitables = _visitables.get("conditions");
            while (each.hasNext()) {
              InstallPlanConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<InstallPlanCondition> getConditions(){
            return build(conditions);
    }

    public List<InstallPlanCondition> buildConditions(){
            return build(conditions);
    }

    public InstallPlanCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public InstallPlanCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public InstallPlanCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public InstallPlanCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<InstallPlanConditionBuilder> predicate){
            for (InstallPlanConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<InstallPlanConditionBuilder> predicate){
            for (InstallPlanConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<InstallPlanCondition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<InstallPlanConditionBuilder>(); for (InstallPlanCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(InstallPlanCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (InstallPlanCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public InstallPlanStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public InstallPlanStatusFluent.ConditionsNested<A> addNewConditionLike(InstallPlanCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public InstallPlanStatusFluent.ConditionsNested<A> setNewConditionLike(int index,InstallPlanCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public InstallPlanStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public InstallPlanStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public InstallPlanStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public InstallPlanStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<InstallPlanConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public String getPhase(){
            return this.phase;
    }

    public A withPhase(String phase){
            this.phase=phase; return (A) this;
    }

    public Boolean hasPhase(){
            return this.phase != null;
    }

    public A withNewPhase(String arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1){
            return (A)withPhase(new String(arg1));
    }

    public A addToPlan(int index,Step item){
            if (this.plan == null) {this.plan = new ArrayList<StepBuilder>();}
            StepBuilder builder = new StepBuilder(item);_visitables.get("plan").add(index >= 0 ? index : _visitables.get("plan").size(), builder);this.plan.add(index >= 0 ? index : plan.size(), builder); return (A)this;
    }

    public A setToPlan(int index,Step item){
            if (this.plan == null) {this.plan = new ArrayList<StepBuilder>();}
            StepBuilder builder = new StepBuilder(item);
            if (index < 0 || index >= _visitables.get("plan").size()) { _visitables.get("plan").add(builder); } else { _visitables.get("plan").set(index, builder);}
            if (index < 0 || index >= plan.size()) { plan.add(builder); } else { plan.set(index, builder);}
             return (A)this;
    }

    public A addToPlan(Step... items){
            if (this.plan == null) {this.plan = new ArrayList<StepBuilder>();}
            for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("plan").add(builder);this.plan.add(builder);} return (A)this;
    }

    public A addAllToPlan(Collection<Step> items){
            if (this.plan == null) {this.plan = new ArrayList<StepBuilder>();}
            for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("plan").add(builder);this.plan.add(builder);} return (A)this;
    }

    public A removeFromPlan(Step... items){
            for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("plan").remove(builder);if (this.plan != null) {this.plan.remove(builder);}} return (A)this;
    }

    public A removeAllFromPlan(Collection<Step> items){
            for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("plan").remove(builder);if (this.plan != null) {this.plan.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPlan(io.fabric8.kubernetes.api.builder.Predicate<StepBuilder> predicate){
            if (plan == null) return (A) this;
            final Iterator<StepBuilder> each = plan.iterator();
            final List visitables = _visitables.get("plan");
            while (each.hasNext()) {
              StepBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPlan instead.
 * @return The buildable object.
 */
@Deprecated public List<Step> getPlan(){
            return build(plan);
    }

    public List<Step> buildPlan(){
            return build(plan);
    }

    public Step buildPlan(int index){
            return this.plan.get(index).build();
    }

    public Step buildFirstPlan(){
            return this.plan.get(0).build();
    }

    public Step buildLastPlan(){
            return this.plan.get(plan.size() - 1).build();
    }

    public Step buildMatchingPlan(io.fabric8.kubernetes.api.builder.Predicate<StepBuilder> predicate){
            for (StepBuilder item: plan) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPlan(io.fabric8.kubernetes.api.builder.Predicate<StepBuilder> predicate){
            for (StepBuilder item: plan) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPlan(List<Step> plan){
            if (this.plan != null) { _visitables.get("plan").removeAll(this.plan);}
            if (plan != null) {this.plan = new ArrayList<StepBuilder>(); for (Step item : plan){this.addToPlan(item);}} else { this.plan = null;} return (A) this;
    }

    public A withPlan(Step... plan){
            if (this.plan != null) {this.plan.clear();}
            if (plan != null) {for (Step item :plan){ this.addToPlan(item);}} return (A) this;
    }

    public Boolean hasPlan(){
            return plan != null && !plan.isEmpty();
    }

    public InstallPlanStatusFluent.PlanNested<A> addNewPlan(){
            return new PlanNestedImpl();
    }

    public InstallPlanStatusFluent.PlanNested<A> addNewPlanLike(Step item){
            return new PlanNestedImpl(-1, item);
    }

    public InstallPlanStatusFluent.PlanNested<A> setNewPlanLike(int index,Step item){
            return new PlanNestedImpl(index, item);
    }

    public InstallPlanStatusFluent.PlanNested<A> editPlan(int index){
            if (plan.size() <= index) throw new RuntimeException("Can't edit plan. Index exceeds size.");
            return setNewPlanLike(index, buildPlan(index));
    }

    public InstallPlanStatusFluent.PlanNested<A> editFirstPlan(){
            if (plan.size() == 0) throw new RuntimeException("Can't edit first plan. The list is empty.");
            return setNewPlanLike(0, buildPlan(0));
    }

    public InstallPlanStatusFluent.PlanNested<A> editLastPlan(){
            int index = plan.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last plan. The list is empty.");
            return setNewPlanLike(index, buildPlan(index));
    }

    public InstallPlanStatusFluent.PlanNested<A> editMatchingPlan(io.fabric8.kubernetes.api.builder.Predicate<StepBuilder> predicate){
            int index = -1;
            for (int i=0;i<plan.size();i++) { 
            if (predicate.apply(plan.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching plan. No match found.");
            return setNewPlanLike(index, buildPlan(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            InstallPlanStatusFluentImpl that = (InstallPlanStatusFluentImpl) o;
            if (attenuatedServiceAccountRef != null ? !attenuatedServiceAccountRef.equals(that.attenuatedServiceAccountRef) :that.attenuatedServiceAccountRef != null) return false;
            if (bundleLookups != null ? !bundleLookups.equals(that.bundleLookups) :that.bundleLookups != null) return false;
            if (catalogSources != null ? !catalogSources.equals(that.catalogSources) :that.catalogSources != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
            if (plan != null ? !plan.equals(that.plan) :that.plan != null) return false;
            return true;
    }


    public class AttenuatedServiceAccountRefNestedImpl<N> extends ObjectReferenceFluentImpl<InstallPlanStatusFluent.AttenuatedServiceAccountRefNested<N>> implements InstallPlanStatusFluent.AttenuatedServiceAccountRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            AttenuatedServiceAccountRefNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            AttenuatedServiceAccountRefNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) InstallPlanStatusFluentImpl.this.withAttenuatedServiceAccountRef(builder.build());
    }
    public N endAttenuatedServiceAccountRef(){
            return and();
    }

}
    public class BundleLookupsNestedImpl<N> extends BundleLookupFluentImpl<InstallPlanStatusFluent.BundleLookupsNested<N>> implements InstallPlanStatusFluent.BundleLookupsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BundleLookupBuilder builder;
        private final int index;
    
            BundleLookupsNestedImpl(int index,BundleLookup item){
                    this.index = index;
                    this.builder = new BundleLookupBuilder(this, item);
            }
            BundleLookupsNestedImpl(){
                    this.index = -1;
                    this.builder = new BundleLookupBuilder(this);
            }
    
    public N and(){
            return (N) InstallPlanStatusFluentImpl.this.setToBundleLookups(index,builder.build());
    }
    public N endBundleLookup(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends InstallPlanConditionFluentImpl<InstallPlanStatusFluent.ConditionsNested<N>> implements InstallPlanStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InstallPlanConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,InstallPlanCondition item){
                    this.index = index;
                    this.builder = new InstallPlanConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new InstallPlanConditionBuilder(this);
            }
    
    public N and(){
            return (N) InstallPlanStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class PlanNestedImpl<N> extends StepFluentImpl<InstallPlanStatusFluent.PlanNested<N>> implements InstallPlanStatusFluent.PlanNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StepBuilder builder;
        private final int index;
    
            PlanNestedImpl(int index,Step item){
                    this.index = index;
                    this.builder = new StepBuilder(this, item);
            }
            PlanNestedImpl(){
                    this.index = -1;
                    this.builder = new StepBuilder(this);
            }
    
    public N and(){
            return (N) InstallPlanStatusFluentImpl.this.setToPlan(index,builder.build());
    }
    public N endPlan(){
            return and();
    }

}


}
