package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class InstallPlanSpecFluentImpl<A extends InstallPlanSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements InstallPlanSpecFluent<A>{

    private String approval;
    private Boolean approved;
    private List<String> clusterServiceVersionNames = new ArrayList<String>();
    private Integer generation;
    private String source;
    private String sourceNamespace;

    public InstallPlanSpecFluentImpl(){
    }
    public InstallPlanSpecFluentImpl(InstallPlanSpec instance){
            this.withApproval(instance.getApproval()); 
            this.withApproved(instance.getApproved()); 
            this.withClusterServiceVersionNames(instance.getClusterServiceVersionNames()); 
            this.withGeneration(instance.getGeneration()); 
            this.withSource(instance.getSource()); 
            this.withSourceNamespace(instance.getSourceNamespace()); 
    }

    public String getApproval(){
            return this.approval;
    }

    public A withApproval(String approval){
            this.approval=approval; return (A) this;
    }

    public Boolean hasApproval(){
            return this.approval != null;
    }

    public A withNewApproval(String arg1){
            return (A)withApproval(new String(arg1));
    }

    public A withNewApproval(StringBuilder arg1){
            return (A)withApproval(new String(arg1));
    }

    public A withNewApproval(StringBuffer arg1){
            return (A)withApproval(new String(arg1));
    }

    public Boolean isApproved(){
            return this.approved;
    }

    public A withApproved(Boolean approved){
            this.approved=approved; return (A) this;
    }

    public Boolean hasApproved(){
            return this.approved != null;
    }

    public A withNewApproved(String arg1){
            return (A)withApproved(new Boolean(arg1));
    }

    public A withNewApproved(boolean arg1){
            return (A)withApproved(new Boolean(arg1));
    }

    public A addToClusterServiceVersionNames(int index,String item){
            if (this.clusterServiceVersionNames == null) {this.clusterServiceVersionNames = new ArrayList<String>();}
            this.clusterServiceVersionNames.add(index, item);
            return (A)this;
    }

    public A setToClusterServiceVersionNames(int index,String item){
            if (this.clusterServiceVersionNames == null) {this.clusterServiceVersionNames = new ArrayList<String>();}
            this.clusterServiceVersionNames.set(index, item); return (A)this;
    }

    public A addToClusterServiceVersionNames(String... items){
            if (this.clusterServiceVersionNames == null) {this.clusterServiceVersionNames = new ArrayList<String>();}
            for (String item : items) {this.clusterServiceVersionNames.add(item);} return (A)this;
    }

    public A addAllToClusterServiceVersionNames(Collection<String> items){
            if (this.clusterServiceVersionNames == null) {this.clusterServiceVersionNames = new ArrayList<String>();}
            for (String item : items) {this.clusterServiceVersionNames.add(item);} return (A)this;
    }

    public A removeFromClusterServiceVersionNames(String... items){
            for (String item : items) {if (this.clusterServiceVersionNames!= null){ this.clusterServiceVersionNames.remove(item);}} return (A)this;
    }

    public A removeAllFromClusterServiceVersionNames(Collection<String> items){
            for (String item : items) {if (this.clusterServiceVersionNames!= null){ this.clusterServiceVersionNames.remove(item);}} return (A)this;
    }

    public List<String> getClusterServiceVersionNames(){
            return this.clusterServiceVersionNames;
    }

    public String getClusterServiceVersionName(int index){
            return this.clusterServiceVersionNames.get(index);
    }

    public String getFirstClusterServiceVersionName(){
            return this.clusterServiceVersionNames.get(0);
    }

    public String getLastClusterServiceVersionName(){
            return this.clusterServiceVersionNames.get(clusterServiceVersionNames.size() - 1);
    }

    public String getMatchingClusterServiceVersionName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: clusterServiceVersionNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingClusterServiceVersionName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: clusterServiceVersionNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withClusterServiceVersionNames(List<String> clusterServiceVersionNames){
            if (this.clusterServiceVersionNames != null) { _visitables.get("clusterServiceVersionNames").removeAll(this.clusterServiceVersionNames);}
            if (clusterServiceVersionNames != null) {this.clusterServiceVersionNames = new ArrayList<String>(); for (String item : clusterServiceVersionNames){this.addToClusterServiceVersionNames(item);}} else { this.clusterServiceVersionNames = null;} return (A) this;
    }

    public A withClusterServiceVersionNames(String... clusterServiceVersionNames){
            if (this.clusterServiceVersionNames != null) {this.clusterServiceVersionNames.clear();}
            if (clusterServiceVersionNames != null) {for (String item :clusterServiceVersionNames){ this.addToClusterServiceVersionNames(item);}} return (A) this;
    }

    public Boolean hasClusterServiceVersionNames(){
            return clusterServiceVersionNames != null && !clusterServiceVersionNames.isEmpty();
    }

    public A addNewClusterServiceVersionName(String arg1){
            return (A)addToClusterServiceVersionNames(new String(arg1));
    }

    public A addNewClusterServiceVersionName(StringBuilder arg1){
            return (A)addToClusterServiceVersionNames(new String(arg1));
    }

    public A addNewClusterServiceVersionName(StringBuffer arg1){
            return (A)addToClusterServiceVersionNames(new String(arg1));
    }

    public Integer getGeneration(){
            return this.generation;
    }

    public A withGeneration(Integer generation){
            this.generation=generation; return (A) this;
    }

    public Boolean hasGeneration(){
            return this.generation != null;
    }

    public String getSource(){
            return this.source;
    }

    public A withSource(String source){
            this.source=source; return (A) this;
    }

    public Boolean hasSource(){
            return this.source != null;
    }

    public A withNewSource(String arg1){
            return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuilder arg1){
            return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuffer arg1){
            return (A)withSource(new String(arg1));
    }

    public String getSourceNamespace(){
            return this.sourceNamespace;
    }

    public A withSourceNamespace(String sourceNamespace){
            this.sourceNamespace=sourceNamespace; return (A) this;
    }

    public Boolean hasSourceNamespace(){
            return this.sourceNamespace != null;
    }

    public A withNewSourceNamespace(String arg1){
            return (A)withSourceNamespace(new String(arg1));
    }

    public A withNewSourceNamespace(StringBuilder arg1){
            return (A)withSourceNamespace(new String(arg1));
    }

    public A withNewSourceNamespace(StringBuffer arg1){
            return (A)withSourceNamespace(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            InstallPlanSpecFluentImpl that = (InstallPlanSpecFluentImpl) o;
            if (approval != null ? !approval.equals(that.approval) :that.approval != null) return false;
            if (approved != null ? !approved.equals(that.approved) :that.approved != null) return false;
            if (clusterServiceVersionNames != null ? !clusterServiceVersionNames.equals(that.clusterServiceVersionNames) :that.clusterServiceVersionNames != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (source != null ? !source.equals(that.source) :that.source != null) return false;
            if (sourceNamespace != null ? !sourceNamespace.equals(that.sourceNamespace) :that.sourceNamespace != null) return false;
            return true;
    }




}
