package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface InstallPlanSpecFluent<A extends InstallPlanSpecFluent<A>> extends Fluent<A>{


    public String getApproval();
    public A withApproval(String approval);
    public Boolean hasApproval();
    public A withNewApproval(String arg1);
    public A withNewApproval(StringBuilder arg1);
    public A withNewApproval(StringBuffer arg1);
    public Boolean isApproved();
    public A withApproved(Boolean approved);
    public Boolean hasApproved();
    public A withNewApproved(String arg1);
    public A withNewApproved(boolean arg1);
    public A addToClusterServiceVersionNames(int index,String item);
    public A setToClusterServiceVersionNames(int index,String item);
    public A addToClusterServiceVersionNames(String... items);
    public A addAllToClusterServiceVersionNames(Collection<String> items);
    public A removeFromClusterServiceVersionNames(String... items);
    public A removeAllFromClusterServiceVersionNames(Collection<String> items);
    public List<String> getClusterServiceVersionNames();
    public String getClusterServiceVersionName(int index);
    public String getFirstClusterServiceVersionName();
    public String getLastClusterServiceVersionName();
    public String getMatchingClusterServiceVersionName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingClusterServiceVersionName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withClusterServiceVersionNames(List<String> clusterServiceVersionNames);
    public A withClusterServiceVersionNames(String... clusterServiceVersionNames);
    public Boolean hasClusterServiceVersionNames();
    public A addNewClusterServiceVersionName(String arg1);
    public A addNewClusterServiceVersionName(StringBuilder arg1);
    public A addNewClusterServiceVersionName(StringBuffer arg1);
    public Integer getGeneration();
    public A withGeneration(Integer generation);
    public Boolean hasGeneration();
    public String getSource();
    public A withSource(String source);
    public Boolean hasSource();
    public A withNewSource(String arg1);
    public A withNewSource(StringBuilder arg1);
    public A withNewSource(StringBuffer arg1);
    public String getSourceNamespace();
    public A withSourceNamespace(String sourceNamespace);
    public Boolean hasSourceNamespace();
    public A withNewSourceNamespace(String arg1);
    public A withNewSourceNamespace(StringBuilder arg1);
    public A withNewSourceNamespace(StringBuffer arg1);



}
