package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface CatalogSourceSpecFluent<A extends CatalogSourceSpecFluent<A>> extends Fluent<A>{


    public String getAddress();
    public A withAddress(String address);
    public Boolean hasAddress();
    public A withNewAddress(String arg1);
    public A withNewAddress(StringBuilder arg1);
    public A withNewAddress(StringBuffer arg1);
    public String getConfigMap();
    public A withConfigMap(String configMap);
    public Boolean hasConfigMap();
    public A withNewConfigMap(String arg1);
    public A withNewConfigMap(StringBuilder arg1);
    public A withNewConfigMap(StringBuffer arg1);
    public String getDescription();
    public A withDescription(String description);
    public Boolean hasDescription();
    public A withNewDescription(String arg1);
    public A withNewDescription(StringBuilder arg1);
    public A withNewDescription(StringBuffer arg1);
    public String getDisplayName();
    public A withDisplayName(String displayName);
    public Boolean hasDisplayName();
    public A withNewDisplayName(String arg1);
    public A withNewDisplayName(StringBuilder arg1);
    public A withNewDisplayName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildIcon instead.
 * @return The buildable object.
 */
@Deprecated public Icon getIcon();
    public Icon buildIcon();
    public A withIcon(Icon icon);
    public Boolean hasIcon();
    public A withNewIcon(String base64data,String mediatype);
    public CatalogSourceSpecFluent.IconNested<A> withNewIcon();
    public CatalogSourceSpecFluent.IconNested<A> withNewIconLike(Icon item);
    public CatalogSourceSpecFluent.IconNested<A> editIcon();
    public CatalogSourceSpecFluent.IconNested<A> editOrNewIcon();
    public CatalogSourceSpecFluent.IconNested<A> editOrNewIconLike(Icon item);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public Integer getPriority();
    public A withPriority(Integer priority);
    public Boolean hasPriority();
    public String getPublisher();
    public A withPublisher(String publisher);
    public Boolean hasPublisher();
    public A withNewPublisher(String arg1);
    public A withNewPublisher(StringBuilder arg1);
    public A withNewPublisher(StringBuffer arg1);
    public A addToSecrets(int index,String item);
    public A setToSecrets(int index,String item);
    public A addToSecrets(String... items);
    public A addAllToSecrets(Collection<String> items);
    public A removeFromSecrets(String... items);
    public A removeAllFromSecrets(Collection<String> items);
    public List<String> getSecrets();
    public String getSecret(int index);
    public String getFirstSecret();
    public String getLastSecret();
    public String getMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withSecrets(List<String> secrets);
    public A withSecrets(String... secrets);
    public Boolean hasSecrets();
    public A addNewSecret(String arg1);
    public A addNewSecret(StringBuilder arg1);
    public A addNewSecret(StringBuffer arg1);
    public String getSourceType();
    public A withSourceType(String sourceType);
    public Boolean hasSourceType();
    public A withNewSourceType(String arg1);
    public A withNewSourceType(StringBuilder arg1);
    public A withNewSourceType(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildUpdateStrategy instead.
 * @return The buildable object.
 */
@Deprecated public UpdateStrategy getUpdateStrategy();
    public UpdateStrategy buildUpdateStrategy();
    public A withUpdateStrategy(UpdateStrategy updateStrategy);
    public Boolean hasUpdateStrategy();
    public CatalogSourceSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy();
    public CatalogSourceSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(UpdateStrategy item);
    public CatalogSourceSpecFluent.UpdateStrategyNested<A> editUpdateStrategy();
    public CatalogSourceSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy();
    public CatalogSourceSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(UpdateStrategy item);

    public interface IconNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IconFluent<CatalogSourceSpecFluent.IconNested<N>>{

        
    public N and();    public N endIcon();
}
    public interface UpdateStrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UpdateStrategyFluent<CatalogSourceSpecFluent.UpdateStrategyNested<N>>{

        
    public N and();    public N endUpdateStrategy();
}


}
