package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface CatalogSourceFluent<A extends CatalogSourceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public CatalogSourceFluent.MetadataNested<A> withNewMetadata();
    public CatalogSourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public CatalogSourceFluent.MetadataNested<A> editMetadata();
    public CatalogSourceFluent.MetadataNested<A> editOrNewMetadata();
    public CatalogSourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public CatalogSourceSpec getSpec();
    public CatalogSourceSpec buildSpec();
    public A withSpec(CatalogSourceSpec spec);
    public Boolean hasSpec();
    public CatalogSourceFluent.SpecNested<A> withNewSpec();
    public CatalogSourceFluent.SpecNested<A> withNewSpecLike(CatalogSourceSpec item);
    public CatalogSourceFluent.SpecNested<A> editSpec();
    public CatalogSourceFluent.SpecNested<A> editOrNewSpec();
    public CatalogSourceFluent.SpecNested<A> editOrNewSpecLike(CatalogSourceSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public CatalogSourceStatus getStatus();
    public CatalogSourceStatus buildStatus();
    public A withStatus(CatalogSourceStatus status);
    public Boolean hasStatus();
    public CatalogSourceFluent.StatusNested<A> withNewStatus();
    public CatalogSourceFluent.StatusNested<A> withNewStatusLike(CatalogSourceStatus item);
    public CatalogSourceFluent.StatusNested<A> editStatus();
    public CatalogSourceFluent.StatusNested<A> editOrNewStatus();
    public CatalogSourceFluent.StatusNested<A> editOrNewStatusLike(CatalogSourceStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<CatalogSourceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CatalogSourceSpecFluent<CatalogSourceFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CatalogSourceStatusFluent<CatalogSourceFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
